/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.transforms;

import java.time.temporal.ChronoUnit;
import org.apache.iceberg.expressions.BoundPredicate;
import org.apache.iceberg.expressions.BoundTransform;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.UnboundPredicate;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.shaded.com.google.errorprone.annotations.Immutable;
import org.apache.iceberg.transforms.Dates;
import org.apache.iceberg.transforms.ProjectionUtil;
import org.apache.iceberg.transforms.TimeTransform;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.transforms.TransformUtil;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.DateTimeUtil;
import org.apache.iceberg.util.SerializableFunction;

enum Timestamps implements Transform<Long, Integer>
{
    MICROS_TO_YEAR(ChronoUnit.YEARS, "year", TimestampUnit.MICROS),
    MICROS_TO_MONTH(ChronoUnit.MONTHS, "month", TimestampUnit.MICROS),
    MICROS_TO_DAY(ChronoUnit.DAYS, "day", TimestampUnit.MICROS),
    MICROS_TO_HOUR(ChronoUnit.HOURS, "hour", TimestampUnit.MICROS),
    NANOS_TO_YEAR(ChronoUnit.YEARS, "year", TimestampUnit.NANOS),
    NANOS_TO_MONTH(ChronoUnit.MONTHS, "month", TimestampUnit.NANOS),
    NANOS_TO_DAY(ChronoUnit.DAYS, "day", TimestampUnit.NANOS),
    NANOS_TO_HOUR(ChronoUnit.HOURS, "hour", TimestampUnit.NANOS);

    private final ChronoUnit granularity;
    private final String name;
    private final Apply apply;

    private Timestamps(ChronoUnit granularity, String name, TimestampUnit timestampUnit) {
        this.name = name;
        this.granularity = granularity;
        this.apply = new Apply(granularity, timestampUnit);
    }

    @Override
    @Deprecated
    public Integer apply(Long timestamp) {
        return this.apply.apply(timestamp);
    }

    @Override
    public SerializableFunction<Long, Integer> bind(Type type) {
        Preconditions.checkArgument(this.canTransform(type), "Cannot bind to unsupported type: %s", (Object)type);
        return this.apply;
    }

    @Override
    public boolean canTransform(Type type) {
        return type.typeId() == Type.TypeID.TIMESTAMP || type.typeId() == Type.TypeID.TIMESTAMP_NANO;
    }

    @Override
    public Type getResultType(Type sourceType) {
        if (this.granularity == ChronoUnit.DAYS) {
            return Types.DateType.get();
        }
        return Types.IntegerType.get();
    }

    ChronoUnit granularity() {
        return this.granularity;
    }

    @Override
    public boolean preservesOrder() {
        return true;
    }

    @Override
    public boolean satisfiesOrderOf(Transform<?, ?> other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Dates) {
            return TransformUtil.satisfiesOrderOf(this.granularity, ((Dates)other).granularity());
        }
        if (other instanceof Timestamps) {
            return TransformUtil.satisfiesOrderOf(this.granularity, ((Timestamps)other).granularity());
        }
        if (other instanceof TimeTransform) {
            return TransformUtil.satisfiesOrderOf(this.granularity, ((TimeTransform)other).granularity());
        }
        return false;
    }

    @Override
    public UnboundPredicate<Integer> project(String fieldName, BoundPredicate<Long> pred) {
        if (pred.term() instanceof BoundTransform) {
            return ProjectionUtil.projectTransformPredicate(this, fieldName, pred);
        }
        if (pred.isUnaryPredicate()) {
            return Expressions.predicate(pred.op(), fieldName);
        }
        if (pred.isLiteralPredicate()) {
            UnboundPredicate<Integer> projected = ProjectionUtil.truncateLong(fieldName, pred.asLiteralPredicate(), this.apply);
            return ProjectionUtil.fixInclusiveTimeProjection(projected);
        }
        if (pred.isSetPredicate() && pred.op() == Expression.Operation.IN) {
            UnboundPredicate<Integer> projected = ProjectionUtil.transformSet(fieldName, pred.asSetPredicate(), this.apply);
            return ProjectionUtil.fixInclusiveTimeProjection(projected);
        }
        return null;
    }

    @Override
    public UnboundPredicate<Integer> projectStrict(String fieldName, BoundPredicate<Long> pred) {
        if (pred.term() instanceof BoundTransform) {
            return ProjectionUtil.projectTransformPredicate(this, fieldName, pred);
        }
        if (pred.isUnaryPredicate()) {
            return Expressions.predicate(pred.op(), fieldName);
        }
        if (pred.isLiteralPredicate()) {
            UnboundPredicate<Integer> projected = ProjectionUtil.truncateLongStrict(fieldName, pred.asLiteralPredicate(), this.apply);
            return ProjectionUtil.fixStrictTimeProjection(projected);
        }
        if (pred.isSetPredicate() && pred.op() == Expression.Operation.NOT_IN) {
            UnboundPredicate<Integer> projected = ProjectionUtil.transformSet(fieldName, pred.asSetPredicate(), this.apply);
            return ProjectionUtil.fixStrictTimeProjection(projected);
        }
        return null;
    }

    @Override
    public String toHumanString(Type outputType, Integer value) {
        if (value == null) {
            return "null";
        }
        switch (this.granularity) {
            case YEARS: {
                return TransformUtil.humanYear(value);
            }
            case MONTHS: {
                return TransformUtil.humanMonth(value);
            }
            case DAYS: {
                return TransformUtil.humanDay(value);
            }
            case HOURS: {
                return TransformUtil.humanHour(value);
            }
        }
        throw new UnsupportedOperationException("Unsupported time unit: " + String.valueOf(this.granularity));
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String dedupName() {
        return "time";
    }

    @Immutable
    static class Apply
    implements SerializableFunction<Long, Integer> {
        private final ChronoUnit granularity;
        private final TimestampUnit timestampUnit;

        Apply(ChronoUnit granularity, TimestampUnit timestampUnit) {
            this.granularity = granularity;
            this.timestampUnit = timestampUnit;
        }

        @Override
        public Integer apply(Long timestamp) {
            if (timestamp == null) {
                return null;
            }
            switch (this.timestampUnit) {
                case MICROS: {
                    switch (this.granularity) {
                        case YEARS: {
                            return DateTimeUtil.microsToYears(timestamp);
                        }
                        case MONTHS: {
                            return DateTimeUtil.microsToMonths(timestamp);
                        }
                        case DAYS: {
                            return DateTimeUtil.microsToDays(timestamp);
                        }
                        case HOURS: {
                            return DateTimeUtil.microsToHours(timestamp);
                        }
                    }
                    throw new UnsupportedOperationException("Unsupported time unit: " + String.valueOf(this.granularity));
                }
                case NANOS: {
                    switch (this.granularity) {
                        case YEARS: {
                            return DateTimeUtil.nanosToYears(timestamp);
                        }
                        case MONTHS: {
                            return DateTimeUtil.nanosToMonths(timestamp);
                        }
                        case DAYS: {
                            return DateTimeUtil.nanosToDays(timestamp);
                        }
                        case HOURS: {
                            return DateTimeUtil.nanosToHours(timestamp);
                        }
                    }
                    throw new UnsupportedOperationException("Unsupported time unit: " + String.valueOf(this.granularity));
                }
            }
            throw new UnsupportedOperationException("Unsupported time unit: " + String.valueOf((Object)this.timestampUnit));
        }
    }

    static enum TimestampUnit {
        MICROS,
        NANOS;

    }
}

