/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.types;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.UnicodeUtil;

public class Comparators {
    private static final ImmutableMap<Type.PrimitiveType, Comparator<?>> COMPARATORS = ImmutableMap.builder().put(Types.BooleanType.get(), Comparator.naturalOrder()).put((Types.BooleanType)((Object)Types.IntegerType.get()), Comparator.naturalOrder()).put((Types.BooleanType)((Object)Types.LongType.get()), Comparator.naturalOrder()).put((Types.BooleanType)((Object)Types.FloatType.get()), Comparator.naturalOrder()).put((Types.BooleanType)((Object)Types.DoubleType.get()), Comparator.naturalOrder()).put((Types.BooleanType)((Object)Types.DateType.get()), Comparator.naturalOrder()).put((Types.BooleanType)((Object)Types.TimeType.get()), Comparator.naturalOrder()).put((Types.BooleanType)((Object)Types.TimestampType.withZone()), Comparator.naturalOrder()).put((Types.BooleanType)((Object)Types.TimestampType.withoutZone()), Comparator.naturalOrder()).put((Types.BooleanType)((Object)Types.TimestampNanoType.withZone()), Comparator.naturalOrder()).put((Types.BooleanType)((Object)Types.TimestampNanoType.withoutZone()), Comparator.naturalOrder()).put((Types.BooleanType)((Object)Types.StringType.get()), Comparators.charSequences()).put((Types.BooleanType)((Object)Types.UUIDType.get()), Comparator.naturalOrder()).put((Types.BooleanType)((Object)Types.BinaryType.get()), Comparators.unsignedBytes()).buildOrThrow();

    private Comparators() {
    }

    public static Comparator<StructLike> forType(Types.StructType struct) {
        return new StructLikeComparator(struct);
    }

    public static <T> Comparator<List<T>> forType(Types.ListType list) {
        return new ListComparator(list);
    }

    public static <K, V> Comparator<Map<K, V>> forType(Types.MapType mapType) {
        return new MapComparator(mapType);
    }

    public static <T> Comparator<T> forType(Type.PrimitiveType type) {
        Comparator<?> cmp = COMPARATORS.get(type);
        if (cmp != null) {
            return cmp;
        }
        if (type instanceof Types.FixedType) {
            return Comparators.unsignedBytes();
        }
        if (type instanceof Types.DecimalType) {
            return Comparator.naturalOrder();
        }
        throw new UnsupportedOperationException("Cannot determine comparator for type: " + String.valueOf(type));
    }

    private static <T> Comparator<T> internal(Type type) {
        if (type.isPrimitiveType()) {
            return Comparators.forType(type.asPrimitiveType());
        }
        if (type.isStructType()) {
            return Comparators.forType(type.asStructType());
        }
        if (type.isListType()) {
            return Comparators.forType(type.asListType());
        }
        if (type.isMapType()) {
            return Comparators.forType(type.asMapType());
        }
        throw new UnsupportedOperationException("Cannot determine comparator for type: " + String.valueOf(type));
    }

    public static Comparator<ByteBuffer> unsignedBytes() {
        return UnsignedByteBufComparator.INSTANCE;
    }

    public static Comparator<byte[]> unsignedByteArrays() {
        return UnsignedByteArrayComparator.INSTANCE;
    }

    public static Comparator<ByteBuffer> signedBytes() {
        return Comparator.naturalOrder();
    }

    public static <T> Comparator<T> nullsFirst() {
        return NullsFirst.INSTANCE;
    }

    public static <T> Comparator<T> nullsLast() {
        return NullsLast.INSTANCE;
    }

    public static Comparator<CharSequence> charSequences() {
        return CharSeqComparator.INSTANCE;
    }

    public static Comparator<CharSequence> filePath() {
        return FilePathComparator.INSTANCE;
    }

    private static class StructLikeComparator
    implements Comparator<StructLike> {
        private final Comparator<Object>[] comparators;
        private final Class<?>[] classes;

        private StructLikeComparator(Types.StructType struct) {
            this.comparators = (Comparator[])struct.fields().stream().map(field -> field.isOptional() ? Comparators.nullsFirst().thenComparing(Comparators.internal(field.type())) : Comparators.internal(field.type())).toArray(Comparator[]::new);
            this.classes = (Class[])struct.fields().stream().map(field -> field.type().typeId().javaClass()).toArray(Class[]::new);
        }

        @Override
        public int compare(StructLike o1, StructLike o2) {
            if (o1 == o2) {
                return 0;
            }
            for (int i = 0; i < this.comparators.length; ++i) {
                Class<?> valueClass = this.classes[i];
                int cmp = this.comparators[i].compare(o1.get(i, valueClass), o2.get(i, valueClass));
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        }
    }

    private static class ListComparator<T>
    implements Comparator<List<T>> {
        private final Comparator<T> elementComparator;

        private ListComparator(Types.ListType list) {
            Comparator elemComparator = Comparators.internal(list.elementType());
            this.elementComparator = list.isElementOptional() ? Comparators.nullsFirst().thenComparing(elemComparator) : elemComparator;
        }

        @Override
        public int compare(List<T> o1, List<T> o2) {
            if (o1 == o2) {
                return 0;
            }
            int length = Math.min(o1.size(), o2.size());
            for (int i = 0; i < length; ++i) {
                int cmp = this.elementComparator.compare(o1.get(i), o2.get(i));
                if (cmp == 0) continue;
                return cmp;
            }
            return Integer.compare(o1.size(), o2.size());
        }
    }

    private static class MapComparator<K, V>
    implements Comparator<Map<K, V>> {
        private final Comparator<K> keyComparator;
        private final Comparator<V> valueComparator;
        private final Comparator<List<K>> keyListComparator;

        private MapComparator(Types.MapType mapType) {
            this.keyComparator = Comparators.internal(mapType.keyType());
            this.valueComparator = mapType.isValueOptional() ? Comparators.nullsFirst().thenComparing(Comparators.internal(mapType.valueType())) : Comparators.internal(mapType.valueType());
            this.keyListComparator = Comparators.internal(Types.ListType.ofRequired(mapType.keyId(), mapType.keyType()));
        }

        @Override
        public int compare(Map<K, V> o1, Map<K, V> o2) {
            if (o1 == o2) {
                return 0;
            }
            ArrayList<K> keys1 = Lists.newArrayList(o1.keySet());
            ArrayList<K> keys2 = Lists.newArrayList(o2.keySet());
            keys1.sort(this.keyComparator);
            keys2.sort(this.keyComparator);
            int cmp = this.keyListComparator.compare(keys1, keys2);
            if (cmp != 0) {
                return cmp;
            }
            for (Object key : keys1) {
                V value2;
                V value1 = o1.get(key);
                cmp = this.valueComparator.compare(value1, value2 = o2.get(key));
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        }
    }

    private static class UnsignedByteBufComparator
    implements Comparator<ByteBuffer> {
        private static final UnsignedByteBufComparator INSTANCE = new UnsignedByteBufComparator();

        private UnsignedByteBufComparator() {
        }

        @Override
        public int compare(ByteBuffer buf1, ByteBuffer buf2) {
            if (buf1 == buf2) {
                return 0;
            }
            int len = Math.min(buf1.remaining(), buf2.remaining());
            int b1pos = buf1.position();
            int b2pos = buf2.position();
            for (int i = 0; i < len; ++i) {
                int cmp = Integer.compare(buf1.get(b1pos + i) & 0xFF, buf2.get(b2pos + i) & 0xFF);
                if (cmp == 0) continue;
                return cmp;
            }
            return Integer.compare(buf1.remaining(), buf2.remaining());
        }
    }

    private static class UnsignedByteArrayComparator
    implements Comparator<byte[]> {
        private static final UnsignedByteArrayComparator INSTANCE = new UnsignedByteArrayComparator();

        private UnsignedByteArrayComparator() {
        }

        @Override
        public int compare(byte[] array1, byte[] array2) {
            if (array1 == array2) {
                return 0;
            }
            int len = Math.min(array1.length, array2.length);
            for (int i = 0; i < len; ++i) {
                int cmp = Integer.compare(array1[i] & 0xFF, array2[i] & 0xFF);
                if (cmp == 0) continue;
                return cmp;
            }
            return Integer.compare(array1.length, array2.length);
        }
    }

    private static class NullsFirst<T>
    implements Comparator<T> {
        private static final NullsFirst<?> INSTANCE = new NullsFirst();

        private NullsFirst() {
        }

        @Override
        public int compare(T o1, T o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 != null) {
                if (o2 != null) {
                    return 0;
                }
                return 1;
            }
            return -1;
        }

        @Override
        public Comparator<T> thenComparing(Comparator<? super T> other) {
            return new NullSafeChainedComparator<T>(this, other);
        }
    }

    private static class NullsLast<T>
    implements Comparator<T> {
        private static final NullsLast<?> INSTANCE = new NullsLast();

        private NullsLast() {
        }

        @Override
        public int compare(T o1, T o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 != null) {
                if (o2 != null) {
                    return 0;
                }
                return -1;
            }
            return 1;
        }

        @Override
        public Comparator<T> thenComparing(Comparator<? super T> other) {
            return new NullSafeChainedComparator<T>(this, other);
        }
    }

    private static class CharSeqComparator
    implements Comparator<CharSequence> {
        private static final CharSeqComparator INSTANCE = new CharSeqComparator();

        private CharSeqComparator() {
        }

        @Override
        public int compare(CharSequence s1, CharSequence s2) {
            if (s1 == s2) {
                return 0;
            }
            int len = Math.min(s1.length(), s2.length());
            for (int i = 0; i < len; ++i) {
                char c1 = s1.charAt(i);
                char c2 = s2.charAt(i);
                boolean isC1HighSurrogate = UnicodeUtil.isCharHighSurrogate(c1);
                boolean isC2HighSurrogate = UnicodeUtil.isCharHighSurrogate(c2);
                if (isC1HighSurrogate && !isC2HighSurrogate) {
                    return 1;
                }
                if (!isC1HighSurrogate && isC2HighSurrogate) {
                    return -1;
                }
                int cmp = Character.compare(c1, c2);
                if (cmp == 0) continue;
                return cmp;
            }
            return Integer.compare(s1.length(), s2.length());
        }
    }

    private static class FilePathComparator
    implements Comparator<CharSequence> {
        private static final FilePathComparator INSTANCE = new FilePathComparator();

        private FilePathComparator() {
        }

        @Override
        public int compare(CharSequence s1, CharSequence s2) {
            if (s1 == s2) {
                return 0;
            }
            int count = s1.length();
            int cmp = Integer.compare(count, s2.length());
            if (cmp != 0) {
                return cmp;
            }
            if (s1 instanceof String && s2 instanceof String && (cmp = Integer.compare(s1.hashCode(), s2.hashCode())) != 0) {
                return cmp;
            }
            for (int i = count - 1; i >= 0; --i) {
                cmp = Character.compare(s1.charAt(i), s2.charAt(i));
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        }
    }

    private static class NullSafeChainedComparator<T>
    implements Comparator<T> {
        private final Comparator<T> first;
        private final Comparator<? super T> second;

        NullSafeChainedComparator(Comparator<T> first, Comparator<? super T> second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public int compare(T o1, T o2) {
            if (o1 == o2) {
                return 0;
            }
            int cmp = this.first.compare(o1, o2);
            if (cmp == 0 && o1 != null) {
                return this.second.compare(o1, o2);
            }
            return cmp;
        }
    }
}

