/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.io.Serializable;
import java.lang.reflect.Type;
import org.apache.iceberg.relocated.com.google.common.base.Objects;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.shaded.com.github.benmanes.caffeine.cache.CacheLoader;
import org.apache.iceberg.shaded.com.github.benmanes.caffeine.cache.Caffeine;
import org.apache.iceberg.shaded.com.github.benmanes.caffeine.cache.LoadingCache;
import org.apache.iceberg.shaded.org.apache.avro.Schema;
import org.apache.iceberg.shaded.org.apache.avro.generic.IndexedRecord;
import org.apache.iceberg.shaded.org.apache.avro.reflect.ReflectData;
import org.apache.iceberg.shaded.org.apache.avro.specific.SpecificData;

public class Pair<X, Y>
implements IndexedRecord,
SpecificData.SchemaConstructable,
Serializable {
    private static final LoadingCache<Pair<Class<?>, Class<?>>, Schema> SCHEMA_CACHE = Caffeine.newBuilder().build(new CacheLoader<Pair<Class<?>, Class<?>>, Schema>(){

        @Override
        public Schema load(Pair<Class<?>, Class<?>> key) {
            Schema xSchema = ReflectData.get().getSchema((Type)key.first);
            Schema ySchema = ReflectData.get().getSchema((Type)key.second);
            return Schema.createRecord("pair", null, null, false, Lists.newArrayList(new Schema.Field("x", xSchema, null, null), new Schema.Field("y", ySchema, null, null)));
        }
    });
    private Schema schema = null;
    private X first;
    private Y second;

    public static <X, Y> Pair<X, Y> of(X first, Y second) {
        return new Pair<X, Y>(first, second);
    }

    private Pair(X first, Y second) {
        this.first = first;
        this.second = second;
    }

    @Override
    public void put(int i, Object v) {
        if (i == 0) {
            this.first = v;
            return;
        }
        if (i == 1) {
            this.second = v;
            return;
        }
        throw new IllegalArgumentException("Cannot set value " + i + " (not 0 or 1): " + String.valueOf(v));
    }

    @Override
    public Object get(int i) {
        if (i == 0) {
            return this.first;
        }
        if (i == 1) {
            return this.second;
        }
        throw new IllegalArgumentException("Cannot get value " + i + " (not 0 or 1)");
    }

    @Override
    public Schema getSchema() {
        if (this.schema == null) {
            this.schema = SCHEMA_CACHE.get(Pair.of(this.first.getClass(), this.second.getClass()));
        }
        return this.schema;
    }

    public X first() {
        return this.first;
    }

    public Y second() {
        return this.second;
    }

    public String toString() {
        return "(" + String.valueOf(this.first) + ", " + String.valueOf(this.second) + ")";
    }

    public int hashCode() {
        return Objects.hashCode(this.first, this.second);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Pair)) {
            return false;
        }
        Pair otherPair = (Pair)other;
        return Objects.equal(this.first, otherPair.first) && Objects.equal(this.second, otherPair.second);
    }
}

