/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.variants;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.variants.VariantArray;
import org.apache.iceberg.variants.VariantUtil;
import org.apache.iceberg.variants.VariantValue;

public class ValueArray
implements VariantArray {
    private SerializationState serializationState = null;
    private List<VariantValue> elements = Lists.newArrayList();

    ValueArray() {
    }

    @Override
    public VariantValue get(int index) {
        return this.elements.get(index);
    }

    @Override
    public int numElements() {
        return this.elements.size();
    }

    public void add(VariantValue value) {
        this.elements.add(value);
        this.serializationState = null;
    }

    @Override
    public int sizeInBytes() {
        if (null == this.serializationState) {
            this.serializationState = new SerializationState(this.elements);
        }
        return this.serializationState.size();
    }

    @Override
    public int writeTo(ByteBuffer buffer, int offset) {
        Preconditions.checkArgument(buffer.order() == ByteOrder.LITTLE_ENDIAN, "Invalid byte order: big endian");
        if (null == this.serializationState) {
            this.serializationState = new SerializationState(this.elements);
        }
        return this.serializationState.writeTo(buffer, offset);
    }

    public String toString() {
        return VariantArray.asString(this);
    }

    private static class SerializationState {
        private final List<VariantValue> elements;
        private final int numElements;
        private final boolean isLarge;
        private final int dataSize;
        private final int offsetSize;

        private SerializationState(List<VariantValue> elements) {
            this.elements = elements;
            this.numElements = elements.size();
            this.isLarge = this.numElements > 255;
            int totalDataSize = 0;
            for (VariantValue value : elements) {
                totalDataSize += value.sizeInBytes();
            }
            this.dataSize = totalDataSize;
            this.offsetSize = VariantUtil.sizeOf(totalDataSize);
        }

        private int size() {
            return 1 + (this.isLarge ? 4 : 1) + (1 + this.numElements) * this.offsetSize + this.dataSize;
        }

        private int writeTo(ByteBuffer buffer, int offset) {
            int offsetListOffset = offset + 1 + (this.isLarge ? 4 : 1);
            int dataOffset = offsetListOffset + (1 + this.numElements) * this.offsetSize;
            byte header = VariantUtil.arrayHeader(this.isLarge, this.offsetSize);
            VariantUtil.writeByte(buffer, header, offset);
            VariantUtil.writeLittleEndianUnsigned(buffer, this.numElements, offset + 1, this.isLarge ? 4 : 1);
            int nextValueOffset = 0;
            int index = 0;
            for (VariantValue element : this.elements) {
                VariantUtil.writeLittleEndianUnsigned(buffer, nextValueOffset, offsetListOffset + index * this.offsetSize, this.offsetSize);
                int valueSize = element.writeTo(buffer, dataOffset + nextValueOffset);
                nextValueOffset += valueSize;
                ++index;
            }
            VariantUtil.writeLittleEndianUnsigned(buffer, nextValueOffset, offsetListOffset + index * this.offsetSize, this.offsetSize);
            return dataOffset - offset + this.dataSize;
        }
    }
}

