/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.view;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.apache.iceberg.view.UnknownViewRepresentation;
import org.apache.iceberg.view.ViewRepresentation;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="UnknownViewRepresentation", generator="Immutables")
@Immutable
public final class ImmutableUnknownViewRepresentation
implements UnknownViewRepresentation {
    private final String type;

    private ImmutableUnknownViewRepresentation(String type) {
        this.type = type;
    }

    @Override
    public String type() {
        return this.type;
    }

    public final ImmutableUnknownViewRepresentation withType(String value) {
        String newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals(newValue)) {
            return this;
        }
        return new ImmutableUnknownViewRepresentation(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUnknownViewRepresentation && this.equalsByValue((ImmutableUnknownViewRepresentation)another);
    }

    private boolean equalsByValue(ImmutableUnknownViewRepresentation another) {
        return this.type.equals(another.type);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.type.hashCode();
        return h2;
    }

    public String toString() {
        return "UnknownViewRepresentation{type=" + this.type + "}";
    }

    public static ImmutableUnknownViewRepresentation copyOf(UnknownViewRepresentation instance) {
        if (instance instanceof ImmutableUnknownViewRepresentation) {
            return (ImmutableUnknownViewRepresentation)instance;
        }
        return ImmutableUnknownViewRepresentation.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="UnknownViewRepresentation", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private long initBits = 1L;
        @Nullable
        private String type;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(UnknownViewRepresentation instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(ViewRepresentation instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            ViewRepresentation instance;
            long bits = 0L;
            if (object instanceof UnknownViewRepresentation) {
                instance = (UnknownViewRepresentation)object;
                if ((bits & 1L) == 0L) {
                    this.type(instance.type());
                    bits |= 1L;
                }
            }
            if (object instanceof ViewRepresentation) {
                instance = (ViewRepresentation)object;
                if ((bits & 1L) == 0L) {
                    this.type(instance.type());
                    bits |= 1L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableUnknownViewRepresentation build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUnknownViewRepresentation(this.type);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build UnknownViewRepresentation, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

