/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import java.net.URI;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.iceberg.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;
import org.projectnessie.client.auth.oauth2.DeviceCodeResponse;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DeviceCodeResponse", generator="Immutables")
@Immutable
public final class ImmutableDeviceCodeResponse
implements DeviceCodeResponse {
    private final String deviceCode;
    private final String userCode;
    private final URI verificationUri;
    @Nullable
    private final URI verificationUriComplete;
    private final int expiresInSeconds;
    @Nullable
    private final Integer intervalSeconds;

    private ImmutableDeviceCodeResponse(String deviceCode, String userCode, URI verificationUri, @Nullable URI verificationUriComplete, int expiresInSeconds, @Nullable Integer intervalSeconds) {
        this.deviceCode = deviceCode;
        this.userCode = userCode;
        this.verificationUri = verificationUri;
        this.verificationUriComplete = verificationUriComplete;
        this.expiresInSeconds = expiresInSeconds;
        this.intervalSeconds = intervalSeconds;
    }

    @Override
    @JsonProperty(value="device_code")
    public String getDeviceCode() {
        return this.deviceCode;
    }

    @Override
    @JsonProperty(value="user_code")
    public String getUserCode() {
        return this.userCode;
    }

    @Override
    @JsonProperty(value="verification_uri")
    public URI getVerificationUri() {
        return this.verificationUri;
    }

    @Override
    @JsonProperty(value="verification_uri_complete")
    @Nullable
    public URI getVerificationUriComplete() {
        return this.verificationUriComplete;
    }

    @Override
    @JsonProperty(value="expires_in")
    public int getExpiresInSeconds() {
        return this.expiresInSeconds;
    }

    @Override
    @JsonProperty(value="interval")
    @Nullable
    public Integer getIntervalSeconds() {
        return this.intervalSeconds;
    }

    public final ImmutableDeviceCodeResponse withDeviceCode(String value) {
        String newValue = Objects.requireNonNull(value, "deviceCode");
        if (this.deviceCode.equals(newValue)) {
            return this;
        }
        return new ImmutableDeviceCodeResponse(newValue, this.userCode, this.verificationUri, this.verificationUriComplete, this.expiresInSeconds, this.intervalSeconds);
    }

    public final ImmutableDeviceCodeResponse withUserCode(String value) {
        String newValue = Objects.requireNonNull(value, "userCode");
        if (this.userCode.equals(newValue)) {
            return this;
        }
        return new ImmutableDeviceCodeResponse(this.deviceCode, newValue, this.verificationUri, this.verificationUriComplete, this.expiresInSeconds, this.intervalSeconds);
    }

    public final ImmutableDeviceCodeResponse withVerificationUri(URI value) {
        if (this.verificationUri == value) {
            return this;
        }
        URI newValue = Objects.requireNonNull(value, "verificationUri");
        return new ImmutableDeviceCodeResponse(this.deviceCode, this.userCode, newValue, this.verificationUriComplete, this.expiresInSeconds, this.intervalSeconds);
    }

    public final ImmutableDeviceCodeResponse withVerificationUriComplete(@Nullable URI value) {
        if (this.verificationUriComplete == value) {
            return this;
        }
        return new ImmutableDeviceCodeResponse(this.deviceCode, this.userCode, this.verificationUri, value, this.expiresInSeconds, this.intervalSeconds);
    }

    public final ImmutableDeviceCodeResponse withExpiresInSeconds(int value) {
        if (this.expiresInSeconds == value) {
            return this;
        }
        return new ImmutableDeviceCodeResponse(this.deviceCode, this.userCode, this.verificationUri, this.verificationUriComplete, value, this.intervalSeconds);
    }

    public final ImmutableDeviceCodeResponse withIntervalSeconds(@Nullable Integer value) {
        if (Objects.equals(this.intervalSeconds, value)) {
            return this;
        }
        return new ImmutableDeviceCodeResponse(this.deviceCode, this.userCode, this.verificationUri, this.verificationUriComplete, this.expiresInSeconds, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDeviceCodeResponse && this.equalsByValue((ImmutableDeviceCodeResponse)another);
    }

    private boolean equalsByValue(ImmutableDeviceCodeResponse another) {
        return this.deviceCode.equals(another.deviceCode) && this.userCode.equals(another.userCode) && this.verificationUri.equals(another.verificationUri) && Objects.equals(this.verificationUriComplete, another.verificationUriComplete) && this.expiresInSeconds == another.expiresInSeconds && Objects.equals(this.intervalSeconds, another.intervalSeconds);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.deviceCode.hashCode();
        h2 += (h2 << 5) + this.userCode.hashCode();
        h2 += (h2 << 5) + this.verificationUri.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.verificationUriComplete);
        h2 += (h2 << 5) + this.expiresInSeconds;
        h2 += (h2 << 5) + Objects.hashCode(this.intervalSeconds);
        return h2;
    }

    public String toString() {
        return "DeviceCodeResponse{deviceCode=" + this.deviceCode + ", userCode=" + this.userCode + ", verificationUri=" + String.valueOf(this.verificationUri) + ", verificationUriComplete=" + String.valueOf(this.verificationUriComplete) + ", expiresInSeconds=" + this.expiresInSeconds + ", intervalSeconds=" + this.intervalSeconds + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableDeviceCodeResponse fromJson(Json json) {
        Builder builder = ImmutableDeviceCodeResponse.builder();
        if (json._deviceCode != null) {
            builder.deviceCode(json._deviceCode);
        }
        if (json._userCode != null) {
            builder.userCode(json._userCode);
        }
        if (json._verificationUri != null) {
            builder.verificationUri(json._verificationUri);
        }
        if (json._verificationUriComplete != null) {
            builder.verificationUriComplete(json._verificationUriComplete);
        }
        if (json.expiresInSecondsIsSet) {
            builder.expiresInSeconds(json._expiresInSeconds);
        }
        if (json._intervalSeconds != null) {
            builder.intervalSeconds(json._intervalSeconds);
        }
        return builder.build();
    }

    public static ImmutableDeviceCodeResponse copyOf(DeviceCodeResponse instance) {
        if (instance instanceof ImmutableDeviceCodeResponse) {
            return (ImmutableDeviceCodeResponse)instance;
        }
        return ImmutableDeviceCodeResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DeviceCodeResponse", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_DEVICE_CODE = 1L;
        private static final long INIT_BIT_USER_CODE = 2L;
        private static final long INIT_BIT_VERIFICATION_URI = 4L;
        private static final long INIT_BIT_EXPIRES_IN_SECONDS = 8L;
        private long initBits = 15L;
        private String deviceCode;
        private String userCode;
        private URI verificationUri;
        private URI verificationUriComplete;
        private int expiresInSeconds;
        private Integer intervalSeconds;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DeviceCodeResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.deviceCode(instance.getDeviceCode());
            this.userCode(instance.getUserCode());
            this.verificationUri(instance.getVerificationUri());
            URI verificationUriCompleteValue = instance.getVerificationUriComplete();
            if (verificationUriCompleteValue != null) {
                this.verificationUriComplete(verificationUriCompleteValue);
            }
            this.expiresInSeconds(instance.getExpiresInSeconds());
            Integer intervalSecondsValue = instance.getIntervalSeconds();
            if (intervalSecondsValue != null) {
                this.intervalSeconds(intervalSecondsValue);
            }
            return this;
        }

        @JsonProperty(value="device_code")
        @CanIgnoreReturnValue
        public final Builder deviceCode(String deviceCode) {
            this.deviceCode = Objects.requireNonNull(deviceCode, "deviceCode");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="user_code")
        @CanIgnoreReturnValue
        public final Builder userCode(String userCode) {
            this.userCode = Objects.requireNonNull(userCode, "userCode");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="verification_uri")
        @CanIgnoreReturnValue
        public final Builder verificationUri(URI verificationUri) {
            this.verificationUri = Objects.requireNonNull(verificationUri, "verificationUri");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="verification_uri_complete")
        @CanIgnoreReturnValue
        public final Builder verificationUriComplete(@Nullable URI verificationUriComplete) {
            this.verificationUriComplete = verificationUriComplete;
            return this;
        }

        @JsonProperty(value="expires_in")
        @CanIgnoreReturnValue
        public final Builder expiresInSeconds(int expiresInSeconds) {
            this.expiresInSeconds = expiresInSeconds;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="interval")
        @CanIgnoreReturnValue
        public final Builder intervalSeconds(@Nullable Integer intervalSeconds) {
            this.intervalSeconds = intervalSeconds;
            return this;
        }

        public ImmutableDeviceCodeResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDeviceCodeResponse(this.deviceCode, this.userCode, this.verificationUri, this.verificationUriComplete, this.expiresInSeconds, this.intervalSeconds);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("deviceCode");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("userCode");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("verificationUri");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("expiresInSeconds");
            }
            return "Cannot build DeviceCodeResponse, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @Generated(from="DeviceCodeResponse", generator="Immutables")
    static final class Json
    implements DeviceCodeResponse {
        @JsonIgnore
        String _deviceCode;
        @JsonIgnore
        String _userCode;
        @JsonIgnore
        URI _verificationUri;
        @JsonIgnore
        URI _verificationUriComplete;
        @JsonIgnore
        int _expiresInSeconds;
        @JsonIgnore
        boolean expiresInSecondsIsSet;
        @JsonIgnore
        Integer _intervalSeconds;

        Json() {
        }

        @JsonProperty(value="device_code")
        public void setDeviceCode(String deviceCode) {
            this._deviceCode = deviceCode;
        }

        @JsonProperty(value="user_code")
        public void setUserCode(String userCode) {
            this._userCode = userCode;
        }

        @JsonProperty(value="verification_uri")
        public void setVerificationUri(URI verificationUri) {
            this._verificationUri = verificationUri;
        }

        @JsonProperty(value="verification_uri_complete")
        public void setVerificationUriComplete(@Nullable URI verificationUriComplete) {
            this._verificationUriComplete = verificationUriComplete;
        }

        @JsonProperty(value="expires_in")
        public void setExpiresInSeconds(int expiresInSeconds) {
            this._expiresInSeconds = expiresInSeconds;
            this.expiresInSecondsIsSet = true;
        }

        @JsonProperty(value="interval")
        public void setIntervalSeconds(@Nullable Integer intervalSeconds) {
            this._intervalSeconds = intervalSeconds;
        }

        @Override
        public String getDeviceCode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUserCode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI getVerificationUri() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI getVerificationUriComplete() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getExpiresInSeconds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getIntervalSeconds() {
            throw new UnsupportedOperationException();
        }
    }
}

