/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import org.projectnessie.client.auth.NessieAuthenticationProvider;
import org.projectnessie.client.auth.oauth2.AccessToken;
import org.projectnessie.client.auth.oauth2.OAuth2Authenticator;
import org.projectnessie.client.auth.oauth2.OAuth2AuthenticatorConfig;
import org.projectnessie.client.auth.oauth2.OAuth2Client;
import org.projectnessie.client.auth.oauth2.OAuth2ClientConfig;
import org.projectnessie.client.http.HttpAuthentication;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.client.http.RequestContext;

public class OAuth2AuthenticationProvider
implements NessieAuthenticationProvider {
    public static final String AUTH_TYPE_VALUE = "OAUTH2";

    @Override
    public String getAuthTypeValue() {
        return AUTH_TYPE_VALUE;
    }

    @Override
    public HttpAuthentication build(Function<String, String> configSupplier) {
        return OAuth2AuthenticationProvider.create(OAuth2AuthenticationProvider.newAuthenticator(configSupplier));
    }

    public static OAuth2Authenticator newAuthenticator(Function<String, String> configSupplier) {
        return OAuth2AuthenticationProvider.newAuthenticator(OAuth2AuthenticatorConfig.fromConfigSupplier(configSupplier));
    }

    public static OAuth2Authenticator newAuthenticator(OAuth2AuthenticatorConfig config) {
        OAuth2ClientConfig clientConfig = config instanceof OAuth2ClientConfig ? (OAuth2ClientConfig)config : OAuth2ClientConfig.builder().from(config).build();
        return new OAuth2Client(clientConfig);
    }

    public static HttpAuthentication create(OAuth2AuthenticatorConfig config) {
        return OAuth2AuthenticationProvider.create(OAuth2AuthenticationProvider.newAuthenticator(config));
    }

    public static HttpAuthentication create(OAuth2Authenticator authenticator) {
        return new OAuth2Authentication(authenticator);
    }

    static class OAuth2Authentication
    implements HttpAuthentication {
        private final OAuth2Authenticator authenticator;

        OAuth2Authentication(OAuth2Authenticator authenticator) {
            Objects.requireNonNull(authenticator, "OAuth2Authenticator must not be null for authentication type OAUTH2");
            this.authenticator = authenticator;
        }

        @Override
        public void start() {
            this.authenticator.start();
        }

        @Override
        public HttpAuthentication copy() {
            return new OAuth2Authentication(this.authenticator.copy());
        }

        @Override
        public void applyToHttpClient(HttpClient.Builder client) {
            client.addRequestFilter(this::applyToHttpRequest);
        }

        @Override
        public void applyToHttpRequest(RequestContext context) {
            AccessToken token = this.authenticator.authenticate();
            if (!token.getTokenType().toLowerCase(Locale.ROOT).equals("bearer")) {
                throw new IllegalArgumentException("OAuth2 token type returned from the authenticating server must be 'Bearer', but was: " + token.getTokenType());
            }
            context.putHeader("Authorization", "Bearer " + token.getPayload());
        }

        @Override
        public void close() {
            this.authenticator.close();
        }
    }
}

