/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http.impl.jdk11;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.channels.Channels;
import java.nio.channels.Pipe;
import java.time.Duration;
import java.util.concurrent.Executor;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.client.http.RequestContext;
import org.projectnessie.client.http.ResponseContext;
import org.projectnessie.client.http.impl.BaseHttpRequest;
import org.projectnessie.client.http.impl.HttpHeaders;
import org.projectnessie.client.http.impl.HttpRuntimeConfig;
import org.projectnessie.client.http.impl.jdk11.JavaResponseContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JavaRequest
extends BaseHttpRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaRequest.class);
    private final HttpExchange<InputStream> exchange;
    private final Executor writerPool;

    JavaRequest(HttpRuntimeConfig config, URI baseUri, HttpExchange<InputStream> exchange, Executor writerPool) {
        super(config, baseUri);
        this.exchange = exchange;
        this.writerPool = writerPool;
    }

    @Override
    protected ResponseContext sendAndReceive(URI uri, HttpClient.Method method, Object body, RequestContext requestContext) throws IOException, InterruptedException {
        HttpRequest.Builder request = HttpRequest.newBuilder().uri(uri).timeout(Duration.ofMillis(this.config.getReadTimeoutMillis()));
        for (HttpHeaders.HttpHeader header : this.headers.allHeaders()) {
            for (String value : header.getValues()) {
                request = request.header(header.getName(), value);
            }
        }
        HttpRequest.BodyPublisher bodyPublisher = requestContext.doesOutput() ? this.bodyPublisher(requestContext) : HttpRequest.BodyPublishers.noBody();
        request = request.method(method.name(), bodyPublisher);
        LOGGER.debug("Sending {} request to {} ...", (Object)method, (Object)uri);
        HttpResponse<InputStream> response = this.exchange.send(request.build(), HttpResponse.BodyHandlers.ofInputStream());
        return new JavaResponseContext(response);
    }

    private HttpRequest.BodyPublisher bodyPublisher(RequestContext context) {
        ClassLoader cl = this.getClass().getClassLoader();
        return HttpRequest.BodyPublishers.ofInputStream(() -> {
            try {
                Pipe pipe = Pipe.open();
                this.writerPool.execute(() -> {
                    ClassLoader restore = Thread.currentThread().getContextClassLoader();
                    try {
                        Thread.currentThread().setContextClassLoader(cl);
                        this.writeToOutputStream(context, Channels.newOutputStream(pipe.sink()));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(restore);
                    }
                });
                return Channels.newInputStream(pipe.source());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @FunctionalInterface
    static interface HttpExchange<T> {
        public HttpResponse<T> send(HttpRequest var1, HttpResponse.BodyHandler<T> var2) throws IOException, InterruptedException;
    }
}

