/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.immutables.value.Generated;
import org.projectnessie.model.CommitResponse;
import org.projectnessie.model.ContentKey;

@ParametersAreNonnullByDefault
@Generated(from="CommitResponse.AddedContent", generator="Immutables")
@Immutable
public final class ImmutableAddedContent
implements CommitResponse.AddedContent {
    private final ContentKey key;
    private final String contentId;

    private ImmutableAddedContent(ContentKey key, String contentId) {
        this.key = Objects.requireNonNull(key, "key");
        this.contentId = Objects.requireNonNull(contentId, "contentId");
    }

    private ImmutableAddedContent(ImmutableAddedContent original, ContentKey key, String contentId) {
        this.key = key;
        this.contentId = contentId;
    }

    @Override
    @JsonProperty(value="key", required=true)
    public ContentKey getKey() {
        return this.key;
    }

    @Override
    @JsonProperty(value="contentId", required=true)
    public String contentId() {
        return this.contentId;
    }

    public final ImmutableAddedContent withKey(ContentKey value) {
        if (this.key == value) {
            return this;
        }
        ContentKey newValue = Objects.requireNonNull(value, "key");
        return new ImmutableAddedContent(this, newValue, this.contentId);
    }

    public final ImmutableAddedContent withContentId(String value) {
        String newValue = Objects.requireNonNull(value, "contentId");
        if (this.contentId.equals(newValue)) {
            return this;
        }
        return new ImmutableAddedContent(this, this.key, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAddedContent && this.equalsByValue((ImmutableAddedContent)another);
    }

    private boolean equalsByValue(ImmutableAddedContent another) {
        return this.key.equals(another.key) && this.contentId.equals(another.contentId);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.key.hashCode();
        h2 += (h2 << 5) + this.contentId.hashCode();
        return h2;
    }

    public String toString() {
        return "AddedContent{key=" + String.valueOf(this.key) + ", contentId=" + this.contentId + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAddedContent fromJson(Json json) {
        Builder builder = ImmutableAddedContent.builder();
        if (json._key != null) {
            builder.key(json._key);
        }
        if (json._contentId != null) {
            builder.contentId(json._contentId);
        }
        return builder.build();
    }

    public static ImmutableAddedContent of(ContentKey key, String contentId) {
        return new ImmutableAddedContent(key, contentId);
    }

    public static ImmutableAddedContent copyOf(CommitResponse.AddedContent instance) {
        if (instance instanceof ImmutableAddedContent) {
            return (ImmutableAddedContent)instance;
        }
        return ImmutableAddedContent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CommitResponse.AddedContent", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_KEY = 1L;
        private static final long INIT_BIT_CONTENT_ID = 2L;
        private long initBits = 3L;
        private ContentKey key;
        private String contentId;

        private Builder() {
        }

        public final Builder from(CommitResponse.AddedContent instance) {
            Objects.requireNonNull(instance, "instance");
            this.key(instance.getKey());
            this.contentId(instance.contentId());
            return this;
        }

        @JsonProperty(value="key", required=true)
        public final Builder key(ContentKey key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="contentId", required=true)
        public final Builder contentId(String contentId) {
            this.contentId = Objects.requireNonNull(contentId, "contentId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableAddedContent build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAddedContent(null, this.key, this.contentId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("key");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("contentId");
            }
            return "Cannot build AddedContent, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @Generated(from="CommitResponse.AddedContent", generator="Immutables")
    static final class Json
    implements CommitResponse.AddedContent {
        @JsonIgnore
        ContentKey _key;
        @JsonIgnore
        String _contentId;

        Json() {
        }

        @JsonProperty(value="key", required=true)
        public void setKey(ContentKey key) {
            this._key = key;
        }

        @JsonProperty(value="contentId", required=true)
        public void setContentId(String contentId) {
            this._contentId = contentId;
        }

        @Override
        public ContentKey getKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String contentId() {
            throw new UnsupportedOperationException();
        }
    }
}

