/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hll;

import org.apache.datasketches.common.SketchesStateException;
import org.apache.datasketches.hll.DirectHllArray;
import org.apache.datasketches.hll.Hll6Array;
import org.apache.datasketches.hll.HllPairIterator;
import org.apache.datasketches.hll.HllSketchImpl;
import org.apache.datasketches.hll.HllUtil;
import org.apache.datasketches.hll.PairIterator;
import org.apache.datasketches.hll.PreambleUtil;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;

final class DirectHll6Array
extends DirectHllArray {
    DirectHll6Array(int lgConfigK, WritableMemory wmem) {
        super(lgConfigK, TgtHllType.HLL_6, wmem);
    }

    DirectHll6Array(int lgConfigK, Memory mem) {
        super(lgConfigK, TgtHllType.HLL_6, mem);
    }

    @Override
    HllSketchImpl copy() {
        return Hll6Array.heapify(this.mem);
    }

    @Override
    HllSketchImpl couponUpdate(int coupon) {
        if (this.wmem == null) {
            HllUtil.noWriteAccess();
        }
        int newValue = HllUtil.getPairValue(coupon);
        int configKmask = (1 << this.getLgConfigK()) - 1;
        int slotNo = HllUtil.getPairLow26(coupon) & configKmask;
        this.updateSlotWithKxQ(slotNo, newValue);
        return this;
    }

    @Override
    int getHllByteArrBytes() {
        return DirectHll6Array.hll6ArrBytes(this.lgConfigK);
    }

    @Override
    int getNibble(int slotNo) {
        throw new SketchesStateException("Improper access.");
    }

    @Override
    final int getSlotValue(int slotNo) {
        return DirectHll6Array.get6Bit(this.mem, PreambleUtil.HLL_BYTE_ARR_START, slotNo);
    }

    @Override
    PairIterator iterator() {
        return new DirectHll6Iterator(1 << this.lgConfigK);
    }

    @Override
    void putNibble(int slotNo, int nibValue) {
        throw new SketchesStateException("Improper access.");
    }

    @Override
    final void updateSlotNoKxQ(int slotNo, int newValue) {
        throw new SketchesStateException("Improper access.");
    }

    @Override
    final void updateSlotWithKxQ(int slotNo, int newValue) {
        int oldValue = this.getSlotValue(slotNo);
        if (newValue > oldValue) {
            DirectHll6Array.put6Bit(this.wmem, PreambleUtil.HLL_BYTE_ARR_START, slotNo, newValue);
            DirectHll6Array.hipAndKxQIncrementalUpdate(this, oldValue, newValue);
            if (oldValue == 0) {
                this.decNumAtCurMin();
                assert (this.getNumAtCurMin() >= 0);
            }
        }
    }

    private static final void put6Bit(WritableMemory wmem, int offsetBytes, int slotNo, int newValue) {
        int startBit = slotNo * 6;
        int shift = startBit & 7;
        int byteIdx = (startBit >>> 3) + offsetBytes;
        int valShifted = (newValue & 0x3F) << shift;
        int curMasked = wmem.getShort(byteIdx) & ~(63 << shift);
        short insert = (short)(curMasked | valShifted);
        wmem.putShort(byteIdx, insert);
    }

    private static final int get6Bit(Memory mem, int offsetBytes, int slotNo) {
        int startBit = slotNo * 6;
        int shift = startBit & 7;
        int byteIdx = (startBit >>> 3) + offsetBytes;
        return (byte)(mem.getShort(byteIdx) >>> shift & 0x3F);
    }

    final class DirectHll6Iterator
    extends HllPairIterator {
        int bitOffset;

        DirectHll6Iterator(int lengthPairs) {
            super(lengthPairs);
            this.bitOffset = -6;
        }

        @Override
        int value() {
            this.bitOffset += 6;
            short tmp = DirectHll6Array.this.mem.getShort(PreambleUtil.HLL_BYTE_ARR_START + this.bitOffset / 8);
            int shift = this.bitOffset % 8 & 7;
            return tmp >>> shift & 0x3F;
        }
    }
}

