/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hll;

import java.nio.ByteOrder;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.hll.CurMode;
import org.apache.datasketches.hll.HllUtil;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;

final class PreambleUtil {
    static int PREAMBLE_INTS_BYTE = 0;
    static int SER_VER_BYTE = 1;
    static int FAMILY_BYTE = 2;
    static int LG_K_BYTE = 3;
    static int LG_ARR_BYTE = 4;
    static int FLAGS_BYTE = 5;
    static int LIST_COUNT_BYTE = 6;
    static int HLL_CUR_MIN_BYTE = 6;
    static int MODE_BYTE = 7;
    static int LIST_INT_ARR_START = 8;
    static int HASH_SET_COUNT_INT = 8;
    static int HASH_SET_INT_ARR_START = 12;
    static int HIP_ACCUM_DOUBLE = 8;
    static int KXQ0_DOUBLE = 16;
    static int KXQ1_DOUBLE = 24;
    static int CUR_MIN_COUNT_INT = 32;
    static int AUX_COUNT_INT = 36;
    static int HLL_BYTE_ARR_START = 40;
    static final int BIG_ENDIAN_FLAG_MASK = 1;
    static final int READ_ONLY_FLAG_MASK = 2;
    static final int EMPTY_FLAG_MASK = 4;
    static final int COMPACT_FLAG_MASK = 8;
    static final int OUT_OF_ORDER_FLAG_MASK = 16;
    static final int REBUILD_CURMIN_NUM_KXQ_MASK = 32;
    static final int CUR_MODE_MASK = 3;
    static final int TGT_HLL_TYPE_MASK = 12;
    static final int SER_VER = 1;
    static final int FAMILY_ID = 7;
    static final int LIST_PREINTS = 2;
    static final int HASH_SET_PREINTS = 3;
    static final int HLL_PREINTS = 10;
    static final boolean NATIVE_ORDER_IS_BIG_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;

    private PreambleUtil() {
    }

    static String toString(byte[] byteArr) {
        Memory mem = Memory.wrap(byteArr);
        return PreambleUtil.toString(mem);
    }

    static String toString(Memory mem) {
        byte hllCurMin;
        byte preInts = mem.getByte(PREAMBLE_INTS_BYTE);
        byte serVer = mem.getByte(SER_VER_BYTE);
        Family family = Family.idToFamily(mem.getByte(FAMILY_BYTE));
        byte lgK = mem.getByte(LG_K_BYTE);
        byte lgArr = mem.getByte(LG_ARR_BYTE);
        byte flags = mem.getByte(FLAGS_BYTE);
        String flagsStr = Util.zeroPad(Integer.toBinaryString(flags), 8) + ", " + flags;
        boolean bigEndian = (flags & 1) > 0;
        String nativeOrder = ByteOrder.nativeOrder().toString();
        boolean compact = (flags & 8) > 0;
        boolean oooFlag = (flags & 0x10) > 0;
        boolean readOnly = (flags & 2) > 0;
        boolean empty = (flags & 4) > 0;
        boolean rebuildKxQ = (flags & 0x20) > 0;
        byte listCount = hllCurMin = mem.getByte(HLL_CUR_MIN_BYTE);
        byte modeByte = mem.getByte(MODE_BYTE);
        CurMode curMode = CurMode.fromOrdinal(modeByte & 3);
        TgtHllType tgtHllType = TgtHllType.fromOrdinal(modeByte >>> 2 & 3);
        double hipAccum = 0.0;
        double kxq0 = 0.0;
        double kxq1 = 0.0;
        int hashSetCount = 0;
        int curMinCount = 0;
        int exceptionCount = 0;
        if (curMode == CurMode.SET) {
            hashSetCount = mem.getInt(HASH_SET_COUNT_INT);
        } else if (curMode == CurMode.HLL) {
            hipAccum = mem.getDouble(HIP_ACCUM_DOUBLE);
            kxq0 = mem.getDouble(KXQ0_DOUBLE);
            kxq1 = mem.getDouble(KXQ1_DOUBLE);
            curMinCount = mem.getInt(CUR_MIN_COUNT_INT);
            exceptionCount = mem.getInt(AUX_COUNT_INT);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(Util.LS);
        sb.append("### HLL SKETCH PREAMBLE:").append(Util.LS);
        sb.append("Byte 0: Preamble Ints         : ").append(preInts).append(Util.LS);
        sb.append("Byte 1: SerVer                : ").append(serVer).append(Util.LS);
        sb.append("Byte 2: Family                : ").append((Object)family).append(Util.LS);
        sb.append("Byte 3: lgK                   : ").append(lgK).append(Util.LS);
        if (curMode == CurMode.LIST) {
            sb.append("Byte 4: LgArr: List Arr       : ").append(lgArr).append(Util.LS);
        }
        if (curMode == CurMode.SET) {
            sb.append("Byte 4: LgArr: Hash Set Arr   : ").append(lgArr).append(Util.LS);
        }
        if (curMode == CurMode.HLL) {
            sb.append("Byte 4: LgArr or Aux LgArr    : ").append(lgArr).append(Util.LS);
        }
        sb.append("Byte 5: Flags:                : ").append(flagsStr).append(Util.LS);
        sb.append("  BIG_ENDIAN_STORAGE          : ").append(bigEndian).append(Util.LS);
        sb.append("  (Native Byte Order)         : ").append(nativeOrder).append(Util.LS);
        sb.append("  READ_ONLY                   : ").append(readOnly).append(Util.LS);
        sb.append("  EMPTY                       : ").append(empty).append(Util.LS);
        sb.append("  COMPACT                     : ").append(compact).append(Util.LS);
        sb.append("  OUT_OF_ORDER                : ").append(oooFlag).append(Util.LS);
        sb.append("  REBUILD_KXQ                 : ").append(rebuildKxQ).append(Util.LS);
        if (curMode == CurMode.LIST) {
            sb.append("Byte 6: List Count/CurMin     : ").append(listCount).append(Util.LS);
        }
        if (curMode == CurMode.SET) {
            sb.append("Byte 6: (not used)            : ").append(Util.LS);
        }
        if (curMode == CurMode.HLL) {
            sb.append("Byte 6: Cur Min               : ").append(hllCurMin).append(Util.LS);
        }
        String modes = curMode.toString() + ", " + tgtHllType.toString();
        sb.append("Byte 7: Mode                  : ").append(modes).append(Util.LS);
        if (curMode == CurMode.SET) {
            sb.append("Hash Set Count                : ").append(hashSetCount).append(Util.LS);
        }
        if (curMode == CurMode.HLL) {
            sb.append("HIP Accum                     : ").append(hipAccum).append(Util.LS);
            sb.append("KxQ0                          : ").append(kxq0).append(Util.LS);
            sb.append("KxQ1                          : ").append(kxq1).append(Util.LS);
            sb.append("Num At Cur Min                : ").append(curMinCount).append(Util.LS);
            sb.append("Aux Count                     : ").append(exceptionCount).append(Util.LS);
        }
        sb.append("### END HLL SKETCH PREAMBLE").append(Util.LS);
        return sb.toString();
    }

    static int extractPreInts(Memory mem) {
        return mem.getByte(PREAMBLE_INTS_BYTE) & 0x3F;
    }

    static void insertPreInts(WritableMemory wmem, int preInts) {
        wmem.putByte(PREAMBLE_INTS_BYTE, (byte)(preInts & 0x3F));
    }

    static int extractSerVer(Memory mem) {
        return mem.getByte(SER_VER_BYTE) & 0xFF;
    }

    static void insertSerVer(WritableMemory wmem) {
        wmem.putByte(SER_VER_BYTE, (byte)1);
    }

    static int extractFamilyId(Memory mem) {
        return mem.getByte(FAMILY_BYTE) & 0xFF;
    }

    static void insertFamilyId(WritableMemory wmem) {
        wmem.putByte(FAMILY_BYTE, (byte)7);
    }

    static int extractLgK(Memory mem) {
        return mem.getByte(LG_K_BYTE) & 0xFF;
    }

    static void insertLgK(WritableMemory wmem, int lgK) {
        wmem.putByte(LG_K_BYTE, (byte)lgK);
    }

    static int extractLgArr(Memory mem) {
        int lgArr = mem.getByte(LG_ARR_BYTE) & 0xFF;
        return lgArr;
    }

    static void insertLgArr(WritableMemory wmem, int lgArr) {
        wmem.putByte(LG_ARR_BYTE, (byte)lgArr);
    }

    static int extractListCount(Memory mem) {
        return mem.getByte(LIST_COUNT_BYTE) & 0xFF;
    }

    static void insertListCount(WritableMemory wmem, int listCnt) {
        wmem.putByte(LIST_COUNT_BYTE, (byte)listCnt);
    }

    static int extractCurMin(Memory mem) {
        return mem.getByte(HLL_CUR_MIN_BYTE) & 0xFF;
    }

    static void insertCurMin(WritableMemory wmem, int curMin) {
        wmem.putByte(HLL_CUR_MIN_BYTE, (byte)curMin);
    }

    static double extractHipAccum(Memory mem) {
        return mem.getDouble(HIP_ACCUM_DOUBLE);
    }

    static void insertHipAccum(WritableMemory wmem, double hipAccum) {
        wmem.putDouble(HIP_ACCUM_DOUBLE, hipAccum);
    }

    static double extractKxQ0(Memory mem) {
        return mem.getDouble(KXQ0_DOUBLE);
    }

    static void insertKxQ0(WritableMemory wmem, double kxq0) {
        wmem.putDouble(KXQ0_DOUBLE, kxq0);
    }

    static double extractKxQ1(Memory mem) {
        return mem.getDouble(KXQ1_DOUBLE);
    }

    static void insertKxQ1(WritableMemory wmem, double kxq1) {
        wmem.putDouble(KXQ1_DOUBLE, kxq1);
    }

    static int extractHashSetCount(Memory mem) {
        return mem.getInt(HASH_SET_COUNT_INT);
    }

    static void insertHashSetCount(WritableMemory wmem, int hashSetCnt) {
        wmem.putInt(HASH_SET_COUNT_INT, hashSetCnt);
    }

    static int extractNumAtCurMin(Memory mem) {
        return mem.getInt(CUR_MIN_COUNT_INT);
    }

    static void insertNumAtCurMin(WritableMemory wmem, int numAtCurMin) {
        wmem.putInt(CUR_MIN_COUNT_INT, numAtCurMin);
    }

    static int extractAuxCount(Memory mem) {
        return mem.getInt(AUX_COUNT_INT);
    }

    static void insertAuxCount(WritableMemory wmem, int auxCount) {
        wmem.putInt(AUX_COUNT_INT, auxCount);
    }

    static void insertCurMode(WritableMemory wmem, CurMode curMode) {
        int curModeId = curMode.ordinal();
        int mode = wmem.getByte(MODE_BYTE) & 0xFFFFFFFC;
        wmem.putByte(MODE_BYTE, (byte)(mode |= curModeId & 3));
    }

    static CurMode extractCurMode(Memory mem) {
        int curModeId = mem.getByte(MODE_BYTE) & 3;
        return CurMode.fromOrdinal(curModeId);
    }

    static void insertTgtHllType(WritableMemory wmem, TgtHllType tgtHllType) {
        int typeId = tgtHllType.ordinal();
        int mode = wmem.getByte(MODE_BYTE) & 0xFFFFFFF3;
        wmem.putByte(MODE_BYTE, (byte)(mode |= typeId << 2 & 0xC));
    }

    static TgtHllType extractTgtHllType(Memory mem) {
        int typeId = mem.getByte(MODE_BYTE) & 0xC;
        return TgtHllType.fromOrdinal(typeId >>> 2);
    }

    static void insertModes(WritableMemory wmem, TgtHllType tgtHllType, CurMode curMode) {
        int curModeId = curMode.ordinal() & 3;
        int typeId = (tgtHllType.ordinal() & 3) << 2;
        int mode = typeId | curModeId;
        wmem.putByte(MODE_BYTE, (byte)mode);
    }

    static void insertEmptyFlag(WritableMemory wmem, boolean empty) {
        int flags = wmem.getByte(FLAGS_BYTE);
        flags = empty ? (flags |= 4) : (flags &= 0xFFFFFFFB);
        wmem.putByte(FLAGS_BYTE, (byte)flags);
    }

    static boolean extractEmptyFlag(Memory mem) {
        byte flags = mem.getByte(FLAGS_BYTE);
        return (flags & 4) > 0;
    }

    static void insertCompactFlag(WritableMemory wmem, boolean compact) {
        int flags = wmem.getByte(FLAGS_BYTE);
        flags = compact ? (flags |= 8) : (flags &= 0xFFFFFFF7);
        wmem.putByte(FLAGS_BYTE, (byte)flags);
    }

    static boolean extractCompactFlag(Memory mem) {
        byte flags = mem.getByte(FLAGS_BYTE);
        return (flags & 8) > 0;
    }

    static void insertOooFlag(WritableMemory wmem, boolean oooFlag) {
        int flags = wmem.getByte(FLAGS_BYTE);
        flags = oooFlag ? (flags |= 0x10) : (flags &= 0xFFFFFFEF);
        wmem.putByte(FLAGS_BYTE, (byte)flags);
    }

    static boolean extractOooFlag(Memory mem) {
        byte flags = mem.getByte(FLAGS_BYTE);
        return (flags & 0x10) > 0;
    }

    static void insertRebuildCurMinNumKxQFlag(WritableMemory wmem, boolean rebuild) {
        int flags = wmem.getByte(FLAGS_BYTE);
        flags = rebuild ? (flags |= 0x20) : (flags &= 0xFFFFFFDF);
        wmem.putByte(FLAGS_BYTE, (byte)flags);
    }

    static boolean extractRebuildCurMinNumKxQFlag(Memory mem) {
        byte flags = mem.getByte(FLAGS_BYTE);
        return (flags & 0x20) > 0;
    }

    static void insertFlags(WritableMemory wmem, int flags) {
        wmem.putByte(FLAGS_BYTE, (byte)flags);
    }

    static int extractFlags(Memory mem) {
        return mem.getByte(FLAGS_BYTE) & 0xFF;
    }

    static int extractInt(Memory mem, long byteOffset) {
        return mem.getInt(byteOffset);
    }

    static void insertInt(WritableMemory wmem, long byteOffset, int value) {
        wmem.putInt(byteOffset, value);
    }

    static int computeLgArr(Memory mem, int count, int lgConfigK) {
        CurMode curMode = PreambleUtil.extractCurMode(mem);
        if (curMode == CurMode.LIST) {
            return 3;
        }
        int ceilPwr2 = Util.ceilingPowerOf2(count);
        if (4 * count > 3 * ceilPwr2) {
            ceilPwr2 <<= 1;
        }
        if (curMode == CurMode.SET) {
            return Math.max(5, Util.exactLog2OfLong(ceilPwr2));
        }
        return Math.max(HllUtil.LG_AUX_ARR_INTS[lgConfigK], Util.exactLog2OfLong(ceilPwr2));
    }
}

