/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import java.util.Arrays;
import java.util.Objects;
import org.apache.datasketches.common.ByteArrayUtil;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.kll.KllDoublesHelper;
import org.apache.datasketches.kll.KllDoublesSketch;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllMemoryValidate;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableMemory;

final class KllHeapDoublesSketch
extends KllDoublesSketch {
    private final int k;
    private final int m;
    private long n;
    private int minK;
    private boolean isLevelZeroSorted;
    private double minDoubleItem;
    private double maxDoubleItem;
    private double[] doubleItems;

    KllHeapDoublesSketch(int k, int m4) {
        super(KllSketch.SketchStructure.UPDATABLE);
        KllHelper.checkM(m4);
        KllHelper.checkK(k, m4);
        this.levelsArr = new int[]{k, k};
        this.readOnly = false;
        this.k = k;
        this.m = m4;
        this.n = 0L;
        this.minK = k;
        this.isLevelZeroSorted = false;
        this.minDoubleItem = Double.NaN;
        this.maxDoubleItem = Double.NaN;
        this.doubleItems = new double[k];
    }

    KllHeapDoublesSketch(int k, int m4, double item, long weight) {
        super(KllSketch.SketchStructure.UPDATABLE);
        KllHelper.checkM(m4);
        KllHelper.checkK(k, m4);
        this.levelsArr = KllHelper.createLevelsArray(weight);
        this.readOnly = false;
        this.k = k;
        this.m = m4;
        this.n = weight;
        this.minK = k;
        this.isLevelZeroSorted = false;
        this.minDoubleItem = item;
        this.maxDoubleItem = item;
        this.doubleItems = KllDoublesHelper.createItemsArray(item, weight);
    }

    private KllHeapDoublesSketch(Memory srcMem, KllMemoryValidate memValidate) {
        super(KllSketch.SketchStructure.UPDATABLE);
        KllSketch.SketchStructure memStructure = memValidate.sketchStructure;
        this.k = memValidate.k;
        this.m = memValidate.m;
        this.n = memValidate.n;
        this.minK = memValidate.minK;
        this.levelsArr = memValidate.levelsArr;
        this.isLevelZeroSorted = memValidate.level0SortedFlag;
        if (memStructure == KllSketch.SketchStructure.COMPACT_EMPTY) {
            this.minDoubleItem = Double.NaN;
            this.maxDoubleItem = Double.NaN;
            this.doubleItems = new double[this.k];
        } else if (memStructure == KllSketch.SketchStructure.COMPACT_SINGLE) {
            double item;
            this.minDoubleItem = this.maxDoubleItem = (item = srcMem.getDouble(8L));
            this.doubleItems = new double[this.k];
            this.doubleItems[this.k - 1] = item;
        } else if (memStructure == KllSketch.SketchStructure.COMPACT_FULL) {
            int offsetBytes = 20;
            this.minDoubleItem = srcMem.getDouble(offsetBytes += (this.levelsArr.length - 1) * 4);
            this.maxDoubleItem = srcMem.getDouble(offsetBytes += 8);
            int capacityItems = this.levelsArr[this.getNumLevels()];
            int freeSpace = this.levelsArr[0];
            int retainedItems = capacityItems - freeSpace;
            this.doubleItems = new double[capacityItems];
            srcMem.getDoubleArray(offsetBytes += 8, this.doubleItems, freeSpace, retainedItems);
        } else {
            int offsetBytes = 20;
            this.minDoubleItem = srcMem.getDouble(offsetBytes += this.levelsArr.length * 4);
            this.maxDoubleItem = srcMem.getDouble(offsetBytes += 8);
            int capacityItems = this.levelsArr[this.getNumLevels()];
            this.doubleItems = new double[capacityItems];
            srcMem.getDoubleArray(offsetBytes += 8, this.doubleItems, 0, capacityItems);
        }
    }

    static KllHeapDoublesSketch heapifyImpl(Memory srcMem) {
        Objects.requireNonNull(srcMem, "Parameter 'srcMem' must not be null");
        KllMemoryValidate memVal = new KllMemoryValidate(srcMem, KllSketch.SketchType.DOUBLES_SKETCH);
        return new KllHeapDoublesSketch(srcMem, memVal);
    }

    @Override
    String getItemAsString(int index) {
        if (this.isEmpty()) {
            return "NaN";
        }
        return Double.toString(this.doubleItems[index]);
    }

    @Override
    public int getK() {
        return this.k;
    }

    @Override
    double getMaxItemInternal() {
        return this.maxDoubleItem;
    }

    @Override
    public double getMaxItem() {
        if (this.isEmpty() || Double.isNaN(this.maxDoubleItem)) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        return this.maxDoubleItem;
    }

    @Override
    String getMaxItemAsString() {
        return Double.toString(this.maxDoubleItem);
    }

    @Override
    double getMinItemInternal() {
        return this.minDoubleItem;
    }

    @Override
    public double getMinItem() {
        if (this.isEmpty() || Double.isNaN(this.minDoubleItem)) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        return this.minDoubleItem;
    }

    @Override
    String getMinItemAsString() {
        return Double.toString(this.minDoubleItem);
    }

    @Override
    byte[] getMinMaxByteArr() {
        byte[] bytesOut = new byte[16];
        ByteArrayUtil.putDoubleLE(bytesOut, 0, this.minDoubleItem);
        ByteArrayUtil.putDoubleLE(bytesOut, 8, this.maxDoubleItem);
        return bytesOut;
    }

    @Override
    void setMaxItem(double item) {
        this.maxDoubleItem = item;
    }

    @Override
    void setMinItem(double item) {
        this.minDoubleItem = item;
    }

    @Override
    public long getN() {
        return this.n;
    }

    @Override
    double[] getDoubleItemsArray() {
        return this.doubleItems;
    }

    @Override
    double getDoubleSingleItem() {
        if (this.n != 1L) {
            throw new SketchesArgumentException("Sketch does not have just one item. ");
        }
        return this.doubleItems[this.k - 1];
    }

    @Override
    int getM() {
        return this.m;
    }

    @Override
    MemoryRequestServer getMemoryRequestServer() {
        return null;
    }

    @Override
    int getMinK() {
        return this.minK;
    }

    @Override
    byte[] getRetainedItemsByteArr() {
        if (this.isEmpty()) {
            return new byte[0];
        }
        if (this.isSingleItem()) {
            byte[] bytesOut = new byte[8];
            ByteArrayUtil.putDoubleLE(bytesOut, 0, this.getDoubleSingleItem());
            return bytesOut;
        }
        int retained = this.getNumRetained();
        int bytes = retained * 8;
        byte[] bytesOut = new byte[bytes];
        WritableMemory wmem = WritableMemory.writableWrap(bytesOut);
        wmem.putDoubleArray(0L, this.doubleItems, this.levelsArr[0], retained);
        return bytesOut;
    }

    @Override
    byte[] getTotalItemsByteArr() {
        byte[] byteArr = new byte[this.doubleItems.length * 8];
        WritableMemory wmem = WritableMemory.writableWrap(byteArr);
        wmem.putDoubleArray(0L, this.doubleItems, 0, this.doubleItems.length);
        return byteArr;
    }

    @Override
    WritableMemory getWritableMemory() {
        return null;
    }

    @Override
    void incN(int increment) {
        this.n += (long)increment;
    }

    @Override
    void incNumLevels() {
    }

    @Override
    boolean isLevelZeroSorted() {
        return this.isLevelZeroSorted;
    }

    @Override
    void setDoubleItemsArray(double[] doubleItems) {
        this.doubleItems = doubleItems;
    }

    @Override
    void setDoubleItemsArrayAt(int index, double item) {
        this.doubleItems[index] = item;
    }

    @Override
    void setDoubleItemsArrayAt(int dstIndex, double[] srcItems, int srcOffset, int length) {
        System.arraycopy(srcItems, srcOffset, this.doubleItems, dstIndex, length);
    }

    @Override
    void setLevelZeroSorted(boolean sorted) {
        this.isLevelZeroSorted = sorted;
    }

    @Override
    void setMinK(int minK) {
        this.minK = minK;
    }

    @Override
    void setN(long n) {
        this.n = n;
    }

    @Override
    void setNumLevels(int numLevels) {
    }

    @Override
    double[] getDoubleRetainedItemsArray() {
        return Arrays.copyOfRange(this.doubleItems, this.levelsArr[0], this.levelsArr[this.getNumLevels()]);
    }

    @Override
    void setWritableMemory(WritableMemory wmem) {
    }
}

