/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestReader;
import org.apache.iceberg.ManifestWriter;
import org.apache.iceberg.PartitionData;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SnapshotProducer;
import org.apache.iceberg.SnapshotSummary;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.InclusiveMetricsEvaluator;
import org.apache.iceberg.expressions.ManifestEvaluator;
import org.apache.iceberg.expressions.ResidualEvaluator;
import org.apache.iceberg.expressions.StrictMetricsEvaluator;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.util.CharSequenceSet;
import org.apache.iceberg.util.ManifestFileUtil;
import org.apache.iceberg.util.Pair;
import org.apache.iceberg.util.PartitionSet;
import org.apache.iceberg.util.StructLikeMap;
import org.apache.iceberg.util.Tasks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ManifestFilterManager<F extends ContentFile<F>> {
    private static final Logger LOG = LoggerFactory.getLogger(ManifestFilterManager.class);
    private static final Joiner COMMA = Joiner.on(",");
    private final Map<Integer, PartitionSpec> specsById;
    private final PartitionSet deleteFilePartitions;
    private final Set<F> deleteFiles = this.newFileSet();
    private final Set<String> manifestsWithDeletes = Sets.newHashSet();
    private final PartitionSet dropPartitions;
    private final CharSequenceSet deletePaths = CharSequenceSet.empty();
    private Expression deleteExpression = Expressions.alwaysFalse();
    private long minSequenceNumber = 0L;
    private boolean failAnyDelete = false;
    private boolean failMissingDeletePaths = false;
    private int duplicateDeleteCount = 0;
    private boolean caseSensitive = true;
    private boolean allDeletesReferenceManifests = true;
    private final Map<ManifestFile, ManifestFile> filteredManifests = Maps.newConcurrentMap();
    private final Map<ManifestFile, Iterable<F>> filteredManifestToDeletedFiles = Maps.newConcurrentMap();
    private final Supplier<ExecutorService> workerPoolSupplier;

    protected ManifestFilterManager(Map<Integer, PartitionSpec> specsById, Supplier<ExecutorService> executorSupplier) {
        this.specsById = specsById;
        this.deleteFilePartitions = PartitionSet.create(specsById);
        this.dropPartitions = PartitionSet.create(specsById);
        this.workerPoolSupplier = executorSupplier;
    }

    protected abstract void deleteFile(String var1);

    protected abstract ManifestWriter<F> newManifestWriter(PartitionSpec var1);

    protected abstract ManifestReader<F> newManifestReader(ManifestFile var1);

    protected abstract Set<F> newFileSet();

    protected void failAnyDelete() {
        this.failAnyDelete = true;
    }

    protected void failMissingDeletePaths() {
        this.failMissingDeletePaths = true;
    }

    protected void deleteByRowFilter(Expression expr) {
        Preconditions.checkNotNull(expr, "Cannot delete files using filter: null");
        this.invalidateFilteredCache();
        this.deleteExpression = Expressions.or(this.deleteExpression, expr);
        this.allDeletesReferenceManifests = false;
    }

    protected void dropPartition(int specId, StructLike partition) {
        Preconditions.checkNotNull(partition, "Cannot delete files in invalid partition: null");
        this.invalidateFilteredCache();
        this.dropPartitions.add(specId, partition);
        this.allDeletesReferenceManifests = false;
    }

    protected void dropDeleteFilesOlderThan(long sequenceNumber) {
        Preconditions.checkArgument(sequenceNumber >= 0L, "Invalid minimum data sequence number: %s", sequenceNumber);
        this.minSequenceNumber = sequenceNumber;
    }

    void caseSensitive(boolean newCaseSensitive) {
        this.caseSensitive = newCaseSensitive;
    }

    void delete(F file) {
        Preconditions.checkNotNull(file, "Cannot delete file: null");
        this.invalidateFilteredCache();
        if (file.manifestLocation() == null) {
            this.allDeletesReferenceManifests = false;
        } else {
            this.manifestsWithDeletes.add(file.manifestLocation());
        }
        this.deleteFiles.add(file);
        this.deleteFilePartitions.add(file.specId(), file.partition());
    }

    void delete(CharSequence path) {
        Preconditions.checkNotNull(path, "Cannot delete file path: null");
        this.invalidateFilteredCache();
        this.allDeletesReferenceManifests = false;
        this.deletePaths.add(path);
    }

    boolean containsDeletes() {
        return !this.deletePaths.isEmpty() || !this.deleteFiles.isEmpty() || this.deleteExpression != Expressions.alwaysFalse() || !this.dropPartitions.isEmpty();
    }

    List<ManifestFile> filterManifests(Schema tableSchema, List<ManifestFile> manifests) {
        if (manifests == null || manifests.isEmpty()) {
            this.validateRequiredDeletes(new ManifestFile[0]);
            return ImmutableList.of();
        }
        boolean trustManifestReferences = this.canTrustManifestReferences(manifests);
        ManifestFile[] filtered = new ManifestFile[manifests.size()];
        Tasks.range(filtered.length).stopOnFailure().throwFailureWhenFinished().executeWith(this.workerPoolSupplier.get()).run(index -> {
            ManifestFile manifest;
            filtered[index.intValue()] = manifest = this.filterManifest(tableSchema, (ManifestFile)manifests.get((int)index), trustManifestReferences);
        });
        this.validateRequiredDeletes(filtered);
        return Arrays.asList(filtered);
    }

    private boolean canTrustManifestReferences(List<ManifestFile> manifests) {
        Set manifestLocations = manifests.stream().map(ManifestFile::path).collect(Collectors.toSet());
        return this.allDeletesReferenceManifests && manifestLocations.containsAll(this.manifestsWithDeletes);
    }

    SnapshotSummary.Builder buildSummary(Iterable<ManifestFile> manifests) {
        SnapshotSummary.Builder summaryBuilder = SnapshotSummary.builder();
        for (ManifestFile manifest : manifests) {
            PartitionSpec manifestSpec = this.specsById.get(manifest.partitionSpecId());
            Iterable<F> manifestDeletes = this.filteredManifestToDeletedFiles.get(manifest);
            if (manifestDeletes == null) continue;
            for (ContentFile file : manifestDeletes) {
                summaryBuilder.deletedFile(manifestSpec, file);
            }
        }
        summaryBuilder.incrementDuplicateDeletes(this.duplicateDeleteCount);
        return summaryBuilder;
    }

    private void validateRequiredDeletes(ManifestFile ... manifests) {
        if (this.failMissingDeletePaths) {
            Set deletedFiles = this.deletedFiles(manifests);
            ValidationException.check(deletedFiles.containsAll(this.deleteFiles), "Missing required files to delete: %s", COMMA.join(this.deleteFiles.stream().filter(f -> !deletedFiles.contains(f)).map(ContentFile::location).collect(Collectors.toList())));
            CharSequenceSet deletedFilePaths = deletedFiles.stream().map(ContentFile::location).collect(Collectors.toCollection(CharSequenceSet::empty));
            ValidationException.check(deletedFilePaths.containsAll(this.deletePaths), "Missing required files to delete: %s", COMMA.join(Iterables.filter(this.deletePaths, path -> !deletedFilePaths.contains(path))));
        }
    }

    private Set<F> deletedFiles(ManifestFile[] manifests) {
        Set<F> deletedFiles = this.newFileSet();
        if (manifests != null) {
            for (ManifestFile manifest : manifests) {
                Iterable<F> manifestDeletes = this.filteredManifestToDeletedFiles.get(manifest);
                if (manifestDeletes == null) continue;
                for (ContentFile file : manifestDeletes) {
                    deletedFiles.add(file);
                }
            }
        }
        return deletedFiles;
    }

    void cleanUncommitted(Set<ManifestFile> committed) {
        ArrayList<Map.Entry<ManifestFile, ManifestFile>> filterEntries = Lists.newArrayList(this.filteredManifests.entrySet());
        for (Map.Entry entry : filterEntries) {
            ManifestFile manifest = (ManifestFile)entry.getKey();
            ManifestFile filtered = (ManifestFile)entry.getValue();
            if (committed.contains(filtered)) continue;
            if (!manifest.equals(filtered)) {
                this.deleteFile(filtered.path());
            }
            this.filteredManifests.remove(manifest);
        }
    }

    private void invalidateFilteredCache() {
        this.cleanUncommitted(SnapshotProducer.EMPTY_SET);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ManifestFile filterManifest(Schema tableSchema, ManifestFile manifest, boolean trustManifestReferences) {
        ManifestFile cached = this.filteredManifests.get(manifest);
        if (cached != null) {
            return cached;
        }
        if (!this.canContainDeletedFiles(manifest, trustManifestReferences)) {
            this.filteredManifests.put(manifest, manifest);
            return manifest;
        }
        try (ManifestReader<F> reader = this.newManifestReader(manifest);){
            PartitionSpec spec = reader.spec();
            PartitionAndMetricsEvaluator evaluator = new PartitionAndMetricsEvaluator(tableSchema, spec, this.deleteExpression);
            if (this.manifestHasDeletedFiles(evaluator, manifest, reader)) {
                ManifestFile manifestFile2 = this.filterManifestWithDeletedFiles(evaluator, manifest, reader);
                return manifestFile2;
            }
            this.filteredManifests.put(manifest, manifest);
            ManifestFile manifestFile = manifest;
            return manifestFile;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to close manifest: %s", manifest);
        }
    }

    private boolean canContainDeletedFiles(ManifestFile manifest, boolean trustManifestReferences) {
        if (this.hasNoLiveFiles(manifest)) {
            return false;
        }
        if (trustManifestReferences) {
            return this.manifestsWithDeletes.contains(manifest.path());
        }
        return this.canContainDroppedFiles(manifest) || this.canContainExpressionDeletes(manifest) || this.canContainDroppedPartitions(manifest);
    }

    private boolean hasNoLiveFiles(ManifestFile manifest) {
        return !manifest.hasAddedFiles() && !manifest.hasExistingFiles();
    }

    private boolean canContainExpressionDeletes(ManifestFile manifest) {
        if (this.deleteExpression != null && this.deleteExpression != Expressions.alwaysFalse()) {
            ManifestEvaluator manifestEvaluator = ManifestEvaluator.forRowFilter(this.deleteExpression, this.specsById.get(manifest.partitionSpecId()), this.caseSensitive);
            return manifestEvaluator.eval(manifest);
        }
        return false;
    }

    private boolean canContainDroppedPartitions(ManifestFile manifest) {
        if (!this.dropPartitions.isEmpty()) {
            return ManifestFileUtil.canContainAny(manifest, this.dropPartitions, this.specsById);
        }
        return false;
    }

    private boolean canContainDroppedFiles(ManifestFile manifest) {
        if (!this.deletePaths.isEmpty()) {
            return true;
        }
        if (!this.deleteFiles.isEmpty()) {
            return ManifestFileUtil.canContainAny(manifest, this.deleteFilePartitions, this.specsById);
        }
        return false;
    }

    private boolean manifestHasDeletedFiles(PartitionAndMetricsEvaluator evaluator, ManifestFile manifest, ManifestReader<F> reader) {
        if (this.manifestsWithDeletes.contains(manifest.path())) {
            return true;
        }
        boolean isDelete = reader.isDeleteManifestReader();
        for (ManifestEntry manifestEntry : reader.liveEntries()) {
            boolean markedForDelete;
            Object file = manifestEntry.file();
            boolean bl = markedForDelete = this.deletePaths.contains(file.location()) || this.deleteFiles.contains(file) || this.dropPartitions.contains(file.specId(), file.partition()) || isDelete && manifestEntry.isLive() && manifestEntry.dataSequenceNumber() > 0L && manifestEntry.dataSequenceNumber() < this.minSequenceNumber;
            if (!markedForDelete && !evaluator.rowsMightMatch(file)) continue;
            boolean allRowsMatch = markedForDelete || evaluator.rowsMustMatch(file);
            ValidationException.check(allRowsMatch || isDelete, "Cannot delete file where some, but not all, rows match filter %s: %s", this.deleteExpression, file.location());
            if (!allRowsMatch) continue;
            if (this.failAnyDelete) {
                throw new DeleteException(reader.spec().partitionToPath(file.partition()));
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ManifestFile filterManifestWithDeletedFiles(PartitionAndMetricsEvaluator evaluator, ManifestFile manifest, ManifestReader<F> reader) {
        boolean isDelete = reader.isDeleteManifestReader();
        Set<F> deletedFiles = this.newFileSet();
        try {
            try (ManifestWriter<F> writer = this.newManifestWriter(reader.spec());){
                reader.liveEntries().forEach(entry -> {
                    boolean markedForDelete;
                    Object file = entry.file();
                    boolean bl = markedForDelete = this.deletePaths.contains(file.location()) || this.deleteFiles.contains(file) || this.dropPartitions.contains(file.specId(), file.partition()) || isDelete && entry.isLive() && entry.dataSequenceNumber() > 0L && entry.dataSequenceNumber() < this.minSequenceNumber;
                    if (markedForDelete || evaluator.rowsMightMatch(file)) {
                        boolean allRowsMatch = markedForDelete || evaluator.rowsMustMatch(file);
                        ValidationException.check(allRowsMatch || isDelete, "Cannot delete file where some, but not all, rows match filter %s: %s", this.deleteExpression, file.location());
                        if (allRowsMatch) {
                            writer.delete((ManifestEntry<F>)entry);
                            if (deletedFiles.contains(file)) {
                                LOG.warn("Deleting a duplicate path from manifest {}: {}", (Object)manifest.path(), (Object)file.location());
                                ++this.duplicateDeleteCount;
                            } else {
                                deletedFiles.add((ContentFile)file.copyWithoutStats());
                            }
                        } else {
                            writer.existing((ManifestEntry<F>)entry);
                        }
                    } else {
                        writer.existing((ManifestEntry<F>)entry);
                    }
                });
            }
            ManifestFile filtered = writer.toManifestFile();
            this.filteredManifests.put(manifest, filtered);
            this.filteredManifestToDeletedFiles.put(filtered, deletedFiles);
            return filtered;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to close manifest writer", new Object[0]);
        }
    }

    private class PartitionAndMetricsEvaluator {
        private final Schema tableSchema;
        private final ResidualEvaluator residualEvaluator;
        private final StructLikeMap<Pair<InclusiveMetricsEvaluator, StrictMetricsEvaluator>> metricsEvaluators;

        PartitionAndMetricsEvaluator(Schema tableSchema, PartitionSpec spec, Expression expr) {
            this.tableSchema = tableSchema;
            this.residualEvaluator = ResidualEvaluator.of(spec, expr, ManifestFilterManager.this.caseSensitive);
            this.metricsEvaluators = StructLikeMap.create(spec.partitionType());
        }

        boolean rowsMightMatch(F file) {
            Pair<InclusiveMetricsEvaluator, StrictMetricsEvaluator> evaluators = this.metricsEvaluators(file);
            InclusiveMetricsEvaluator inclusiveMetricsEvaluator = evaluators.first();
            return inclusiveMetricsEvaluator.eval((ContentFile<?>)file);
        }

        boolean rowsMustMatch(F file) {
            Pair<InclusiveMetricsEvaluator, StrictMetricsEvaluator> evaluators = this.metricsEvaluators(file);
            StrictMetricsEvaluator strictMetricsEvaluator = evaluators.second();
            return strictMetricsEvaluator.eval((ContentFile<?>)file);
        }

        private Pair<InclusiveMetricsEvaluator, StrictMetricsEvaluator> metricsEvaluators(F file) {
            PartitionData partition = (PartitionData)file.partition();
            if (!this.metricsEvaluators.containsKey(partition)) {
                Expression residual = this.residualEvaluator.residualFor(partition);
                InclusiveMetricsEvaluator inclusive = new InclusiveMetricsEvaluator(this.tableSchema, residual, ManifestFilterManager.this.caseSensitive);
                StrictMetricsEvaluator strict = new StrictMetricsEvaluator(this.tableSchema, residual, ManifestFilterManager.this.caseSensitive);
                this.metricsEvaluators.put(partition.copy(), Pair.of(inclusive, strict));
            }
            return this.metricsEvaluators.get(partition);
        }
    }

    protected static class DeleteException
    extends ValidationException {
        private final String partition;

        private DeleteException(String partition) {
            super("Operation would delete existing data", new Object[0]);
            this.partition = partition;
        }

        public String partition() {
            return this.partition;
        }
    }
}

