/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aliyun.oss;

import com.aliyun.oss.OSS;
import com.aliyun.oss.model.GetObjectRequest;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.iceberg.aliyun.oss.OSSURI;
import org.apache.iceberg.io.SeekableInputStream;
import org.apache.iceberg.metrics.Counter;
import org.apache.iceberg.metrics.MetricsContext;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.io.ByteStreams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OSSInputStream
extends SeekableInputStream {
    private static final Logger LOG = LoggerFactory.getLogger(OSSInputStream.class);
    private static final int SKIP_SIZE = 0x100000;
    private final StackTraceElement[] createStack;
    private final OSS client;
    private final OSSURI uri;
    private InputStream stream = null;
    private long pos = 0L;
    private long next = 0L;
    private boolean closed = false;
    private final Counter readBytes;
    private final Counter readOperations;

    OSSInputStream(OSS client, OSSURI uri) {
        this(client, uri, MetricsContext.nullMetrics());
    }

    OSSInputStream(OSS client, OSSURI uri, MetricsContext metrics) {
        this.client = client;
        this.uri = uri;
        this.createStack = Thread.currentThread().getStackTrace();
        this.readBytes = metrics.counter("read.bytes", MetricsContext.Unit.BYTES);
        this.readOperations = metrics.counter("read.operations");
    }

    @Override
    public long getPos() {
        return this.next;
    }

    @Override
    public void seek(long newPos) {
        Preconditions.checkState(!this.closed, "Cannot seek: already closed");
        Preconditions.checkArgument(newPos >= 0L, "Position is negative: %s", newPos);
        this.next = newPos;
    }

    @Override
    public int read() throws IOException {
        Preconditions.checkState(!this.closed, "Cannot read: already closed");
        this.positionStream();
        ++this.pos;
        ++this.next;
        this.readBytes.increment();
        this.readOperations.increment();
        return this.stream.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        Preconditions.checkState(!this.closed, "Cannot read: already closed");
        this.positionStream();
        int bytesRead = this.stream.read(b, off, len);
        this.pos += (long)bytesRead;
        this.next += (long)bytesRead;
        this.readBytes.increment(bytesRead);
        this.readOperations.increment();
        return bytesRead;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        super.close();
        this.closeStream();
        this.closed = true;
    }

    private void positionStream() throws IOException {
        long skip;
        if (this.stream != null && this.next == this.pos) {
            return;
        }
        if (this.stream != null && this.next > this.pos && (skip = this.next - this.pos) <= (long)Math.max(this.stream.available(), 0x100000)) {
            LOG.debug("Read-through seek for {} from {} to offset {}", new Object[]{this.uri, this.pos, this.next});
            try {
                ByteStreams.skipFully(this.stream, skip);
                this.pos = this.next;
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        LOG.debug("Seek with new stream for {} to offset {}", (Object)this.uri, (Object)this.next);
        this.pos = this.next;
        this.openStream();
    }

    private void openStream() throws IOException {
        this.closeStream();
        GetObjectRequest request = new GetObjectRequest(this.uri.bucket(), this.uri.key()).withRange(this.pos, -1L);
        this.stream = this.client.getObject(request).getObjectContent();
    }

    private void closeStream() throws IOException {
        if (this.stream != null) {
            this.stream.close();
            this.stream = null;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.closed) {
            this.close();
            String trace = Joiner.on("\n\t").join(Arrays.copyOfRange(this.createStack, 1, this.createStack.length));
            LOG.warn("Unclosed input stream created by: \n\t{}", (Object)trace);
        }
    }
}

