/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.azure.adlsv2;

import com.azure.core.http.HttpClient;
import com.azure.core.util.Context;
import com.azure.storage.file.datalake.DataLakeFileClient;
import com.azure.storage.file.datalake.DataLakeFileSystemClient;
import com.azure.storage.file.datalake.DataLakeFileSystemClientBuilder;
import com.azure.storage.file.datalake.models.DataLakeStorageException;
import com.azure.storage.file.datalake.models.ListPathsOptions;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iceberg.azure.AzureProperties;
import org.apache.iceberg.azure.adlsv2.ADLSInputFile;
import org.apache.iceberg.azure.adlsv2.ADLSLocation;
import org.apache.iceberg.azure.adlsv2.ADLSOutputFile;
import org.apache.iceberg.common.DynConstructors;
import org.apache.iceberg.io.BulkDeletionFailureException;
import org.apache.iceberg.io.DelegateFileIO;
import org.apache.iceberg.io.FileInfo;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.metrics.MetricsContext;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.util.SerializableMap;
import org.apache.iceberg.util.Tasks;
import org.apache.iceberg.util.ThreadPools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ADLSFileIO
implements DelegateFileIO {
    private static final Logger LOG = LoggerFactory.getLogger(ADLSFileIO.class);
    private static final String DEFAULT_METRICS_IMPL = "org.apache.iceberg.hadoop.HadoopMetricsContext";
    private static final HttpClient HTTP = HttpClient.createDefault();
    private AzureProperties azureProperties;
    private MetricsContext metrics = MetricsContext.nullMetrics();
    private SerializableMap<String, String> properties;

    public ADLSFileIO() {
    }

    @VisibleForTesting
    ADLSFileIO(AzureProperties azureProperties) {
        this.azureProperties = azureProperties;
    }

    @Override
    public InputFile newInputFile(String path) {
        return new ADLSInputFile(path, this.fileClient(path), this.azureProperties, this.metrics);
    }

    @Override
    public InputFile newInputFile(String path, long length) {
        return new ADLSInputFile(path, length, this.fileClient(path), this.azureProperties, this.metrics);
    }

    @Override
    public OutputFile newOutputFile(String path) {
        return new ADLSOutputFile(path, this.fileClient(path), this.azureProperties, this.metrics);
    }

    @Override
    public void deleteFile(String path) {
        try {
            this.fileClient(path).delete();
        }
        catch (DataLakeStorageException e) {
            LOG.warn("Failed to delete path: {}", (Object)path, (Object)e);
        }
    }

    @Override
    public Map<String, String> properties() {
        return this.properties.immutableMap();
    }

    public DataLakeFileSystemClient client(String path) {
        ADLSLocation location = new ADLSLocation(path);
        return this.client(location);
    }

    @VisibleForTesting
    DataLakeFileSystemClient client(ADLSLocation location) {
        DataLakeFileSystemClientBuilder clientBuilder = new DataLakeFileSystemClientBuilder().httpClient(HTTP);
        location.container().ifPresent(arg_0 -> ((DataLakeFileSystemClientBuilder)clientBuilder).fileSystemName(arg_0));
        this.azureProperties.applyClientConfiguration(location.host(), clientBuilder);
        return clientBuilder.buildClient();
    }

    private DataLakeFileClient fileClient(String path) {
        ADLSLocation location = new ADLSLocation(path);
        return this.client(location).getFileClient(location.path());
    }

    @Override
    public void initialize(Map<String, String> props) {
        this.properties = SerializableMap.copyOf(props);
        this.azureProperties = new AzureProperties(this.properties);
        this.initMetrics(this.properties);
    }

    private void initMetrics(Map<String, String> props) {
        try {
            DynConstructors.Ctor ctor = DynConstructors.builder(MetricsContext.class).hiddenImpl(DEFAULT_METRICS_IMPL, String.class).buildChecked();
            MetricsContext context = (MetricsContext)ctor.newInstance("adls");
            context.initialize(props);
            this.metrics = context;
        }
        catch (ClassCastException | NoClassDefFoundError | NoSuchMethodException e) {
            LOG.warn("Unable to load metrics class: '{}', falling back to null metrics", (Object)DEFAULT_METRICS_IMPL);
        }
    }

    @Override
    public void deleteFiles(Iterable<String> pathsToDelete) throws BulkDeletionFailureException {
        AtomicInteger failureCount = new AtomicInteger();
        Tasks.foreach(pathsToDelete).executeWith(ThreadPools.getWorkerPool()).noRetry().suppressFailureWhenFinished().onFailure((file, exc) -> {
            failureCount.incrementAndGet();
            LOG.warn("Failed to delete file {}", file, (Object)exc);
        }).run(this::deleteFile);
        if (failureCount.get() > 0) {
            throw new BulkDeletionFailureException(failureCount.get());
        }
    }

    @Override
    public Iterable<FileInfo> listPrefix(String prefix) {
        ADLSLocation location = new ADLSLocation(prefix);
        ListPathsOptions options = new ListPathsOptions();
        options.setPath(location.path());
        options.setRecursive(true);
        return () -> {
            try {
                return this.client(location).listPaths(options, null).stream().filter(pathItem -> !pathItem.isDirectory()).map(pathItem -> new FileInfo(pathItem.getName(), pathItem.getContentLength(), pathItem.getCreationTime().toInstant().toEpochMilli())).iterator();
            }
            catch (DataLakeStorageException e) {
                if (e.getStatusCode() != 404) {
                    throw e;
                }
                return Collections.emptyIterator();
            }
        };
    }

    @Override
    public void deletePrefix(String prefix) {
        block2: {
            ADLSLocation location = new ADLSLocation(prefix);
            try {
                this.client(location).deleteDirectoryWithResponse(location.path(), true, null, null, Context.NONE).getValue();
            }
            catch (DataLakeStorageException e) {
                if (e.getStatusCode() == 404) break block2;
                throw e;
            }
        }
    }
}

