/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.azure.adlsv2;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

class ADLSLocation {
    private static final Pattern URI_PATTERN = Pattern.compile("^(abfss?|wasbs?)://([^/?#]+)(.*)?$");
    private final String storageAccount;
    private final String container;
    private final String path;
    private final String host;

    ADLSLocation(String location) {
        Preconditions.checkArgument(location != null, "Invalid location: null");
        Matcher matcher = URI_PATTERN.matcher(location);
        ValidationException.check(matcher.matches(), "Invalid ADLS URI: %s", location);
        String authority = matcher.group(2);
        String[] parts = authority.split("@", -1);
        if (parts.length > 1) {
            this.container = parts[0];
            this.host = parts[1];
            this.storageAccount = this.host.split("\\.", -1)[0];
        } else {
            this.container = null;
            this.host = authority;
            this.storageAccount = authority.split("\\.", -1)[0];
        }
        String uriPath = matcher.group(3);
        this.path = uriPath == null ? "" : (uriPath.startsWith("/") ? uriPath.substring(1) : uriPath);
    }

    public String storageAccount() {
        return this.storageAccount;
    }

    public Optional<String> container() {
        return Optional.ofNullable(this.container);
    }

    public String path() {
        return this.path;
    }

    public String host() {
        return this.host;
    }
}

