/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data.avro;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.function.Function;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.ProjectionDatumReader;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.shaded.org.apache.avro.io.BinaryDecoder;
import org.apache.iceberg.shaded.org.apache.avro.io.DatumReader;
import org.apache.iceberg.shaded.org.apache.avro.io.DecoderFactory;
import org.apache.iceberg.shaded.org.apache.avro.message.MessageDecoder;

public class RawDecoder<D>
extends MessageDecoder.BaseDecoder<D> {
    private static final ThreadLocal<BinaryDecoder> DECODER = new ThreadLocal();
    private final DatumReader<D> reader;

    public static <D> RawDecoder<D> create(Schema readSchema, Function<Schema, DatumReader<D>> readerFunction, org.apache.iceberg.shaded.org.apache.avro.Schema writeSchema) {
        DatumReader<D> reader = readerFunction.apply(readSchema);
        reader.setSchema(writeSchema);
        return new RawDecoder<D>(reader);
    }

    @Deprecated
    public RawDecoder(Schema readSchema, Function<org.apache.iceberg.shaded.org.apache.avro.Schema, DatumReader<?>> readerFunction, org.apache.iceberg.shaded.org.apache.avro.Schema writeSchema) {
        this.reader = new ProjectionDatumReader(readerFunction, readSchema, ImmutableMap.of(), null);
        this.reader.setSchema(writeSchema);
    }

    private RawDecoder(DatumReader<D> reader) {
        this.reader = reader;
    }

    @Override
    public D decode(InputStream stream, D reuse) {
        BinaryDecoder decoder = DecoderFactory.get().directBinaryDecoder(stream, DECODER.get());
        DECODER.set(decoder);
        try {
            return this.reader.read(reuse, decoder);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Decoding datum failed", e);
        }
    }
}

