/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data.parquet;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.iceberg.data.parquet.GenericParquetWriter;
import org.apache.iceberg.parquet.ParquetTypeVisitor;
import org.apache.iceberg.parquet.ParquetValueWriter;
import org.apache.iceberg.parquet.ParquetValueWriters;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.shaded.org.apache.parquet.column.ColumnDescriptor;
import org.apache.iceberg.shaded.org.apache.parquet.schema.GroupType;
import org.apache.iceberg.shaded.org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.iceberg.shaded.org.apache.parquet.schema.MessageType;
import org.apache.iceberg.shaded.org.apache.parquet.schema.PrimitiveType;
import org.apache.iceberg.shaded.org.apache.parquet.schema.Type;

@Deprecated
public abstract class BaseParquetWriter<T> {
    protected ParquetValueWriter<T> createWriter(MessageType type) {
        return (ParquetValueWriter)ParquetTypeVisitor.visit(type, new WriteBuilder(type));
    }

    protected abstract ParquetValueWriters.StructWriter<T> createStructWriter(List<ParquetValueWriter<?>> var1);

    protected ParquetValueWriter<?> fixedWriter(ColumnDescriptor desc) {
        return new GenericParquetWriter.FixedWriter(desc);
    }

    protected ParquetValueWriter<?> dateWriter(ColumnDescriptor desc) {
        return new GenericParquetWriter.DateWriter(desc);
    }

    protected ParquetValueWriter<?> timeWriter(ColumnDescriptor desc) {
        return new GenericParquetWriter.TimeWriter(desc);
    }

    protected ParquetValueWriter<?> timestampWriter(ColumnDescriptor desc, boolean isAdjustedToUTC) {
        if (isAdjustedToUTC) {
            return new GenericParquetWriter.TimestamptzWriter(desc);
        }
        return new GenericParquetWriter.TimestampWriter(desc);
    }

    private class LogicalTypeWriterVisitor
    implements LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<ParquetValueWriter<?>> {
        private final ColumnDescriptor desc;

        private LogicalTypeWriterVisitor(ColumnDescriptor desc) {
            this.desc = desc;
        }

        @Override
        public Optional<ParquetValueWriter<?>> visit(LogicalTypeAnnotation.StringLogicalTypeAnnotation stringType) {
            return Optional.of(ParquetValueWriters.strings(this.desc));
        }

        @Override
        public Optional<ParquetValueWriter<?>> visit(LogicalTypeAnnotation.EnumLogicalTypeAnnotation enumType) {
            return Optional.of(ParquetValueWriters.strings(this.desc));
        }

        @Override
        public Optional<ParquetValueWriter<?>> visit(LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalType) {
            switch (this.desc.getPrimitiveType().getPrimitiveTypeName()) {
                case INT32: {
                    return Optional.of(ParquetValueWriters.decimalAsInteger(this.desc, decimalType.getPrecision(), decimalType.getScale()));
                }
                case INT64: {
                    return Optional.of(ParquetValueWriters.decimalAsLong(this.desc, decimalType.getPrecision(), decimalType.getScale()));
                }
                case FIXED_LEN_BYTE_ARRAY: 
                case BINARY: {
                    return Optional.of(ParquetValueWriters.decimalAsFixed(this.desc, decimalType.getPrecision(), decimalType.getScale()));
                }
            }
            return Optional.empty();
        }

        @Override
        public Optional<ParquetValueWriter<?>> visit(LogicalTypeAnnotation.DateLogicalTypeAnnotation dateType) {
            return Optional.of(BaseParquetWriter.this.dateWriter(this.desc));
        }

        @Override
        public Optional<ParquetValueWriter<?>> visit(LogicalTypeAnnotation.TimeLogicalTypeAnnotation timeType) {
            Preconditions.checkArgument(LogicalTypeAnnotation.TimeUnit.MICROS.equals((Object)timeType.getUnit()), "Cannot write time in %s, only MICROS is supported", (Object)timeType.getUnit());
            return Optional.of(BaseParquetWriter.this.timeWriter(this.desc));
        }

        @Override
        public Optional<ParquetValueWriter<?>> visit(LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timestampType) {
            Preconditions.checkArgument(LogicalTypeAnnotation.TimeUnit.MICROS.equals((Object)timestampType.getUnit()), "Cannot write timestamp in %s, only MICROS is supported", (Object)timestampType.getUnit());
            return Optional.of(BaseParquetWriter.this.timestampWriter(this.desc, timestampType.isAdjustedToUTC()));
        }

        @Override
        public Optional<ParquetValueWriter<?>> visit(LogicalTypeAnnotation.IntLogicalTypeAnnotation intType) {
            Preconditions.checkArgument(intType.isSigned() || intType.getBitWidth() < 64, "Cannot read uint64: not a supported Java type");
            if (intType.getBitWidth() < 64) {
                return Optional.of(ParquetValueWriters.ints(this.desc));
            }
            return Optional.of(ParquetValueWriters.longs(this.desc));
        }

        @Override
        public Optional<ParquetValueWriter<?>> visit(LogicalTypeAnnotation.JsonLogicalTypeAnnotation jsonLogicalType) {
            return Optional.of(ParquetValueWriters.strings(this.desc));
        }

        @Override
        public Optional<ParquetValueWriter<?>> visit(LogicalTypeAnnotation.BsonLogicalTypeAnnotation bsonType) {
            return Optional.of(ParquetValueWriters.byteBuffers(this.desc));
        }

        @Override
        public Optional<ParquetValueWriter<?>> visit(LogicalTypeAnnotation.UUIDLogicalTypeAnnotation uuidLogicalType) {
            return Optional.of(ParquetValueWriters.uuids(this.desc));
        }
    }

    private class WriteBuilder
    extends ParquetTypeVisitor<ParquetValueWriter<?>> {
        private final MessageType type;

        private WriteBuilder(MessageType type) {
            this.type = type;
        }

        @Override
        public ParquetValueWriter<?> message(MessageType message, List<ParquetValueWriter<?>> fieldWriters) {
            return this.struct(message.asGroupType(), (List)fieldWriters);
        }

        @Override
        public ParquetValueWriter<?> struct(GroupType struct, List<ParquetValueWriter<?>> fieldWriters) {
            List<Type> fields = struct.getFields();
            ArrayList<ParquetValueWriter<?>> writers = Lists.newArrayListWithExpectedSize(fieldWriters.size());
            for (int i = 0; i < fields.size(); ++i) {
                Type fieldType = struct.getType(i);
                int fieldD = this.type.getMaxDefinitionLevel(this.path(fieldType.getName()));
                writers.add(ParquetValueWriters.option(fieldType, fieldD, fieldWriters.get(i)));
            }
            return BaseParquetWriter.this.createStructWriter(writers);
        }

        @Override
        public ParquetValueWriter<?> list(GroupType array, ParquetValueWriter<?> elementWriter) {
            GroupType repeated = array.getFields().get(0).asGroupType();
            String[] repeatedPath = this.currentPath();
            int repeatedD = this.type.getMaxDefinitionLevel(repeatedPath);
            int repeatedR = this.type.getMaxRepetitionLevel(repeatedPath);
            Type elementType = repeated.getType(0);
            int elementD = this.type.getMaxDefinitionLevel(this.path(elementType.getName()));
            return ParquetValueWriters.collections(repeatedD, repeatedR, ParquetValueWriters.option(elementType, elementD, elementWriter));
        }

        @Override
        public ParquetValueWriter<?> map(GroupType map, ParquetValueWriter<?> keyWriter, ParquetValueWriter<?> valueWriter) {
            GroupType repeatedKeyValue = map.getFields().get(0).asGroupType();
            String[] repeatedPath = this.currentPath();
            int repeatedD = this.type.getMaxDefinitionLevel(repeatedPath);
            int repeatedR = this.type.getMaxRepetitionLevel(repeatedPath);
            Type keyType = repeatedKeyValue.getType(0);
            int keyD = this.type.getMaxDefinitionLevel(this.path(keyType.getName()));
            Type valueType = repeatedKeyValue.getType(1);
            int valueD = this.type.getMaxDefinitionLevel(this.path(valueType.getName()));
            return ParquetValueWriters.maps(repeatedD, repeatedR, ParquetValueWriters.option(keyType, keyD, keyWriter), ParquetValueWriters.option(valueType, valueD, valueWriter));
        }

        @Override
        public ParquetValueWriter<?> primitive(PrimitiveType primitive) {
            Optional writer;
            ColumnDescriptor desc = this.type.getColumnDescription(this.currentPath());
            LogicalTypeAnnotation logicalType = primitive.getLogicalTypeAnnotation();
            if (logicalType != null && (writer = logicalType.accept(new LogicalTypeWriterVisitor(desc))).isPresent()) {
                return (ParquetValueWriter)writer.get();
            }
            switch (primitive.getPrimitiveTypeName()) {
                case FIXED_LEN_BYTE_ARRAY: {
                    return BaseParquetWriter.this.fixedWriter(desc);
                }
                case BINARY: {
                    return ParquetValueWriters.byteBuffers(desc);
                }
                case BOOLEAN: {
                    return ParquetValueWriters.booleans(desc);
                }
                case INT32: {
                    return ParquetValueWriters.ints(desc);
                }
                case INT64: {
                    return ParquetValueWriters.longs(desc);
                }
                case FLOAT: {
                    return ParquetValueWriters.floats(desc);
                }
                case DOUBLE: {
                    return ParquetValueWriters.doubles(desc);
                }
            }
            throw new UnsupportedOperationException("Unsupported type: " + primitive);
        }
    }
}

