/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data.parquet;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.List;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.parquet.BaseParquetWriter;
import org.apache.iceberg.parquet.ParquetValueWriter;
import org.apache.iceberg.parquet.ParquetValueWriters;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.shaded.org.apache.parquet.column.ColumnDescriptor;
import org.apache.iceberg.shaded.org.apache.parquet.io.api.Binary;
import org.apache.iceberg.shaded.org.apache.parquet.schema.MessageType;

public class GenericParquetWriter
extends BaseParquetWriter<Record> {
    private static final GenericParquetWriter INSTANCE = new GenericParquetWriter();
    private static final OffsetDateTime EPOCH = Instant.ofEpochSecond(0L).atOffset(ZoneOffset.UTC);
    private static final LocalDate EPOCH_DAY = EPOCH.toLocalDate();

    private GenericParquetWriter() {
    }

    public static ParquetValueWriter<Record> buildWriter(MessageType type) {
        return INSTANCE.createWriter(type);
    }

    @Override
    protected ParquetValueWriters.StructWriter<Record> createStructWriter(List<ParquetValueWriter<?>> writers) {
        return ParquetValueWriters.recordWriter(writers);
    }

    static class FixedWriter
    extends ParquetValueWriters.PrimitiveWriter<byte[]> {
        private final int length;

        FixedWriter(ColumnDescriptor desc) {
            super(desc);
            this.length = desc.getPrimitiveType().getTypeLength();
        }

        @Override
        public void write(int repetitionLevel, byte[] value) {
            Preconditions.checkArgument(value.length == this.length, "Cannot write byte buffer of length %s as fixed[%s]", value.length, this.length);
            this.column.writeBinary(repetitionLevel, Binary.fromReusedByteArray(value));
        }
    }

    static class TimestamptzWriter
    extends ParquetValueWriters.PrimitiveWriter<OffsetDateTime> {
        TimestamptzWriter(ColumnDescriptor desc) {
            super(desc);
        }

        @Override
        public void write(int repetitionLevel, OffsetDateTime value) {
            this.column.writeLong(repetitionLevel, ChronoUnit.MICROS.between(EPOCH, value));
        }
    }

    static class TimestampWriter
    extends ParquetValueWriters.PrimitiveWriter<LocalDateTime> {
        TimestampWriter(ColumnDescriptor desc) {
            super(desc);
        }

        @Override
        public void write(int repetitionLevel, LocalDateTime value) {
            this.column.writeLong(repetitionLevel, ChronoUnit.MICROS.between(EPOCH, value.atOffset(ZoneOffset.UTC)));
        }
    }

    static class TimeWriter
    extends ParquetValueWriters.PrimitiveWriter<LocalTime> {
        TimeWriter(ColumnDescriptor desc) {
            super(desc);
        }

        @Override
        public void write(int repetitionLevel, LocalTime value) {
            this.column.writeLong(repetitionLevel, value.toNanoOfDay() / 1000L);
        }
    }

    static class DateWriter
    extends ParquetValueWriters.PrimitiveWriter<LocalDate> {
        DateWriter(ColumnDescriptor desc) {
            super(desc);
        }

        @Override
        public void write(int repetitionLevel, LocalDate value) {
            this.column.writeInteger(repetitionLevel, (int)ChronoUnit.DAYS.between(EPOCH_DAY, value));
        }
    }
}

