/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.maintenance.operator;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.iceberg.flink.maintenance.operator.TableChange;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class TriggerEvaluator
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(TriggerEvaluator.class);
    private final List<Predicate> predicates;

    private TriggerEvaluator(List<Predicate> predicates) {
        Preconditions.checkArgument(!predicates.isEmpty(), "Provide at least 1 condition.");
        this.predicates = predicates;
    }

    boolean check(TableChange event, long lastTimeMs, long currentTimeMs) {
        boolean result = this.predicates.stream().anyMatch(p -> p.evaluate(event, lastTimeMs, currentTimeMs));
        LOG.debug("Checking event: {}, at {}, last: {} with result: {}", new Object[]{event, currentTimeMs, lastTimeMs, result});
        return result;
    }

    private static interface Predicate
    extends Serializable {
        public boolean evaluate(TableChange var1, long var2, long var4);
    }

    public static class Builder
    implements Serializable {
        private Integer dataFileCount;
        private Long dataFileSizeInBytes;
        private Integer posDeleteFileCount;
        private Long posDeleteRecordCount;
        private Integer eqDeleteFileCount;
        private Long eqDeleteRecordCount;
        private Integer commitCount;
        private Duration timeout;

        public Builder dataFileCount(int newDataFileCount) {
            this.dataFileCount = newDataFileCount;
            return this;
        }

        public Builder dataFileSizeInBytes(long neDataFileSizeInBytes) {
            this.dataFileSizeInBytes = neDataFileSizeInBytes;
            return this;
        }

        public Builder posDeleteFileCount(int newPosDeleteFileCount) {
            this.posDeleteFileCount = newPosDeleteFileCount;
            return this;
        }

        public Builder posDeleteRecordCount(long newPosDeleteRecordCount) {
            this.posDeleteRecordCount = newPosDeleteRecordCount;
            return this;
        }

        public Builder eqDeleteFileCount(int newEqDeleteFileCount) {
            this.eqDeleteFileCount = newEqDeleteFileCount;
            return this;
        }

        public Builder eqDeleteRecordCount(long newEqDeleteRecordCount) {
            this.eqDeleteRecordCount = newEqDeleteRecordCount;
            return this;
        }

        public Builder commitCount(int newCommitCount) {
            this.commitCount = newCommitCount;
            return this;
        }

        public Builder timeout(Duration newTimeout) {
            this.timeout = newTimeout;
            return this;
        }

        public TriggerEvaluator build() {
            ArrayList<Predicate> predicates = Lists.newArrayList();
            if (this.dataFileCount != null) {
                predicates.add((change, unused, unused2) -> change.dataFileCount() >= this.dataFileCount);
            }
            if (this.dataFileSizeInBytes != null) {
                predicates.add((change, unused, unused2) -> change.dataFileSizeInBytes() >= this.dataFileSizeInBytes);
            }
            if (this.posDeleteFileCount != null) {
                predicates.add((change, unused, unused2) -> change.posDeleteFileCount() >= this.posDeleteFileCount);
            }
            if (this.posDeleteRecordCount != null) {
                predicates.add((change, unused, unused2) -> change.posDeleteRecordCount() >= this.posDeleteRecordCount);
            }
            if (this.eqDeleteFileCount != null) {
                predicates.add((change, unused, unused2) -> change.eqDeleteFileCount() >= this.eqDeleteFileCount);
            }
            if (this.eqDeleteRecordCount != null) {
                predicates.add((change, unused, unused2) -> change.eqDeleteRecordCount() >= this.eqDeleteRecordCount);
            }
            if (this.commitCount != null) {
                predicates.add((change, unused, unused2) -> change.commitCount() >= this.commitCount);
            }
            if (this.timeout != null) {
                predicates.add((change, lastTimeMs, currentTimeMs) -> currentTimeMs - lastTimeMs >= this.timeout.toMillis());
            }
            return new TriggerEvaluator(predicates);
        }
    }
}

