/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.connector.sink2.Committer;
import org.apache.flink.api.connector.sink2.CommitterInitContext;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.api.connector.sink2.SinkWriter;
import org.apache.flink.api.connector.sink2.SupportsCommitter;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.streaming.api.connector.sink2.CommittableMessage;
import org.apache.flink.streaming.api.connector.sink2.CommittableMessageTypeInfo;
import org.apache.flink.streaming.api.connector.sink2.SupportsPostCommitTopology;
import org.apache.flink.streaming.api.connector.sink2.SupportsPreCommitTopology;
import org.apache.flink.streaming.api.connector.sink2.SupportsPreWriteTopology;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.util.DataFormatConverters;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;
import org.apache.iceberg.DistributionMode;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SerializableTable;
import org.apache.iceberg.Table;
import org.apache.iceberg.flink.FlinkSchemaUtil;
import org.apache.iceberg.flink.FlinkWriteConf;
import org.apache.iceberg.flink.FlinkWriteOptions;
import org.apache.iceberg.flink.TableLoader;
import org.apache.iceberg.flink.sink.BucketPartitionKeySelector;
import org.apache.iceberg.flink.sink.BucketPartitioner;
import org.apache.iceberg.flink.sink.BucketPartitionerUtil;
import org.apache.iceberg.flink.sink.CachingTableSupplier;
import org.apache.iceberg.flink.sink.EqualityFieldKeySelector;
import org.apache.iceberg.flink.sink.IcebergCommittable;
import org.apache.iceberg.flink.sink.IcebergCommittableSerializer;
import org.apache.iceberg.flink.sink.IcebergCommitter;
import org.apache.iceberg.flink.sink.IcebergFilesCommitterMetrics;
import org.apache.iceberg.flink.sink.IcebergSinkBuilder;
import org.apache.iceberg.flink.sink.IcebergSinkWriter;
import org.apache.iceberg.flink.sink.IcebergStreamWriterMetrics;
import org.apache.iceberg.flink.sink.IcebergWriteAggregator;
import org.apache.iceberg.flink.sink.PartitionKeySelector;
import org.apache.iceberg.flink.sink.RowDataTaskWriterFactory;
import org.apache.iceberg.flink.sink.SinkUtil;
import org.apache.iceberg.flink.sink.WriteResultSerializer;
import org.apache.iceberg.flink.util.FlinkCompatibilityUtil;
import org.apache.iceberg.io.WriteResult;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.util.SerializableSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public class IcebergSink
implements Sink<RowData>,
SupportsPreWriteTopology<RowData>,
SupportsCommitter<IcebergCommittable>,
SupportsPreCommitTopology<WriteResult, IcebergCommittable>,
SupportsPostCommitTopology<IcebergCommittable> {
    private static final Logger LOG = LoggerFactory.getLogger(IcebergSink.class);
    private final TableLoader tableLoader;
    private final Map<String, String> snapshotProperties;
    private final String uidSuffix;
    private final String sinkId;
    private final Map<String, String> writeProperties;
    private final RowType flinkRowType;
    private final SerializableSupplier<Table> tableSupplier;
    private final transient FlinkWriteConf flinkWriteConf;
    private final List<Integer> equalityFieldIds;
    private final boolean upsertMode;
    private final FileFormat dataFileFormat;
    private final long targetDataFileSize;
    private final String branch;
    private final boolean overwriteMode;
    private final int workerPoolSize;
    private final Table table;
    private final List<String> equalityFieldColumns = null;

    private IcebergSink(TableLoader tableLoader, Table table, Map<String, String> snapshotProperties, String uidSuffix, Map<String, String> writeProperties, RowType flinkRowType, SerializableSupplier<Table> tableSupplier, FlinkWriteConf flinkWriteConf, List<Integer> equalityFieldIds, String branch, boolean overwriteMode) {
        this.tableLoader = tableLoader;
        this.snapshotProperties = snapshotProperties;
        this.uidSuffix = uidSuffix;
        this.writeProperties = writeProperties;
        this.flinkRowType = flinkRowType;
        this.tableSupplier = tableSupplier;
        this.flinkWriteConf = flinkWriteConf;
        this.equalityFieldIds = equalityFieldIds;
        this.branch = branch;
        this.overwriteMode = overwriteMode;
        this.table = table;
        this.upsertMode = flinkWriteConf.upsertMode();
        this.dataFileFormat = flinkWriteConf.dataFileFormat();
        this.targetDataFileSize = flinkWriteConf.targetDataFileSize();
        this.workerPoolSize = flinkWriteConf.workerPoolSize();
        this.sinkId = UUID.randomUUID().toString();
    }

    public SinkWriter<RowData> createWriter(Sink.InitContext context) {
        RowDataTaskWriterFactory taskWriterFactory = new RowDataTaskWriterFactory(this.tableSupplier, this.flinkRowType, this.targetDataFileSize, this.dataFileFormat, this.writeProperties, this.equalityFieldIds, this.upsertMode);
        IcebergStreamWriterMetrics metrics = new IcebergStreamWriterMetrics((MetricGroup)context.metricGroup(), this.table.name());
        return new IcebergSinkWriter(((Table)this.tableSupplier.get()).name(), taskWriterFactory, metrics, context.getSubtaskId(), context.getAttemptNumber());
    }

    public Committer<IcebergCommittable> createCommitter(CommitterInitContext context) {
        IcebergFilesCommitterMetrics metrics = new IcebergFilesCommitterMetrics((MetricGroup)context.metricGroup(), this.table.name());
        return new IcebergCommitter(this.tableLoader, this.branch, this.snapshotProperties, this.overwriteMode, this.workerPoolSize, this.sinkId, metrics);
    }

    public SimpleVersionedSerializer<IcebergCommittable> getCommittableSerializer() {
        return new IcebergCommittableSerializer();
    }

    public void addPostCommitTopology(DataStream<CommittableMessage<IcebergCommittable>> committables) {
    }

    public DataStream<RowData> addPreWriteTopology(DataStream<RowData> inputDataStream) {
        return this.distributeDataStream(inputDataStream);
    }

    public DataStream<CommittableMessage<IcebergCommittable>> addPreCommitTopology(DataStream<CommittableMessage<WriteResult>> writeResults) {
        TypeInformation typeInformation = CommittableMessageTypeInfo.of(this::getCommittableSerializer);
        String suffix = IcebergSink.defaultSuffix(this.uidSuffix, this.table.name());
        String preCommitAggregatorUid = String.format("Sink pre-commit aggregator: %s", suffix);
        return writeResults.global().transform(preCommitAggregatorUid, typeInformation, (OneInputStreamOperator)new IcebergWriteAggregator(this.tableLoader)).uid(preCommitAggregatorUid).setParallelism(1).setMaxParallelism(1).global();
    }

    public SimpleVersionedSerializer<WriteResult> getWriteResultSerializer() {
        return new WriteResultSerializer();
    }

    private static String defaultSuffix(String uidSuffix, String defaultSuffix) {
        if (uidSuffix == null || uidSuffix.isEmpty()) {
            return defaultSuffix;
        }
        return uidSuffix;
    }

    private static SerializableTable checkAndGetTable(TableLoader tableLoader, Table table) {
        if (table == null) {
            SerializableTable serializableTable;
            block10: {
                if (!tableLoader.isOpen()) {
                    tableLoader.open();
                }
                TableLoader loader = tableLoader;
                try {
                    serializableTable = (SerializableTable)SerializableTable.copyOf(loader.loadTable());
                    if (loader == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (loader != null) {
                            try {
                                loader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException("Failed to load iceberg table from table loader: " + tableLoader, e);
                    }
                }
                loader.close();
            }
            return serializableTable;
        }
        return (SerializableTable)SerializableTable.copyOf(table);
    }

    private static RowType toFlinkRowType(Schema schema, TableSchema requestedSchema) {
        if (requestedSchema != null) {
            Schema writeSchema = TypeUtil.reassignIds(FlinkSchemaUtil.convert(requestedSchema), schema);
            TypeUtil.validateWriteSchema(schema, writeSchema, true, true);
            return (RowType)requestedSchema.toRowDataType().getLogicalType();
        }
        return FlinkSchemaUtil.convert(schema);
    }

    private static Map<String, String> writeProperties(Table table, FileFormat format, FlinkWriteConf conf) {
        HashMap<String, String> writeProperties = Maps.newHashMap(table.properties());
        switch (format) {
            case PARQUET: {
                writeProperties.put("write.parquet.compression-codec", conf.parquetCompressionCodec());
                String parquetCompressionLevel = conf.parquetCompressionLevel();
                if (parquetCompressionLevel == null) break;
                writeProperties.put("write.parquet.compression-level", parquetCompressionLevel);
                break;
            }
            case AVRO: {
                writeProperties.put("write.avro.compression-codec", conf.avroCompressionCodec());
                String avroCompressionLevel = conf.avroCompressionLevel();
                if (avroCompressionLevel == null) break;
                writeProperties.put("write.avro.compression-level", conf.avroCompressionLevel());
                break;
            }
            case ORC: {
                writeProperties.put("write.orc.compression-codec", conf.orcCompressionCodec());
                writeProperties.put("write.orc.compression-strategy", conf.orcCompressionStrategy());
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unknown file format %s", new Object[]{format}));
            }
        }
        return writeProperties;
    }

    private DataStream<RowData> distributeDataStream(DataStream<RowData> input) {
        DistributionMode mode = this.flinkWriteConf.distributionMode();
        Schema schema = this.table.schema();
        PartitionSpec spec = this.table.spec();
        LOG.info("Write distribution mode is '{}'", (Object)mode.modeName());
        switch (mode) {
            case NONE: {
                if (this.equalityFieldIds.isEmpty()) {
                    return input;
                }
                LOG.info("Distribute rows by equality fields, because there are equality fields set");
                return input.keyBy((KeySelector)new EqualityFieldKeySelector(schema, this.flinkRowType, this.equalityFieldIds));
            }
            case HASH: {
                if (this.equalityFieldIds.isEmpty()) {
                    if (this.table.spec().isUnpartitioned()) {
                        LOG.warn("Fallback to use 'none' distribution mode, because there are no equality fields set and table is unpartitioned");
                        return input;
                    }
                    if (BucketPartitionerUtil.hasOneBucketField(spec)) {
                        return input.partitionCustom((Partitioner)new BucketPartitioner(spec), (KeySelector)new BucketPartitionKeySelector(spec, schema, this.flinkRowType));
                    }
                    return input.keyBy((KeySelector)new PartitionKeySelector(spec, schema, this.flinkRowType));
                }
                if (spec.isUnpartitioned()) {
                    LOG.info("Distribute rows by equality fields, because there are equality fields set and table is unpartitioned");
                    return input.keyBy((KeySelector)new EqualityFieldKeySelector(schema, this.flinkRowType, this.equalityFieldIds));
                }
                for (PartitionField partitionField : spec.fields()) {
                    Preconditions.checkState((boolean)this.equalityFieldIds.contains(partitionField.sourceId()), (String)"In 'hash' distribution mode with equality fields set, partition field '%s' should be included in equality fields: '%s'", (Object[])new Object[]{partitionField, this.equalityFieldColumns});
                }
                return input.keyBy((KeySelector)new PartitionKeySelector(spec, schema, this.flinkRowType));
            }
            case RANGE: {
                if (this.equalityFieldIds.isEmpty()) {
                    LOG.warn("Fallback to use 'none' distribution mode, because there are no equality fields set and {}=range is not supported yet in flink", (Object)"write.distribution-mode");
                    return input;
                }
                LOG.info("Distribute rows by equality fields, because there are equality fields set and{}=range is not supported yet in flink", (Object)"write.distribution-mode");
                return input.keyBy((KeySelector)new EqualityFieldKeySelector(schema, this.flinkRowType, this.equalityFieldIds));
            }
        }
        throw new RuntimeException("Unrecognized write.distribution-mode: " + mode);
    }

    public static <T> Builder builderFor(DataStream<T> input, MapFunction<T, RowData> mapper, TypeInformation<RowData> outputType) {
        return new Builder().forMapperOutputType(input, mapper, outputType);
    }

    public static Builder forRow(DataStream<Row> input, TableSchema tableSchema) {
        return new Builder().forRow(input, tableSchema);
    }

    public static Builder forRowData(DataStream<RowData> input) {
        return new Builder().forRowData(input);
    }

    public static class Builder
    implements IcebergSinkBuilder<Builder> {
        private TableLoader tableLoader;
        private String uidSuffix = "";
        private Function<String, DataStream<RowData>> inputCreator = null;
        private TableSchema tableSchema;
        private SerializableTable table;
        private final Map<String, String> writeOptions = Maps.newHashMap();
        private final Map<String, String> snapshotSummary = Maps.newHashMap();
        private ReadableConfig readableConfig = new Configuration();
        private List<String> equalityFieldColumns = null;

        private Builder() {
        }

        private Builder forRowData(DataStream<RowData> newRowDataInput) {
            this.inputCreator = ignored -> newRowDataInput;
            return this;
        }

        private Builder forRow(DataStream<Row> input, TableSchema inputTableSchema) {
            RowType rowType = (RowType)inputTableSchema.toRowDataType().getLogicalType();
            DataType[] fieldDataTypes = inputTableSchema.getFieldDataTypes();
            DataFormatConverters.RowConverter rowConverter = new DataFormatConverters.RowConverter(fieldDataTypes);
            return this.forMapperOutputType(input, arg_0 -> ((DataFormatConverters.RowConverter)rowConverter).toInternal(arg_0), FlinkCompatibilityUtil.toTypeInfo(rowType)).tableSchema(inputTableSchema);
        }

        private <T> Builder forMapperOutputType(DataStream<T> input, MapFunction<T, RowData> mapper, TypeInformation<RowData> outputType) {
            this.inputCreator = newUidSuffix -> {
                SingleOutputStreamOperator inputStream = input.map(mapper, outputType).setParallelism(input.getParallelism());
                if (newUidSuffix != null) {
                    String uid = String.format("Sink pre-writer mapper: %s", newUidSuffix);
                    inputStream.name(uid).uid(uid);
                }
                return inputStream;
            };
            return this;
        }

        @Override
        public Builder table(Table newTable) {
            this.table = (SerializableTable)SerializableTable.copyOf(newTable);
            return this;
        }

        @Override
        public Builder tableLoader(TableLoader newTableLoader) {
            this.tableLoader = newTableLoader;
            return this;
        }

        TableLoader tableLoader() {
            return this.tableLoader;
        }

        public Builder set(String property, String value) {
            this.writeOptions.put(property, value);
            return this;
        }

        @Override
        public Builder setAll(Map<String, String> properties) {
            this.writeOptions.putAll(properties);
            return this;
        }

        @Override
        public Builder tableSchema(TableSchema newTableSchema) {
            this.tableSchema = newTableSchema;
            return this;
        }

        @Override
        public Builder overwrite(boolean newOverwrite) {
            this.writeOptions.put(FlinkWriteOptions.OVERWRITE_MODE.key(), Boolean.toString(newOverwrite));
            return this;
        }

        @Override
        public Builder flinkConf(ReadableConfig config) {
            this.readableConfig = config;
            return this;
        }

        @Override
        public Builder distributionMode(DistributionMode mode) {
            Preconditions.checkArgument((!DistributionMode.RANGE.equals((Object)mode) ? 1 : 0) != 0, (Object)"Flink does not support 'range' write distribution mode now.");
            if (mode != null) {
                this.writeOptions.put(FlinkWriteOptions.DISTRIBUTION_MODE.key(), mode.modeName());
            }
            return this;
        }

        @Override
        public Builder writeParallelism(int newWriteParallelism) {
            this.writeOptions.put(FlinkWriteOptions.WRITE_PARALLELISM.key(), Integer.toString(newWriteParallelism));
            return this;
        }

        @Override
        public Builder upsert(boolean enabled) {
            this.writeOptions.put(FlinkWriteOptions.WRITE_UPSERT_ENABLED.key(), Boolean.toString(enabled));
            return this;
        }

        @Override
        public Builder equalityFieldColumns(List<String> columns) {
            this.equalityFieldColumns = columns;
            return this;
        }

        public Builder uidSuffix(String newSuffix) {
            this.uidSuffix = newSuffix;
            return this;
        }

        public Builder snapshotProperties(Map<String, String> properties) {
            this.snapshotSummary.putAll(properties);
            return this;
        }

        public Builder setSnapshotProperty(String property, String value) {
            this.snapshotSummary.put(property, value);
            return this;
        }

        @Override
        public Builder toBranch(String branch) {
            this.writeOptions.put(FlinkWriteOptions.BRANCH.key(), branch);
            return this;
        }

        IcebergSink build() {
            SerializableTable serializableTable;
            Preconditions.checkArgument((this.inputCreator != null ? 1 : 0) != 0, (Object)"Please use forRowData() or forMapperOutputType() to initialize the input DataStream.");
            Preconditions.checkNotNull((Object)this.tableLoader(), (String)"Table loader shouldn't be null");
            this.table = serializableTable = IcebergSink.checkAndGetTable(this.tableLoader(), this.table);
            FlinkWriteConf flinkWriteConf = new FlinkWriteConf(this.table, this.writeOptions, this.readableConfig);
            Duration tableRefreshInterval = flinkWriteConf.tableRefreshInterval();
            SerializableSupplier<Table> tableSupplier = tableRefreshInterval != null ? new CachingTableSupplier(this.table, this.tableLoader(), tableRefreshInterval) : () -> serializableTable;
            boolean overwriteMode = flinkWriteConf.overwriteMode();
            List<Integer> equalityFieldIds = SinkUtil.checkAndGetEqualityFieldIds(this.table, this.equalityFieldColumns);
            if (flinkWriteConf.upsertMode()) {
                Preconditions.checkState((!overwriteMode ? 1 : 0) != 0, (Object)"OVERWRITE mode shouldn't be enable when configuring to use UPSERT data stream.");
                Preconditions.checkState((!equalityFieldIds.isEmpty() ? 1 : 0) != 0, (Object)"Equality field columns shouldn't be empty when configuring to use UPSERT data stream.");
                if (!this.table.spec().isUnpartitioned()) {
                    for (PartitionField partitionField : this.table.spec().fields()) {
                        Preconditions.checkState((boolean)equalityFieldIds.contains(partitionField.sourceId()), (String)"In UPSERT mode, partition field '%s' should be included in equality fields: '%s'", (Object[])new Object[]{partitionField, this.equalityFieldColumns});
                    }
                }
            }
            return new IcebergSink(this.tableLoader, this.table, this.snapshotSummary, this.uidSuffix, IcebergSink.writeProperties(this.table, flinkWriteConf.dataFileFormat(), flinkWriteConf), IcebergSink.toFlinkRowType(this.table.schema(), this.tableSchema), tableSupplier, flinkWriteConf, equalityFieldIds, flinkWriteConf.branch(), overwriteMode);
        }

        @Override
        public DataStreamSink<RowData> append() {
            IcebergSink sink = this.build();
            String suffix = IcebergSink.defaultSuffix(this.uidSuffix, this.table.name());
            DataStream<RowData> rowDataInput = this.inputCreator.apply(suffix);
            DataStreamSink rowDataDataStreamSink = rowDataInput.sinkTo((Sink)sink).uid(suffix).name(suffix);
            if (sink.flinkWriteConf.writeParallelism() != null) {
                rowDataDataStreamSink.setParallelism(sink.flinkWriteConf.writeParallelism().intValue());
            }
            return rowDataDataStreamSink;
        }
    }
}

