/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.flink.util.Preconditions;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Types;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SinkUtil {
    private static final long INITIAL_CHECKPOINT_ID = -1L;
    public static final String FLINK_JOB_ID = "flink.job-id";
    public static final String OPERATOR_ID = "flink.operator-id";
    public static final String MAX_COMMITTED_CHECKPOINT_ID = "flink.max-committed-checkpoint-id";
    private static final Logger LOG = LoggerFactory.getLogger(SinkUtil.class);

    private SinkUtil() {
    }

    static List<Integer> checkAndGetEqualityFieldIds(Table table, List<String> equalityFieldColumns) {
        ArrayList<Integer> equalityFieldIds = Lists.newArrayList(table.schema().identifierFieldIds());
        if (equalityFieldColumns != null && !equalityFieldColumns.isEmpty()) {
            HashSet<Integer> equalityFieldSet = Sets.newHashSetWithExpectedSize(equalityFieldColumns.size());
            for (String column : equalityFieldColumns) {
                Types.NestedField field = table.schema().findField(column);
                Preconditions.checkNotNull((Object)field, (String)"Missing required equality field column '%s' in table schema %s", (Object[])new Object[]{column, table.schema()});
                equalityFieldSet.add(field.fieldId());
            }
            if (!equalityFieldSet.equals(table.schema().identifierFieldIds())) {
                LOG.warn("The configured equality field column IDs {} are not matched with the schema identifier field IDs {}, use job specified equality field columns as the equality fields by default.", equalityFieldSet, table.schema().identifierFieldIds());
            }
            equalityFieldIds = Lists.newArrayList(equalityFieldSet);
        }
        return equalityFieldIds;
    }

    static long getMaxCommittedCheckpointId(Table table, String flinkJobId, String operatorId, String branch) {
        Snapshot snapshot = table.snapshot(branch);
        long lastCommittedCheckpointId = -1L;
        while (snapshot != null) {
            String value;
            Map<String, String> summary = snapshot.summary();
            String snapshotFlinkJobId = summary.get(FLINK_JOB_ID);
            String snapshotOperatorId = summary.get(OPERATOR_ID);
            if (flinkJobId.equals(snapshotFlinkJobId) && (snapshotOperatorId == null || snapshotOperatorId.equals(operatorId)) && (value = summary.get(MAX_COMMITTED_CHECKPOINT_ID)) != null) {
                lastCommittedCheckpointId = Long.parseLong(value);
                break;
            }
            Long parentSnapshotId = snapshot.parentId();
            snapshot = parentSnapshotId != null ? table.snapshot(parentSnapshotId) : null;
        }
        return lastCommittedCheckpointId;
    }
}

