/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.util.InstantiationUtil;
import org.apache.iceberg.flink.sink.IcebergCommittableSerializer;
import org.apache.iceberg.io.WriteResult;

class WriteResultSerializer
implements SimpleVersionedSerializer<WriteResult> {
    private static final int VERSION = 1;

    WriteResultSerializer() {
    }

    public int getVersion() {
        return 1;
    }

    public byte[] serialize(WriteResult writeResult) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputViewStreamWrapper view = new DataOutputViewStreamWrapper((OutputStream)out);
        byte[] result = InstantiationUtil.serializeObject((Object)writeResult);
        view.write(result);
        return out.toByteArray();
    }

    public WriteResult deserialize(int version, byte[] serialized) throws IOException {
        if (version == 1) {
            DataInputDeserializer view = new DataInputDeserializer(serialized);
            byte[] resultBuf = new byte[serialized.length];
            view.read(resultBuf);
            try {
                return (WriteResult)InstantiationUtil.deserializeObject((byte[])resultBuf, (ClassLoader)IcebergCommittableSerializer.class.getClassLoader());
            }
            catch (ClassNotFoundException cnc) {
                throw new IOException("Could not deserialize the WriteResult object", cnc);
            }
        }
        throw new IOException("Unrecognized version or corrupt state: " + version);
    }
}

