/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink.shuffle;

import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.table.data.RowData;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortKey;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.flink.FlinkSchemaUtil;
import org.apache.iceberg.flink.RowDataWrapper;
import org.apache.iceberg.flink.sink.shuffle.KeyAssignment;
import org.apache.iceberg.flink.sink.shuffle.MapAssignment;
import org.apache.iceberg.flink.sink.shuffle.RangePartitioner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MapRangePartitioner
implements Partitioner<RowData> {
    private static final Logger LOG = LoggerFactory.getLogger(MapRangePartitioner.class);
    private final RowDataWrapper rowDataWrapper;
    private final SortKey sortKey;
    private final MapAssignment mapAssignment;
    private long newSortKeyCounter;
    private long lastNewSortKeyLogTimeMilli;

    MapRangePartitioner(Schema schema, SortOrder sortOrder, MapAssignment mapAssignment) {
        this.rowDataWrapper = new RowDataWrapper(FlinkSchemaUtil.convert(schema), schema.asStruct());
        this.sortKey = new SortKey(schema, sortOrder);
        this.mapAssignment = mapAssignment;
        this.newSortKeyCounter = 0L;
        this.lastNewSortKeyLogTimeMilli = System.currentTimeMillis();
    }

    public int partition(RowData row, int numPartitions) {
        int partition;
        this.sortKey.wrap(this.rowDataWrapper.wrap(row));
        KeyAssignment keyAssignment = this.mapAssignment.keyAssignments().get(this.sortKey);
        if (keyAssignment == null) {
            LOG.trace("Encountered new sort key: {}. Fall back to round robin as statistics not learned yet.", (Object)this.sortKey);
            ++this.newSortKeyCounter;
            long now = System.currentTimeMillis();
            if (now - this.lastNewSortKeyLogTimeMilli > TimeUnit.MINUTES.toMillis(1L)) {
                LOG.info("Encounter new sort keys {} times. Fall back to round robin as statistics not learned yet", (Object)this.newSortKeyCounter);
                this.lastNewSortKeyLogTimeMilli = now;
                this.newSortKeyCounter = 0L;
            }
            partition = (int)(this.newSortKeyCounter % (long)numPartitions);
        } else {
            partition = keyAssignment.select();
        }
        return RangePartitioner.adjustPartitionWithRescale(partition, this.mapAssignment.numPartitions(), numPartitions);
    }
}

