/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink.shuffle;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.iceberg.SortKey;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.flink.sink.shuffle.RangePartitioner;

class SketchUtil {
    static final int COORDINATOR_MIN_RESERVOIR_SIZE = 10000;
    static final int COORDINATOR_MAX_RESERVOIR_SIZE = 1000000;
    static final int COORDINATOR_TARGET_PARTITIONS_MULTIPLIER = 100;
    static final int OPERATOR_OVER_SAMPLE_RATIO = 10;
    static final int OPERATOR_SKETCH_SWITCH_THRESHOLD = 10000;
    static final int COORDINATOR_SKETCH_SWITCH_THRESHOLD = 100000;

    private SketchUtil() {
    }

    static int determineCoordinatorReservoirSize(int numPartitions) {
        int reservoirSize = numPartitions * 100;
        if (reservoirSize < 10000) {
            int remainder = 10000 % numPartitions;
            reservoirSize = 10000 + (numPartitions - remainder);
        } else if (reservoirSize > 1000000) {
            int remainder = 1000000 % numPartitions;
            reservoirSize = 1000000 - remainder;
        }
        return reservoirSize;
    }

    static int determineOperatorReservoirSize(int operatorParallelism, int numPartitions) {
        int coordinatorReservoirSize = SketchUtil.determineCoordinatorReservoirSize(numPartitions);
        int totalOperatorSamples = coordinatorReservoirSize * 10;
        return (int)Math.ceil((double)totalOperatorSamples / (double)operatorParallelism);
    }

    static SortKey[] rangeBounds(int numPartitions, Comparator<StructLike> comparator, SortKey[] samples) {
        Arrays.sort(samples, comparator);
        int numCandidates = numPartitions - 1;
        SortKey[] candidates = new SortKey[numCandidates];
        int step = (int)Math.ceil((double)samples.length / (double)numPartitions);
        int position = step - 1;
        int numChosen = 0;
        while (position < samples.length && numChosen < numCandidates) {
            SortKey candidate = samples[position];
            if (numChosen > 0 && candidate.equals(candidates[numChosen - 1])) {
                ++position;
                continue;
            }
            candidates[numChosen] = candidate;
            position += step;
            ++numChosen;
        }
        return candidates;
    }

    static void convertMapToSketch(Map<SortKey, Long> taskMapStats, Consumer<SortKey> sketchConsumer) {
        taskMapStats.forEach((sortKey, count) -> {
            int i = 0;
            while ((long)i < count) {
                sketchConsumer.accept((SortKey)sortKey);
                ++i;
            }
        });
    }

    static int partition(SortKey key, int numPartitions, SortKey[] rangeBounds, Comparator<StructLike> comparator) {
        int partition = Arrays.binarySearch(rangeBounds, key, comparator);
        if (partition < 0) {
            partition = -partition - 1;
        }
        if (partition > rangeBounds.length) {
            partition = rangeBounds.length;
        }
        return RangePartitioner.adjustPartitionWithRescale(partition, rangeBounds.length + 1, numPartitions);
    }
}

