/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.RowType;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SerializableTable;
import org.apache.iceberg.Table;
import org.apache.iceberg.encryption.EncryptionManager;
import org.apache.iceberg.flink.FlinkSchemaUtil;
import org.apache.iceberg.flink.sink.RowDataTaskWriterFactory;
import org.apache.iceberg.flink.sink.TaskWriterFactory;
import org.apache.iceberg.flink.source.DataIterator;
import org.apache.iceberg.flink.source.RowDataFileScanTaskReader;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.TaskWriter;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.util.PropertyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowDataRewriter {
    private static final Logger LOG = LoggerFactory.getLogger(RowDataRewriter.class);
    private final Schema schema;
    private final String nameMapping;
    private final FileIO io;
    private final boolean caseSensitive;
    private final EncryptionManager encryptionManager;
    private final TaskWriterFactory<RowData> taskWriterFactory;
    private final String tableName;

    public RowDataRewriter(Table table, boolean caseSensitive, FileIO io, EncryptionManager encryptionManager) {
        this.schema = table.schema();
        this.caseSensitive = caseSensitive;
        this.io = io;
        this.encryptionManager = encryptionManager;
        this.nameMapping = PropertyUtil.propertyAsString(table.properties(), "schema.name-mapping.default", null);
        this.tableName = table.name();
        String formatString = PropertyUtil.propertyAsString(table.properties(), "write.format.default", "parquet");
        FileFormat format = FileFormat.fromString(formatString);
        RowType flinkSchema = FlinkSchemaUtil.convert(table.schema());
        this.taskWriterFactory = new RowDataTaskWriterFactory(SerializableTable.copyOf(table), flinkSchema, Long.MAX_VALUE, format, table.properties(), null, false);
    }

    public List<DataFile> rewriteDataForTasks(DataStream<CombinedScanTask> dataStream, int parallelism) throws Exception {
        RewriteMap map = new RewriteMap(this.schema, this.nameMapping, this.io, this.caseSensitive, this.encryptionManager, this.taskWriterFactory);
        SingleOutputStreamOperator ds = dataStream.map((MapFunction)map).setParallelism(parallelism);
        return Lists.newArrayList(ds.executeAndCollect("Rewrite table :" + this.tableName)).stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static class RewriteMap
    extends RichMapFunction<CombinedScanTask, List<DataFile>> {
        private TaskWriter<RowData> writer;
        private int subTaskId;
        private int attemptId;
        private final FileIO io;
        private final EncryptionManager encryptionManager;
        private final TaskWriterFactory<RowData> taskWriterFactory;
        private final RowDataFileScanTaskReader rowDataReader;

        public RewriteMap(Schema schema, String nameMapping, FileIO io, boolean caseSensitive, EncryptionManager encryptionManager, TaskWriterFactory<RowData> taskWriterFactory) {
            this.io = io;
            this.encryptionManager = encryptionManager;
            this.taskWriterFactory = taskWriterFactory;
            this.rowDataReader = new RowDataFileScanTaskReader(schema, schema, nameMapping, caseSensitive, Collections.emptyList());
        }

        public void open(Configuration parameters) {
            this.subTaskId = this.getRuntimeContext().getIndexOfThisSubtask();
            this.attemptId = this.getRuntimeContext().getAttemptNumber();
            this.taskWriterFactory.initialize(this.subTaskId, this.attemptId);
        }

        public List<DataFile> map(CombinedScanTask task) throws Exception {
            this.writer = this.taskWriterFactory.create();
            DataIterator<RowData> iterator = new DataIterator<RowData>(this.rowDataReader, task, this.io, this.encryptionManager);
            try {
                Object rowData;
                while (iterator.hasNext()) {
                    rowData = iterator.next();
                    this.writer.write((RowData)rowData);
                }
                rowData = Lists.newArrayList(this.writer.dataFiles());
            }
            catch (Throwable rowData) {
                try {
                    try {
                        iterator.close();
                    }
                    catch (Throwable throwable) {
                        rowData.addSuppressed(throwable);
                    }
                    throw rowData;
                }
                catch (Throwable originalThrowable) {
                    block11: {
                        try {
                            LOG.error("Aborting commit for  (subTaskId {}, attemptId {})", (Object)this.subTaskId, (Object)this.attemptId);
                            this.writer.abort();
                            LOG.error("Aborted commit for  (subTaskId {}, attemptId {})", (Object)this.subTaskId, (Object)this.attemptId);
                        }
                        catch (Throwable inner) {
                            if (originalThrowable == inner) break block11;
                            originalThrowable.addSuppressed(inner);
                            LOG.warn("Suppressing exception in catch: {}", (Object)inner.getMessage(), (Object)inner);
                        }
                    }
                    if (originalThrowable instanceof Exception) {
                        throw originalThrowable;
                    }
                    throw new RuntimeException(originalThrowable);
                }
            }
            iterator.close();
            return rowData;
        }
    }
}

