/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source.reader;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.formats.avro.RowDataToAvroConverters;
import org.apache.flink.formats.avro.typeutils.AvroSchemaConverter;
import org.apache.flink.formats.avro.typeutils.GenericRecordAvroTypeInfo;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.flink.FlinkSchemaUtil;
import org.apache.iceberg.flink.source.reader.RowDataConverter;
import org.apache.iceberg.shaded.org.apache.avro.generic.GenericRecord;

public class AvroGenericRecordConverter
implements RowDataConverter<GenericRecord> {
    private final org.apache.iceberg.shaded.org.apache.avro.Schema avroSchema;
    private final RowDataToAvroConverters.RowDataToAvroConverter flinkConverter;
    private final TypeInformation<GenericRecord> outputTypeInfo;

    private AvroGenericRecordConverter(org.apache.iceberg.shaded.org.apache.avro.Schema avroSchema, RowType rowType) {
        this.avroSchema = avroSchema;
        this.flinkConverter = RowDataToAvroConverters.createConverter((LogicalType)rowType);
        this.outputTypeInfo = new GenericRecordAvroTypeInfo(avroSchema);
    }

    public static AvroGenericRecordConverter fromIcebergSchema(Schema icebergSchema, String tableName) {
        RowType rowType = FlinkSchemaUtil.convert(icebergSchema);
        org.apache.iceberg.shaded.org.apache.avro.Schema avroSchema = AvroSchemaUtil.convert(icebergSchema, tableName);
        return new AvroGenericRecordConverter(avroSchema, rowType);
    }

    public static AvroGenericRecordConverter fromAvroSchema(org.apache.iceberg.shaded.org.apache.avro.Schema avroSchema, String tableName) {
        DataType dataType = AvroSchemaConverter.convertToDataType((String)avroSchema.toString());
        LogicalType logicalType = TypeConversions.fromDataToLogicalType((DataType)dataType);
        RowType rowType = RowType.of((LogicalType[])logicalType.getChildren().toArray(new LogicalType[0]));
        return new AvroGenericRecordConverter(avroSchema, rowType);
    }

    @Override
    public GenericRecord apply(RowData rowData) {
        return (GenericRecord)this.flinkConverter.convert(this.avroSchema, (Object)rowData);
    }

    public TypeInformation<GenericRecord> getProducedType() {
        return this.outputTypeInfo;
    }
}

