/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source.reader;

import org.apache.flink.connector.base.source.reader.RecordsWithSplitIds;
import org.apache.iceberg.flink.source.DataIterator;
import org.apache.iceberg.flink.source.reader.DataIteratorBatcher;
import org.apache.iceberg.flink.source.reader.ReaderFunction;
import org.apache.iceberg.flink.source.reader.RecordAndPosition;
import org.apache.iceberg.flink.source.split.IcebergSourceSplit;
import org.apache.iceberg.io.CloseableIterator;

public abstract class DataIteratorReaderFunction<T>
implements ReaderFunction<T> {
    private final DataIteratorBatcher<T> batcher;

    public DataIteratorReaderFunction(DataIteratorBatcher<T> batcher) {
        this.batcher = batcher;
    }

    protected abstract DataIterator<T> createDataIterator(IcebergSourceSplit var1);

    @Override
    public CloseableIterator<RecordsWithSplitIds<RecordAndPosition<T>>> apply(IcebergSourceSplit split) {
        DataIterator<T> inputIterator = this.createDataIterator(split);
        inputIterator.seek(split.fileOffset(), split.recordOffset());
        return this.batcher.batch(split.splitId(), inputIterator);
    }
}

