/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.io;

import java.io.Closeable;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.shaded.com.github.benmanes.caffeine.cache.Cache;
import org.apache.iceberg.shaded.com.github.benmanes.caffeine.cache.Caffeine;

public class FileIOTracker
implements Closeable {
    private final Cache<TableOperations, FileIO> tracker = Caffeine.newBuilder().weakKeys().removalListener((ops, fileIO, cause) -> {
        if (null != fileIO) {
            fileIO.close();
        }
    }).build();

    public void track(TableOperations ops) {
        Preconditions.checkArgument(null != ops, "Invalid table ops: null");
        this.tracker.put(ops, ops.io());
    }

    @VisibleForTesting
    Cache<TableOperations, FileIO> tracker() {
        return this.tracker;
    }

    @Override
    public void close() {
        this.tracker.invalidateAll();
        this.tracker.cleanUp();
    }
}

