/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.puffin;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.iceberg.puffin.PuffinCompressionCodec;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.shaded.io.airlift.compress.Compressor;
import org.apache.iceberg.shaded.io.airlift.compress.zstd.ZstdCompressor;
import org.apache.iceberg.shaded.io.airlift.compress.zstd.ZstdDecompressor;
import org.apache.iceberg.util.ByteBuffers;
import org.apache.iceberg.util.Pair;

final class PuffinFormat {
    static final int FOOTER_START_MAGIC_OFFSET = 0;
    static final int FOOTER_START_MAGIC_LENGTH = PuffinFormat.getMagic().length;
    static final int FOOTER_STRUCT_PAYLOAD_SIZE_OFFSET = 0;
    static final int FOOTER_STRUCT_FLAGS_OFFSET = 4;
    static final int FOOTER_STRUCT_FLAGS_LENGTH = 4;
    static final int FOOTER_STRUCT_MAGIC_OFFSET = 8;
    static final int FOOTER_STRUCT_LENGTH = 8 + PuffinFormat.getMagic().length;
    static final PuffinCompressionCodec FOOTER_COMPRESSION_CODEC = PuffinCompressionCodec.LZ4;

    private PuffinFormat() {
    }

    static byte[] getMagic() {
        return new byte[]{80, 70, 65, 49};
    }

    static void writeIntegerLittleEndian(OutputStream outputStream, int value) throws IOException {
        outputStream.write(0xFF & value);
        outputStream.write(0xFF & value >> 8);
        outputStream.write(0xFF & value >> 16);
        outputStream.write(0xFF & value >> 24);
    }

    static int readIntegerLittleEndian(byte[] data, int offset) {
        return Byte.toUnsignedInt(data[offset]) | Byte.toUnsignedInt(data[offset + 1]) << 8 | Byte.toUnsignedInt(data[offset + 2]) << 16 | Byte.toUnsignedInt(data[offset + 3]) << 24;
    }

    static ByteBuffer compress(PuffinCompressionCodec codec, ByteBuffer input) {
        switch (codec) {
            case NONE: {
                return input.duplicate();
            }
            case LZ4: {
                break;
            }
            case ZSTD: {
                return PuffinFormat.compress(new ZstdCompressor(), input);
            }
        }
        throw new UnsupportedOperationException("Unsupported codec: " + codec);
    }

    private static ByteBuffer compress(Compressor compressor, ByteBuffer input) {
        ByteBuffer output = ByteBuffer.allocate(compressor.maxCompressedLength(input.remaining()));
        compressor.compress(input.duplicate(), output);
        output.flip();
        return output;
    }

    static ByteBuffer decompress(PuffinCompressionCodec codec, ByteBuffer input) {
        switch (codec) {
            case NONE: {
                return input.duplicate();
            }
            case LZ4: {
                break;
            }
            case ZSTD: {
                return PuffinFormat.decompressZstd(input);
            }
        }
        throw new UnsupportedOperationException("Unsupported codec: " + codec);
    }

    private static ByteBuffer decompressZstd(ByteBuffer input) {
        int inputLength;
        int inputOffset;
        byte[] inputBytes;
        if (input.hasArray()) {
            inputBytes = input.array();
            inputOffset = input.arrayOffset();
            inputLength = input.remaining();
        } else {
            inputBytes = ByteBuffers.toByteArray(input);
            inputOffset = 0;
            inputLength = inputBytes.length;
        }
        byte[] decompressed = new byte[Math.toIntExact(ZstdDecompressor.getDecompressedSize(inputBytes, inputOffset, inputLength))];
        int decompressedLength = new ZstdDecompressor().decompress(inputBytes, inputOffset, inputLength, decompressed, 0, decompressed.length);
        Preconditions.checkState(decompressedLength == decompressed.length, "Invalid decompressed length");
        return ByteBuffer.wrap(decompressed);
    }

    static enum Flag {
        FOOTER_PAYLOAD_COMPRESSED(0, 0);

        private static final Map<Pair<Integer, Integer>, Flag> BY_BYTE_AND_BIT;
        private final int byteNumber;
        private final int bitNumber;

        private Flag(int byteNumber, int bitNumber) {
            Preconditions.checkArgument(0 <= byteNumber && byteNumber < 4, "Invalid byteNumber");
            Preconditions.checkArgument(0 <= bitNumber && bitNumber < 8, "Invalid bitNumber");
            this.byteNumber = byteNumber;
            this.bitNumber = bitNumber;
        }

        @Nullable
        static Flag fromBit(int byteNumber, int bitNumber) {
            return BY_BYTE_AND_BIT.get(Pair.of(byteNumber, bitNumber));
        }

        public int byteNumber() {
            return this.byteNumber;
        }

        public int bitNumber() {
            return this.bitNumber;
        }

        static {
            BY_BYTE_AND_BIT = Stream.of(Flag.values()).collect(ImmutableMap.toImmutableMap(flag -> Pair.of(flag.byteNumber(), flag.bitNumber()), Function.identity()));
        }
    }
}

