/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.schema;

import java.util.List;
import java.util.stream.IntStream;
import org.apache.iceberg.Schema;
import org.apache.iceberg.UpdateSchema;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.schema.SchemaWithPartnerVisitor;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;

public class UnionByNameVisitor
extends SchemaWithPartnerVisitor<Integer, Boolean> {
    private final UpdateSchema api;
    private final Schema partnerSchema;
    private final boolean caseSensitive;

    private UnionByNameVisitor(UpdateSchema api, Schema partnerSchema, boolean caseSensitive) {
        this.api = api;
        this.partnerSchema = partnerSchema;
        this.caseSensitive = caseSensitive;
    }

    public static void visit(UpdateSchema api, Schema existingSchema, Schema newSchema) {
        UnionByNameVisitor.visit(api, existingSchema, newSchema, true);
    }

    public static void visit(UpdateSchema api, Schema existingSchema, Schema newSchema, boolean caseSensitive) {
        UnionByNameVisitor.visit(newSchema, Integer.valueOf(-1), new UnionByNameVisitor(api, existingSchema, caseSensitive), new PartnerIdByNameAccessors(existingSchema, caseSensitive));
    }

    @Override
    public Boolean struct(Types.StructType struct, Integer partnerId, List<Boolean> missingPositions) {
        if (partnerId == null) {
            return true;
        }
        List<Types.NestedField> fields = struct.fields();
        Types.StructType partnerStruct = this.findFieldType(partnerId).asStructType();
        IntStream.range(0, missingPositions.size()).forEach(pos -> {
            Boolean isMissing = (Boolean)missingPositions.get(pos);
            Types.NestedField field = (Types.NestedField)fields.get(pos);
            if (isMissing.booleanValue()) {
                this.addColumn(partnerId, field);
            } else {
                Types.NestedField nestedField = this.caseSensitive ? partnerStruct.field(field.name()) : partnerStruct.caseInsensitiveField(field.name());
                this.updateColumn(field, nestedField);
            }
        });
        return false;
    }

    @Override
    public Boolean field(Types.NestedField field, Integer partnerId, Boolean isFieldMissing) {
        return partnerId == null;
    }

    @Override
    public Boolean list(Types.ListType list, Integer partnerId, Boolean isElementMissing) {
        if (partnerId == null) {
            return true;
        }
        Preconditions.checkState(isElementMissing == false, "Error traversing schemas: element is missing, but list is present");
        Types.ListType partnerList = this.findFieldType(partnerId).asListType();
        this.updateColumn(list.fields().get(0), partnerList.fields().get(0));
        return false;
    }

    @Override
    public Boolean map(Types.MapType map, Integer partnerId, Boolean isKeyMissing, Boolean isValueMissing) {
        if (partnerId == null) {
            return true;
        }
        Preconditions.checkState(isKeyMissing == false, "Error traversing schemas: key is missing, but map is present");
        Preconditions.checkState(isValueMissing == false, "Error traversing schemas: value is missing, but map is present");
        Types.MapType partnerMap = this.findFieldType(partnerId).asMapType();
        this.updateColumn(map.fields().get(0), partnerMap.fields().get(0));
        this.updateColumn(map.fields().get(1), partnerMap.fields().get(1));
        return false;
    }

    @Override
    public Boolean primitive(Type.PrimitiveType primitive, Integer partnerId) {
        return partnerId == null;
    }

    private Type findFieldType(int fieldId) {
        if (fieldId == -1) {
            return this.partnerSchema.asStruct();
        }
        return this.partnerSchema.findField(fieldId).type();
    }

    private void addColumn(int parentId, Types.NestedField field) {
        String parentName = this.partnerSchema.findColumnName(parentId);
        this.api.addColumn(parentName, field.name(), field.type(), field.doc());
    }

    private void updateColumn(Types.NestedField field, Types.NestedField existingField) {
        boolean needsDocUpdate;
        String fullName = this.partnerSchema.findColumnName(existingField.fieldId());
        boolean needsOptionalUpdate = field.isOptional() && existingField.isRequired();
        boolean needsTypeUpdate = !this.isIgnorableTypeUpdate(existingField.type(), field.type());
        boolean bl = needsDocUpdate = field.doc() != null && !field.doc().equals(existingField.doc());
        if (needsOptionalUpdate) {
            this.api.makeColumnOptional(fullName);
        }
        if (needsTypeUpdate) {
            this.api.updateColumn(fullName, field.type().asPrimitiveType());
        }
        if (needsDocUpdate) {
            this.api.updateColumnDoc(fullName, field.doc());
        }
    }

    private boolean isIgnorableTypeUpdate(Type existingType, Type newType) {
        if (existingType.isPrimitiveType()) {
            return newType.isPrimitiveType() && TypeUtil.isPromotionAllowed(newType, existingType.asPrimitiveType());
        }
        return !newType.isPrimitiveType();
    }

    private static class PartnerIdByNameAccessors
    implements SchemaWithPartnerVisitor.PartnerAccessors<Integer> {
        private final Schema partnerSchema;
        private boolean caseSensitive = true;

        private PartnerIdByNameAccessors(Schema partnerSchema) {
            this.partnerSchema = partnerSchema;
        }

        private PartnerIdByNameAccessors(Schema partnerSchema, boolean caseSensitive) {
            this(partnerSchema);
            this.caseSensitive = caseSensitive;
        }

        @Override
        public Integer fieldPartner(Integer partnerFieldId, int fieldId, String name) {
            Types.NestedField field;
            Types.StructType struct = partnerFieldId == -1 ? this.partnerSchema.asStruct() : this.partnerSchema.findField(partnerFieldId).type().asStructType();
            Types.NestedField nestedField = field = this.caseSensitive ? struct.field(name) : struct.caseInsensitiveField(name);
            if (field != null) {
                return field.fieldId();
            }
            return null;
        }

        @Override
        public Integer mapKeyPartner(Integer partnerMapId) {
            Types.NestedField mapField = this.partnerSchema.findField(partnerMapId);
            if (mapField != null) {
                return mapField.type().asMapType().fields().get(0).fieldId();
            }
            return null;
        }

        @Override
        public Integer mapValuePartner(Integer partnerMapId) {
            Types.NestedField mapField = this.partnerSchema.findField(partnerMapId);
            if (mapField != null) {
                return mapField.type().asMapType().fields().get(1).fieldId();
            }
            return null;
        }

        @Override
        public Integer listElementPartner(Integer partnerListId) {
            Types.NestedField listField = this.partnerSchema.findField(partnerListId);
            if (listField != null) {
                return listField.type().asListType().fields().get(0).fieldId();
            }
            return null;
        }
    }
}

