/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.org.apache.avro.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.apache.iceberg.shaded.org.apache.avro.AvroTypeException;
import org.apache.iceberg.shaded.org.apache.avro.Schema;
import org.apache.iceberg.shaded.org.apache.avro.util.SchemaVisitor;
import org.apache.iceberg.shaded.org.apache.avro.util.Schemas;

public final class SchemaResolver {
    private static final String UR_SCHEMA_ATTR = "org.apache.iceberg.shaded.org.apache.avro.idl.unresolved.name";
    private static final String UR_SCHEMA_NAME = "UnresolvedSchema";
    private static final String UR_SCHEMA_NS = "org.apache.iceberg.shaded.org.apache.avro.compiler";
    private static final AtomicInteger COUNTER = new AtomicInteger();

    private SchemaResolver() {
    }

    public static Schema unresolvedSchema(String name) {
        Schema schema = Schema.createRecord("UnresolvedSchema_" + COUNTER.getAndIncrement(), "unresolved schema", UR_SCHEMA_NS, false, Collections.emptyList());
        schema.addProp(UR_SCHEMA_ATTR, name);
        return schema;
    }

    public static boolean isUnresolvedSchema(Schema schema) {
        return schema.getType() == Schema.Type.RECORD && schema.getProp(UR_SCHEMA_ATTR) != null && schema.getName() != null && schema.getName().startsWith(UR_SCHEMA_NAME) && UR_SCHEMA_NS.equals(schema.getNamespace());
    }

    public static String getUnresolvedSchemaName(Schema schema) {
        if (!SchemaResolver.isUnresolvedSchema(schema)) {
            throw new IllegalArgumentException("Not a unresolved schema: " + String.valueOf(schema));
        }
        return schema.getProp(UR_SCHEMA_ATTR);
    }

    public static boolean isFullyResolvedSchema(Schema schema) {
        if (SchemaResolver.isUnresolvedSchema(schema)) {
            return false;
        }
        return Schemas.visit(schema, new IsResolvedSchemaVisitor());
    }

    public static final class IsResolvedSchemaVisitor
    implements SchemaVisitor<Boolean> {
        boolean hasUnresolvedParts = false;

        IsResolvedSchemaVisitor() {
        }

        @Override
        public SchemaVisitor.SchemaVisitorAction visitTerminal(Schema terminal) {
            this.hasUnresolvedParts = SchemaResolver.isUnresolvedSchema(terminal);
            return this.hasUnresolvedParts ? SchemaVisitor.SchemaVisitorAction.TERMINATE : SchemaVisitor.SchemaVisitorAction.CONTINUE;
        }

        @Override
        public SchemaVisitor.SchemaVisitorAction visitNonTerminal(Schema nonTerminal) {
            this.hasUnresolvedParts = SchemaResolver.isUnresolvedSchema(nonTerminal);
            if (this.hasUnresolvedParts) {
                return SchemaVisitor.SchemaVisitorAction.TERMINATE;
            }
            if (nonTerminal.getType() == Schema.Type.RECORD && !nonTerminal.hasFields()) {
                return SchemaVisitor.SchemaVisitorAction.SKIP_SUBTREE;
            }
            return SchemaVisitor.SchemaVisitorAction.CONTINUE;
        }

        @Override
        public SchemaVisitor.SchemaVisitorAction afterVisitNonTerminal(Schema nonTerminal) {
            return SchemaVisitor.SchemaVisitorAction.CONTINUE;
        }

        @Override
        public Boolean get() {
            return !this.hasUnresolvedParts;
        }
    }

    public static final class ResolvingVisitor
    implements SchemaVisitor<Void> {
        private static final Set<Schema.Type> CONTAINER_SCHEMA_TYPES = EnumSet.of(Schema.Type.RECORD, Schema.Type.ARRAY, Schema.Type.MAP, Schema.Type.UNION);
        private static final Set<Schema.Type> NAMED_SCHEMA_TYPES = EnumSet.of(Schema.Type.RECORD, Schema.Type.ENUM, Schema.Type.FIXED);
        private final Function<String, Schema> symbolTable;
        private final IdentityHashMap<Schema, Schema> replace = new IdentityHashMap();

        public ResolvingVisitor(Function<String, Schema> symbolTable) {
            this.symbolTable = symbolTable;
        }

        @Override
        public SchemaVisitor.SchemaVisitorAction visitTerminal(Schema terminal) {
            Schema.Type type = terminal.getType();
            if (CONTAINER_SCHEMA_TYPES.contains((Object)type)) {
                if (!this.replace.containsKey(terminal)) {
                    throw new IllegalStateException("Schema " + String.valueOf(terminal) + " must be already processed");
                }
            } else {
                this.replace.put(terminal, terminal);
            }
            return SchemaVisitor.SchemaVisitorAction.CONTINUE;
        }

        @Override
        public SchemaVisitor.SchemaVisitorAction visitNonTerminal(Schema nt) {
            Schema.Type type = nt.getType();
            if (type == Schema.Type.RECORD && !this.replace.containsKey(nt)) {
                if (SchemaResolver.isUnresolvedSchema(nt)) {
                    String unresolvedSchemaName = SchemaResolver.getUnresolvedSchemaName(nt);
                    Schema resSchema = this.symbolTable.apply(unresolvedSchemaName);
                    if (resSchema == null) {
                        throw new AvroTypeException("Undefined schema: " + unresolvedSchemaName);
                    }
                    Schema replacement = this.replace.computeIfAbsent(resSchema, schema -> {
                        Schemas.visit(schema, this);
                        return this.replace.get(schema);
                    });
                    this.replace.put(nt, replacement);
                } else {
                    this.replace.put(nt, Schema.createRecord(nt.getName(), nt.getDoc(), nt.getNamespace(), nt.isError()));
                }
            }
            return SchemaVisitor.SchemaVisitorAction.CONTINUE;
        }

        public void copyProperties(Schema first, Schema second) {
            Optional.ofNullable(first.getLogicalType()).ifPresent(logicalType -> logicalType.addToSchema(second));
            if (NAMED_SCHEMA_TYPES.contains((Object)first.getType())) {
                first.getAliases().forEach(second::addAlias);
            }
            first.getObjectProps().forEach(second::addProp);
        }

        @Override
        public SchemaVisitor.SchemaVisitorAction afterVisitNonTerminal(Schema nt) {
            Schema newSchema;
            Schema.Type type = nt.getType();
            switch (type) {
                case RECORD: {
                    Schema newSchema2;
                    if (!SchemaResolver.isUnresolvedSchema(nt) && !(newSchema2 = this.replace.get(nt)).hasFields()) {
                        List<Schema.Field> fields = nt.getFields();
                        ArrayList<Schema.Field> newFields = new ArrayList<Schema.Field>(fields.size());
                        for (Schema.Field field : fields) {
                            newFields.add(new Schema.Field(field, this.replace.get(field.schema())));
                        }
                        newSchema2.setFields(newFields);
                        this.copyProperties(nt, newSchema2);
                    }
                    return SchemaVisitor.SchemaVisitorAction.CONTINUE;
                }
                case UNION: {
                    List<Schema> types = nt.getTypes();
                    ArrayList<Schema> newTypes = new ArrayList<Schema>(types.size());
                    for (Schema sch : types) {
                        newTypes.add(Objects.requireNonNull(this.replace.get(sch)));
                    }
                    newSchema = Schema.createUnion(newTypes);
                    break;
                }
                case ARRAY: {
                    newSchema = Schema.createArray(Objects.requireNonNull(this.replace.get(nt.getElementType())));
                    break;
                }
                case MAP: {
                    newSchema = Schema.createMap(Objects.requireNonNull(this.replace.get(nt.getValueType())));
                    break;
                }
                default: {
                    throw new IllegalStateException("Illegal type " + String.valueOf((Object)type) + ", schema " + String.valueOf(nt));
                }
            }
            this.copyProperties(nt, newSchema);
            this.replace.put(nt, newSchema);
            return SchemaVisitor.SchemaVisitorAction.CONTINUE;
        }

        @Override
        public Void get() {
            return null;
        }

        public Schema getResolved(Schema schema) {
            return Objects.requireNonNull(this.replace.get(schema), () -> "Unknown schema: " + schema.getFullName() + ". Was it resolved before?");
        }

        public String toString() {
            return "ResolvingVisitor{symbolTable=" + String.valueOf(this.symbolTable) + ", replace=" + String.valueOf(this.replace) + "}";
        }
    }
}

