/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.org.apache.parquet.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import org.apache.iceberg.shaded.org.apache.parquet.crypto.AesCipher;
import org.apache.iceberg.shaded.org.apache.parquet.crypto.AesMode;
import org.apache.iceberg.shaded.org.apache.parquet.crypto.ParquetCryptoRuntimeException;
import org.apache.iceberg.shaded.org.apache.parquet.format.BlockCipher;

public class AesCtrDecryptor
extends AesCipher
implements BlockCipher.Decryptor {
    private final byte[] ctrIV;

    AesCtrDecryptor(byte[] keyBytes) {
        super(AesMode.CTR, keyBytes);
        try {
            this.cipher = Cipher.getInstance(AesMode.CTR.getCipherName());
        }
        catch (GeneralSecurityException e) {
            throw new ParquetCryptoRuntimeException("Failed to create CTR cipher", e);
        }
        this.ctrIV = new byte[16];
        this.ctrIV[15] = 1;
    }

    @Override
    public byte[] decrypt(byte[] lengthAndCiphertext, byte[] AAD) {
        int cipherTextOffset = 4;
        int cipherTextLength = lengthAndCiphertext.length - 4;
        return this.decrypt(lengthAndCiphertext, cipherTextOffset, cipherTextLength, AAD);
    }

    public byte[] decrypt(byte[] ciphertext, int cipherTextOffset, int cipherTextLength, byte[] AAD) {
        int plainTextLength = cipherTextLength - 12;
        if (plainTextLength < 1) {
            throw new ParquetCryptoRuntimeException("Wrong input length " + plainTextLength);
        }
        System.arraycopy(ciphertext, cipherTextOffset, this.ctrIV, 0, 12);
        byte[] plainText = new byte[plainTextLength];
        int inputOffset = cipherTextOffset + 12;
        int outputOffset = 0;
        try {
            int inputLength;
            IvParameterSpec spec = new IvParameterSpec(this.ctrIV);
            this.cipher.init(2, (Key)this.aesKey, spec);
            for (inputLength = cipherTextLength - 12; inputLength > 4096; inputLength -= 4096) {
                int written = this.cipher.update(ciphertext, inputOffset, 4096, plainText, outputOffset);
                inputOffset += 4096;
                outputOffset += written;
            }
            this.cipher.doFinal(ciphertext, inputOffset, inputLength, plainText, outputOffset);
        }
        catch (GeneralSecurityException e) {
            throw new ParquetCryptoRuntimeException("Failed to decrypt", e);
        }
        return plainText;
    }

    @Override
    public ByteBuffer decrypt(ByteBuffer ciphertext, byte[] AAD) {
        int cipherTextOffset = 4;
        int cipherTextLength = ciphertext.limit() - ciphertext.position() - 4;
        int plainTextLength = cipherTextLength - 12;
        if (plainTextLength < 1) {
            throw new ParquetCryptoRuntimeException("Wrong input length " + plainTextLength);
        }
        ciphertext.position(ciphertext.position() + cipherTextOffset);
        ciphertext.get(this.ctrIV, 0, 12);
        ByteBuffer plainText = ciphertext.slice();
        plainText.limit(plainTextLength);
        int inputOffset = cipherTextOffset + 12;
        try {
            int inputLength;
            IvParameterSpec spec = new IvParameterSpec(this.ctrIV);
            this.cipher.init(2, (Key)this.aesKey, spec);
            for (inputLength = cipherTextLength - 12; inputLength > 4096; inputLength -= 4096) {
                ciphertext.position(inputOffset);
                ciphertext.limit(inputOffset + 4096);
                this.cipher.update(ciphertext, plainText);
                inputOffset += 4096;
            }
            ciphertext.position(inputOffset);
            ciphertext.limit(inputOffset + inputLength);
            this.cipher.doFinal(ciphertext, plainText);
            plainText.flip();
        }
        catch (GeneralSecurityException e) {
            throw new ParquetCryptoRuntimeException("Failed to decrypt", e);
        }
        return plainText;
    }

    @Override
    public byte[] decrypt(InputStream from, byte[] AAD) throws IOException {
        int n;
        int gotBytes;
        int n2;
        byte[] lengthBuffer = new byte[4];
        for (gotBytes = 0; gotBytes < 4; gotBytes += n2) {
            n2 = from.read(lengthBuffer, gotBytes, 4 - gotBytes);
            if (n2 > 0) continue;
            throw new IOException("Tried to read int (4 bytes), but only got " + gotBytes + " bytes.");
        }
        int ciphertextLength = (lengthBuffer[3] & 0xFF) << 24 | (lengthBuffer[2] & 0xFF) << 16 | (lengthBuffer[1] & 0xFF) << 8 | lengthBuffer[0] & 0xFF;
        if (ciphertextLength < 1) {
            throw new IOException("Wrong length of encrypted metadata: " + ciphertextLength);
        }
        byte[] ciphertextBuffer = new byte[ciphertextLength];
        for (gotBytes = 0; gotBytes < ciphertextLength; gotBytes += n) {
            n = from.read(ciphertextBuffer, gotBytes, ciphertextLength - gotBytes);
            if (n > 0) continue;
            throw new IOException("Tried to read " + ciphertextLength + " bytes, but only got " + gotBytes + " bytes.");
        }
        return this.decrypt(ciphertextBuffer, 0, ciphertextLength, AAD);
    }
}

