/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.org.apache.parquet.internal.column.columnindex;

import java.util.Formatter;
import java.util.Optional;
import org.apache.iceberg.shaded.org.apache.parquet.internal.column.columnindex.OffsetIndex;
import org.apache.iceberg.shaded.org.apache.parquet.shaded.it.unimi.dsi.fastutil.ints.IntArrayList;
import org.apache.iceberg.shaded.org.apache.parquet.shaded.it.unimi.dsi.fastutil.ints.IntList;
import org.apache.iceberg.shaded.org.apache.parquet.shaded.it.unimi.dsi.fastutil.longs.LongArrayList;
import org.apache.iceberg.shaded.org.apache.parquet.shaded.it.unimi.dsi.fastutil.longs.LongList;

public class OffsetIndexBuilder {
    private static final OffsetIndexBuilder NO_OP_BUILDER = new OffsetIndexBuilder(){

        @Override
        public void add(int compressedPageSize, long rowCount) {
        }

        @Override
        public void add(long offset, int compressedPageSize, long rowCount) {
        }

        @Override
        public OffsetIndex build() {
            return null;
        }

        @Override
        public OffsetIndex build(long shift) {
            return null;
        }
    };
    private final LongList offsets = new LongArrayList();
    private final IntList compressedPageSizes = new IntArrayList();
    private final LongList firstRowIndexes = new LongArrayList();
    private final LongList unencodedDataBytes = new LongArrayList();
    private long previousOffset;
    private int previousPageSize;
    private long previousRowIndex;
    private long previousRowCount;

    public static OffsetIndexBuilder getNoOpBuilder() {
        return NO_OP_BUILDER;
    }

    public static OffsetIndexBuilder getBuilder() {
        return new OffsetIndexBuilder();
    }

    private OffsetIndexBuilder() {
    }

    public void add(int compressedPageSize, long rowCount) {
        this.add(compressedPageSize, rowCount, Optional.empty());
    }

    public void add(int compressedPageSize, long rowCount, Optional<Long> unencodedDataBytes) {
        this.add(this.previousOffset + (long)this.previousPageSize, compressedPageSize, this.previousRowIndex + this.previousRowCount, unencodedDataBytes);
        this.previousRowCount = rowCount;
    }

    public void add(long offset, int compressedPageSize, long firstRowIndex) {
        this.add(offset, compressedPageSize, firstRowIndex, Optional.empty());
    }

    public void add(long offset, int compressedPageSize, long firstRowIndex, Optional<Long> unencodedDataBytes) {
        this.previousOffset = offset;
        this.offsets.add(offset);
        this.previousPageSize = compressedPageSize;
        this.compressedPageSizes.add(compressedPageSize);
        this.previousRowIndex = firstRowIndex;
        this.firstRowIndexes.add(firstRowIndex);
        if (unencodedDataBytes.isPresent()) {
            this.unencodedDataBytes.add(unencodedDataBytes.get());
        }
    }

    public OffsetIndex build() {
        return this.build(0L);
    }

    public OffsetIndexBuilder fromOffsetIndex(OffsetIndex offsetIndex) {
        assert (offsetIndex instanceof OffsetIndexImpl);
        OffsetIndexImpl offsetIndexImpl = (OffsetIndexImpl)offsetIndex;
        this.offsets.addAll(new LongArrayList(offsetIndexImpl.offsets));
        this.compressedPageSizes.addAll(new IntArrayList(offsetIndexImpl.compressedPageSizes));
        this.firstRowIndexes.addAll(new LongArrayList(offsetIndexImpl.firstRowIndexes));
        if (offsetIndexImpl.unencodedByteArrayDataBytes != null) {
            this.unencodedDataBytes.addAll(new LongArrayList(offsetIndexImpl.unencodedByteArrayDataBytes));
        }
        this.previousOffset = 0L;
        this.previousPageSize = 0;
        this.previousRowIndex = 0L;
        this.previousRowCount = 0L;
        return this;
    }

    public OffsetIndex build(long shift) {
        if (this.compressedPageSizes.isEmpty()) {
            return null;
        }
        long[] offsets = this.offsets.toLongArray();
        if (shift != 0L) {
            int i = 0;
            int n = offsets.length;
            while (i < n) {
                int n2 = i++;
                offsets[n2] = offsets[n2] + shift;
            }
        }
        OffsetIndexImpl offsetIndex = new OffsetIndexImpl();
        OffsetIndexImpl.access$102(offsetIndex, offsets);
        OffsetIndexImpl.access$202(offsetIndex, this.compressedPageSizes.toIntArray());
        OffsetIndexImpl.access$302(offsetIndex, this.firstRowIndexes.toLongArray());
        if (!this.unencodedDataBytes.isEmpty()) {
            if (this.unencodedDataBytes.size() != this.offsets.size()) {
                throw new IllegalStateException("unencodedDataBytes does not have the same size as offsets");
            }
            OffsetIndexImpl.access$402(offsetIndex, this.unencodedDataBytes.toLongArray());
        }
        return offsetIndex;
    }

    private static class OffsetIndexImpl
    implements OffsetIndex {
        private long[] offsets;
        private int[] compressedPageSizes;
        private long[] firstRowIndexes;
        private long[] unencodedByteArrayDataBytes;

        private OffsetIndexImpl() {
        }

        public String toString() {
            try (Formatter formatter = new Formatter();){
                formatter.format("%-10s  %20s  %16s  %20s\n", "", "offset", "compressed size", "first row index");
                int n = this.offsets.length;
                for (int i = 0; i < n; ++i) {
                    formatter.format("page-%-5d  %20d  %16d  %20d\n", i, this.offsets[i], this.compressedPageSizes[i], this.firstRowIndexes[i]);
                }
                String string = formatter.toString();
                return string;
            }
        }

        @Override
        public int getPageCount() {
            return this.offsets.length;
        }

        @Override
        public long getOffset(int pageIndex) {
            return this.offsets[pageIndex];
        }

        @Override
        public int getCompressedPageSize(int pageIndex) {
            return this.compressedPageSizes[pageIndex];
        }

        @Override
        public long getFirstRowIndex(int pageIndex) {
            return this.firstRowIndexes[pageIndex];
        }

        @Override
        public int getPageOrdinal(int pageIndex) {
            return pageIndex;
        }

        @Override
        public Optional<Long> getUnencodedByteArrayDataBytes(int pageIndex) {
            if (this.unencodedByteArrayDataBytes == null || this.unencodedByteArrayDataBytes.length == 0) {
                return Optional.empty();
            }
            return Optional.of(this.unencodedByteArrayDataBytes[pageIndex]);
        }

        static /* synthetic */ long[] access$102(OffsetIndexImpl x0, long[] x1) {
            x0.offsets = x1;
            return x1;
        }

        static /* synthetic */ int[] access$202(OffsetIndexImpl x0, int[] x1) {
            x0.compressedPageSizes = x1;
            return x1;
        }

        static /* synthetic */ long[] access$302(OffsetIndexImpl x0, long[] x1) {
            x0.firstRowIndexes = x1;
            return x1;
        }

        static /* synthetic */ long[] access$402(OffsetIndexImpl x0, long[] x1) {
            x0.unencodedByteArrayDataBytes = x1;
            return x1;
        }
    }
}

