/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.iceberg.BaseCombinedScanTask;
import org.apache.iceberg.BaseScanTaskGroup;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.MergeableScanTask;
import org.apache.iceberg.PartitionData;
import org.apache.iceberg.PartitionScanTask;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.ScanTask;
import org.apache.iceberg.ScanTaskGroup;
import org.apache.iceberg.SplittableScanTask;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.FluentIterable;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.math.LongMath;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.BinPacking;
import org.apache.iceberg.util.ScanTaskUtil;
import org.apache.iceberg.util.StructLikeMap;
import org.apache.iceberg.util.StructProjection;

public class TableScanUtil {
    private static final long MIN_SPLIT_SIZE = 0x1000000L;

    private TableScanUtil() {
    }

    public static boolean hasDeletes(CombinedScanTask task) {
        return task.files().stream().anyMatch(TableScanUtil::hasDeletes);
    }

    public static boolean hasEqDeletes(CombinedScanTask task) {
        return task.files().stream().anyMatch(t2 -> t2.deletes().stream().anyMatch(deleteFile -> deleteFile.content().equals((Object)FileContent.EQUALITY_DELETES)));
    }

    public static boolean hasDeletes(FileScanTask task) {
        return !task.deletes().isEmpty();
    }

    public static CloseableIterable<FileScanTask> splitFiles(CloseableIterable<FileScanTask> tasks, long splitSize) {
        Preconditions.checkArgument(splitSize > 0L, "Split size must be > 0: %s", splitSize);
        FluentIterable splitTasks = FluentIterable.from(tasks).transformAndConcat(input -> input.split(splitSize));
        return CloseableIterable.combine(splitTasks, tasks);
    }

    public static CloseableIterable<CombinedScanTask> planTasks(CloseableIterable<FileScanTask> splitFiles, long splitSize, int lookback, long openFileCost) {
        TableScanUtil.validatePlanningArguments(splitSize, lookback, openFileCost);
        Function<FileScanTask, Long> weightFunc = file -> Math.max(file.length() + ScanTaskUtil.contentSizeInBytes(file.deletes()), (long)(1 + file.deletes().size()) * openFileCost);
        return CloseableIterable.transform(CloseableIterable.combine(new BinPacking.PackingIterable<FileScanTask>(splitFiles, splitSize, lookback, weightFunc, true), splitFiles), BaseCombinedScanTask::new);
    }

    public static <T extends ScanTask> List<ScanTaskGroup<T>> planTaskGroups(List<T> tasks, long splitSize, int lookback, long openFileCost) {
        return Lists.newArrayList(TableScanUtil.planTaskGroups(CloseableIterable.withNoopClose(tasks), splitSize, lookback, openFileCost));
    }

    public static <T extends ScanTask> CloseableIterable<ScanTaskGroup<T>> planTaskGroups(CloseableIterable<T> tasks, long splitSize, int lookback, long openFileCost) {
        TableScanUtil.validatePlanningArguments(splitSize, lookback, openFileCost);
        CloseableIterable splitTasks = CloseableIterable.combine(FluentIterable.from(tasks).transformAndConcat(task -> {
            if (task instanceof SplittableScanTask) {
                return ((SplittableScanTask)task).split(splitSize);
            }
            return ImmutableList.of(task);
        }), tasks);
        Function<ScanTask, Long> weightFunc = task -> Math.max(task.sizeBytes(), (long)task.filesCount() * openFileCost);
        return CloseableIterable.transform(CloseableIterable.combine(new BinPacking.PackingIterable<ScanTask>(splitTasks, splitSize, lookback, weightFunc, true), splitTasks), combinedTasks -> new BaseScanTaskGroup(TableScanUtil.mergeTasks(combinedTasks)));
    }

    public static <T extends PartitionScanTask> List<ScanTaskGroup<T>> planTaskGroups(List<T> tasks, long splitSize, int lookback, long openFileCost, Types.StructType groupingKeyType) {
        TableScanUtil.validatePlanningArguments(splitSize, lookback, openFileCost);
        Function<PartitionScanTask, Long> weightFunc = task -> Math.max(task.sizeBytes(), (long)task.filesCount() * openFileCost);
        HashMap<Integer, StructProjection> groupingKeyProjectionsBySpec = Maps.newHashMap();
        PartitionData groupingKeyTemplate = new PartitionData(groupingKeyType);
        StructLikeMap tasksByGroupingKey = StructLikeMap.create(groupingKeyType);
        for (PartitionScanTask task2 : tasks) {
            PartitionSpec spec = task2.spec();
            StructLike partition = task2.partition();
            StructProjection groupingKeyProjection = groupingKeyProjectionsBySpec.computeIfAbsent(spec.specId(), specId -> StructProjection.create(spec.partitionType(), groupingKeyType));
            List groupingKeyTasks = tasksByGroupingKey.computeIfAbsent(groupingKeyTemplate.copyFor(groupingKeyProjection.wrap(partition)), groupingKey -> Lists.newArrayList());
            if (task2 instanceof SplittableScanTask) {
                ((SplittableScanTask)((Object)task2)).split(splitSize).forEach(groupingKeyTasks::add);
                continue;
            }
            groupingKeyTasks.add(task2);
        }
        ArrayList<ScanTaskGroup<T>> taskGroups = Lists.newArrayList();
        for (Map.Entry entry : tasksByGroupingKey.entrySet()) {
            StructLike groupingKey2 = entry.getKey();
            List groupingKeyTasks = (List)entry.getValue();
            Iterables.addAll(taskGroups, TableScanUtil.toTaskGroupIterable(groupingKey2, groupingKeyTasks, splitSize, lookback, weightFunc));
        }
        return taskGroups;
    }

    private static <T extends ScanTask> Iterable<ScanTaskGroup<T>> toTaskGroupIterable(StructLike groupingKey, Iterable<T> tasks, long splitSize, int lookback, Function<T, Long> weightFunc) {
        return Iterables.transform(new BinPacking.PackingIterable<T>(tasks, splitSize, lookback, weightFunc, true), combinedTasks -> new BaseScanTaskGroup(groupingKey, TableScanUtil.mergeTasks(combinedTasks)));
    }

    public static <T extends ScanTask> List<T> mergeTasks(List<T> tasks) {
        ArrayList<ScanTask> mergedTasks = Lists.newArrayList();
        ScanTask lastTask = null;
        for (ScanTask task : tasks) {
            if (lastTask != null) {
                if (lastTask instanceof MergeableScanTask) {
                    MergeableScanTask mergeableLastTask = (MergeableScanTask)lastTask;
                    if (mergeableLastTask.canMerge(task)) {
                        lastTask = (ScanTask)mergeableLastTask.merge(task);
                        continue;
                    }
                    mergedTasks.add(lastTask);
                    lastTask = task;
                    continue;
                }
                mergedTasks.add(lastTask);
                lastTask = task;
                continue;
            }
            lastTask = task;
        }
        if (lastTask != null) {
            mergedTasks.add(lastTask);
        }
        return mergedTasks;
    }

    public static long adjustSplitSize(long scanSize, int parallelism, long splitSize) {
        long splitCount = LongMath.divide(scanSize, splitSize, RoundingMode.CEILING);
        long adjustedSplitSize = Math.max(scanSize / (long)parallelism, Math.min(0x1000000L, splitSize));
        return splitCount < (long)parallelism ? adjustedSplitSize : splitSize;
    }

    private static void validatePlanningArguments(long splitSize, int lookback, long openFileCost) {
        Preconditions.checkArgument(splitSize > 0L, "Split size must be > 0: %s", splitSize);
        Preconditions.checkArgument(lookback > 0, "Split planning lookback must be > 0: %s", lookback);
        Preconditions.checkArgument(openFileCost >= 0L, "File open cost must be >= 0: %s", openFileCost);
    }
}

