/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.variants;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.util.Pair;
import org.apache.iceberg.variants.VariantMetadata;
import org.apache.iceberg.variants.VariantObject;
import org.apache.iceberg.variants.VariantUtil;
import org.apache.iceberg.variants.VariantValue;
import org.apache.iceberg.variants.Variants;

class SerializedObject
extends Variants.SerializedValue
implements VariantObject {
    private static final int OFFSET_SIZE_MASK = 12;
    private static final int OFFSET_SIZE_SHIFT = 2;
    private static final int FIELD_ID_SIZE_MASK = 48;
    private static final int FIELD_ID_SIZE_SHIFT = 4;
    private static final int IS_LARGE = 64;
    private final VariantMetadata metadata;
    private final ByteBuffer value;
    private final int fieldIdSize;
    private final int fieldIdListOffset;
    private final Integer[] fieldIds;
    private final int offsetSize;
    private final int offsetListOffset;
    private final int[] offsets;
    private final int[] lengths;
    private final int dataOffset;
    private final VariantValue[] values;

    static SerializedObject from(VariantMetadata metadata, byte[] bytes) {
        return SerializedObject.from(metadata, ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN), bytes[0]);
    }

    static SerializedObject from(VariantMetadata metadata, ByteBuffer value, int header) {
        Preconditions.checkArgument(value.order() == ByteOrder.LITTLE_ENDIAN, "Unsupported byte order: big endian");
        Variants.BasicType basicType = VariantUtil.basicType(header);
        Preconditions.checkArgument(basicType == Variants.BasicType.OBJECT, "Invalid object, basic type: " + basicType);
        return new SerializedObject(metadata, value, header);
    }

    private SerializedObject(VariantMetadata metadata, ByteBuffer value, int header) {
        this.metadata = metadata;
        this.value = value;
        this.offsetSize = 1 + ((header & 0xC) >> 2);
        this.fieldIdSize = 1 + ((header & 0x30) >> 4);
        int numElementsSize = (header & 0x40) == 64 ? 4 : 1;
        int numElements = VariantUtil.readLittleEndianUnsigned(value, 1, numElementsSize);
        this.fieldIdListOffset = 1 + numElementsSize;
        this.fieldIds = new Integer[numElements];
        this.offsetListOffset = this.fieldIdListOffset + numElements * this.fieldIdSize;
        this.offsets = new int[numElements];
        this.lengths = new int[numElements];
        this.dataOffset = this.offsetListOffset + (1 + numElements) * this.offsetSize;
        this.values = new VariantValue[numElements];
        if (numElements > 0) {
            this.initOffsetsAndLengths(numElements);
        }
    }

    private void initOffsetsAndLengths(int numElements) {
        int index;
        HashMap<Integer, Integer> offsetToLength = Maps.newHashMap();
        for (int index2 = 0; index2 < numElements; ++index2) {
            this.offsets[index2] = VariantUtil.readLittleEndianUnsigned(this.value, this.offsetListOffset + index2 * this.offsetSize, this.offsetSize);
            offsetToLength.put(this.offsets[index2], 0);
        }
        int dataLength = VariantUtil.readLittleEndianUnsigned(this.value, this.offsetListOffset + numElements * this.offsetSize, this.offsetSize);
        offsetToLength.put(dataLength, 0);
        List sortedOffsets = offsetToLength.keySet().stream().sorted().collect(Collectors.toList());
        for (index = 0; index < numElements; ++index) {
            int offset = (Integer)sortedOffsets.get(index);
            int length = (Integer)sortedOffsets.get(index + 1) - offset;
            offsetToLength.put(offset, length);
        }
        for (index = 0; index < this.lengths.length; ++index) {
            this.lengths[index] = (Integer)offsetToLength.get(this.offsets[index]);
        }
    }

    @Override
    public int numFields() {
        return this.fieldIds.length;
    }

    @VisibleForTesting
    VariantMetadata metadata() {
        return this.metadata;
    }

    Iterable<Pair<String, Integer>> fields() {
        return () -> new Iterator<Pair<String, Integer>>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < SerializedObject.this.fieldIds.length;
            }

            @Override
            public Pair<String, Integer> next() {
                Pair<String, Integer> next = Pair.of(SerializedObject.this.metadata.get(SerializedObject.this.id(this.index)), this.index);
                ++this.index;
                return next;
            }
        };
    }

    @Override
    public Iterable<String> fieldNames() {
        return () -> new Iterator<String>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < SerializedObject.this.fieldIds.length;
            }

            @Override
            public String next() {
                int id = SerializedObject.this.id(this.index);
                ++this.index;
                return SerializedObject.this.metadata.get(id);
            }
        };
    }

    private int id(int index) {
        if (null == this.fieldIds[index]) {
            this.fieldIds[index] = VariantUtil.readLittleEndianUnsigned(this.value, this.fieldIdListOffset + index * this.fieldIdSize, this.fieldIdSize);
        }
        return this.fieldIds[index];
    }

    @Override
    public VariantValue get(String name) {
        int index = VariantUtil.find(this.fieldIds.length, name, pos -> this.metadata.get(this.id((int)pos)));
        if (index < 0) {
            return null;
        }
        if (null == this.values[index]) {
            this.values[index] = Variants.value(this.metadata, VariantUtil.slice(this.value, this.dataOffset + this.offsets[index], this.lengths[index]));
        }
        return this.values[index];
    }

    ByteBuffer sliceValue(String name) {
        int index = VariantUtil.find(this.fieldIds.length, name, pos -> this.metadata.get(this.id((int)pos)));
        if (index < 0) {
            return null;
        }
        return this.sliceValue(index);
    }

    ByteBuffer sliceValue(int index) {
        if (this.values[index] != null) {
            return ((Variants.Serialized)((Object)this.values[index])).buffer();
        }
        return VariantUtil.slice(this.value, this.dataOffset + this.offsets[index], this.lengths[index]);
    }

    @Override
    public ByteBuffer buffer() {
        return this.value;
    }

    @Override
    public int sizeInBytes() {
        return this.value.remaining();
    }

    public String toString() {
        return VariantObject.asString(this);
    }
}

