/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.variants;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.variants.PhysicalType;
import org.apache.iceberg.variants.VariantPrimitive;
import org.apache.iceberg.variants.VariantUtil;
import org.apache.iceberg.variants.Variants;

class SerializedShortString
extends Variants.SerializedValue
implements VariantPrimitive<String> {
    private static final int LENGTH_MASK = 252;
    private static final int LENGTH_SHIFT = 2;
    private final ByteBuffer value;
    private final int length;
    private String string = null;

    static SerializedShortString from(byte[] bytes) {
        return SerializedShortString.from(ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN), bytes[0]);
    }

    static SerializedShortString from(ByteBuffer value, int header) {
        Preconditions.checkArgument(value.order() == ByteOrder.LITTLE_ENDIAN, "Unsupported byte order: big endian");
        Variants.BasicType basicType = VariantUtil.basicType(header);
        Preconditions.checkArgument(basicType == Variants.BasicType.SHORT_STRING, "Invalid short string, basic type: " + basicType);
        return new SerializedShortString(value, header);
    }

    private SerializedShortString(ByteBuffer value, int header) {
        this.value = value;
        this.length = (header & 0xFC) >> 2;
    }

    @Override
    public PhysicalType type() {
        return PhysicalType.STRING;
    }

    @Override
    public String get() {
        if (null == this.string) {
            this.string = VariantUtil.readString(this.value, 1, this.length);
        }
        return this.string;
    }

    @Override
    public ByteBuffer buffer() {
        return this.value;
    }

    public String toString() {
        return VariantPrimitive.asString(this);
    }
}

