/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.variants;

import org.apache.iceberg.variants.PhysicalType;
import org.apache.iceberg.variants.VariantValue;

public interface VariantObject
extends VariantValue {
    public VariantValue get(String var1);

    public Iterable<String> fieldNames();

    public int numFields();

    @Override
    default public PhysicalType type() {
        return PhysicalType.OBJECT;
    }

    @Override
    default public VariantObject asObject() {
        return this;
    }

    public static String asString(VariantObject object) {
        StringBuilder builder = new StringBuilder();
        builder.append("VariantObject(fields={");
        boolean first = true;
        for (String field : object.fieldNames()) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append(field).append(": ").append(object.get(field));
        }
        builder.append("})");
        return builder.toString();
    }
}

