/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.variants;

import java.nio.ByteBuffer;
import org.apache.iceberg.relocated.com.google.common.io.BaseEncoding;
import org.apache.iceberg.util.ByteBuffers;
import org.apache.iceberg.util.DateTimeUtil;
import org.apache.iceberg.variants.VariantValue;

public interface VariantPrimitive<T>
extends VariantValue {
    public T get();

    @Override
    default public VariantPrimitive<?> asPrimitive() {
        return this;
    }

    private String valueAsString() {
        switch (this.type()) {
            case DATE: {
                return DateTimeUtil.daysToIsoDate((Integer)this.get());
            }
            case TIMESTAMPTZ: {
                return DateTimeUtil.microsToIsoTimestamptz((Long)this.get());
            }
            case TIMESTAMPNTZ: {
                return DateTimeUtil.microsToIsoTimestamp((Long)this.get());
            }
            case BINARY: {
                return BaseEncoding.base16().encode(ByteBuffers.toByteArray((ByteBuffer)this.get()));
            }
        }
        return String.valueOf(this.get());
    }

    public static String asString(VariantPrimitive<?> primitive) {
        return "Variant(type=" + primitive.type() + ", value=" + primitive.valueAsString() + ")";
    }
}

