/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.variants;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import org.apache.iceberg.util.DateTimeUtil;
import org.apache.iceberg.variants.PhysicalType;
import org.apache.iceberg.variants.PrimitiveWrapper;
import org.apache.iceberg.variants.SerializedArray;
import org.apache.iceberg.variants.SerializedMetadata;
import org.apache.iceberg.variants.SerializedObject;
import org.apache.iceberg.variants.SerializedPrimitive;
import org.apache.iceberg.variants.SerializedShortString;
import org.apache.iceberg.variants.ShreddedObject;
import org.apache.iceberg.variants.VariantMetadata;
import org.apache.iceberg.variants.VariantObject;
import org.apache.iceberg.variants.VariantPrimitive;
import org.apache.iceberg.variants.VariantUtil;
import org.apache.iceberg.variants.VariantValue;

public class Variants {
    static final int HEADER_SIZE = 1;

    private Variants() {
    }

    public static VariantMetadata metadata(ByteBuffer metadata) {
        return SerializedMetadata.from(metadata);
    }

    public static VariantValue value(VariantMetadata metadata, ByteBuffer value) {
        int header = VariantUtil.readByte(value, 0);
        BasicType basicType = VariantUtil.basicType(header);
        switch (basicType) {
            case PRIMITIVE: {
                return SerializedPrimitive.from(value, header);
            }
            case SHORT_STRING: {
                return SerializedShortString.from(value, header);
            }
            case OBJECT: {
                return SerializedObject.from(metadata, value, header);
            }
            case ARRAY: {
                return SerializedArray.from(metadata, value, header);
            }
        }
        throw new UnsupportedOperationException("Unsupported basic type: " + basicType);
    }

    public static ShreddedObject object(VariantMetadata metadata, VariantObject object) {
        return new ShreddedObject(metadata, object);
    }

    public static ShreddedObject object(VariantMetadata metadata) {
        return new ShreddedObject(metadata);
    }

    public static <T> VariantPrimitive<T> of(PhysicalType type, T value) {
        return new PrimitiveWrapper<T>(type, value);
    }

    public static VariantPrimitive<Void> ofNull() {
        return new PrimitiveWrapper<Object>(PhysicalType.NULL, null);
    }

    static VariantPrimitive<Boolean> of(boolean value) {
        return new PrimitiveWrapper<Boolean>(PhysicalType.BOOLEAN_TRUE, value);
    }

    static VariantPrimitive<Byte> of(byte value) {
        return new PrimitiveWrapper<Byte>(PhysicalType.INT8, value);
    }

    static VariantPrimitive<Short> of(short value) {
        return new PrimitiveWrapper<Short>(PhysicalType.INT16, value);
    }

    static VariantPrimitive<Integer> of(int value) {
        return new PrimitiveWrapper<Integer>(PhysicalType.INT32, value);
    }

    static VariantPrimitive<Long> of(long value) {
        return new PrimitiveWrapper<Long>(PhysicalType.INT64, value);
    }

    static VariantPrimitive<Float> of(float value) {
        return new PrimitiveWrapper<Float>(PhysicalType.FLOAT, Float.valueOf(value));
    }

    static VariantPrimitive<Double> of(double value) {
        return new PrimitiveWrapper<Double>(PhysicalType.DOUBLE, value);
    }

    static VariantPrimitive<Integer> ofDate(int value) {
        return new PrimitiveWrapper<Integer>(PhysicalType.DATE, value);
    }

    static VariantPrimitive<Integer> ofIsoDate(String value) {
        return Variants.ofDate(DateTimeUtil.isoDateToDays(value));
    }

    static VariantPrimitive<Long> ofTimestamptz(long value) {
        return new PrimitiveWrapper<Long>(PhysicalType.TIMESTAMPTZ, value);
    }

    static VariantPrimitive<Long> ofIsoTimestamptz(String value) {
        return Variants.ofTimestamptz(DateTimeUtil.isoTimestamptzToMicros(value));
    }

    static VariantPrimitive<Long> ofTimestampntz(long value) {
        return new PrimitiveWrapper<Long>(PhysicalType.TIMESTAMPNTZ, value);
    }

    static VariantPrimitive<Long> ofIsoTimestampntz(String value) {
        return Variants.ofTimestampntz(DateTimeUtil.isoTimestampToMicros(value));
    }

    static VariantPrimitive<BigDecimal> of(BigDecimal value) {
        int bitLength = value.unscaledValue().bitLength();
        if (bitLength < 32) {
            return new PrimitiveWrapper<BigDecimal>(PhysicalType.DECIMAL4, value);
        }
        if (bitLength < 64) {
            return new PrimitiveWrapper<BigDecimal>(PhysicalType.DECIMAL8, value);
        }
        if (bitLength < 128) {
            return new PrimitiveWrapper<BigDecimal>(PhysicalType.DECIMAL16, value);
        }
        throw new UnsupportedOperationException("Unsupported decimal precision: " + value.precision());
    }

    static VariantPrimitive<ByteBuffer> of(ByteBuffer value) {
        return new PrimitiveWrapper<ByteBuffer>(PhysicalType.BINARY, value);
    }

    static VariantPrimitive<String> of(String value) {
        return new PrimitiveWrapper<String>(PhysicalType.STRING, value);
    }

    static enum BasicType {
        PRIMITIVE,
        SHORT_STRING,
        OBJECT,
        ARRAY;

    }

    static abstract class SerializedValue
    implements VariantValue,
    Serialized {
        SerializedValue() {
        }

        @Override
        public int sizeInBytes() {
            return this.buffer().remaining();
        }

        @Override
        public int writeTo(ByteBuffer buffer, int offset) {
            ByteBuffer value = this.buffer();
            VariantUtil.writeBufferAbsolute(buffer, offset, value);
            return value.remaining();
        }
    }

    static interface Serialized {
        public ByteBuffer buffer();
    }
}

