/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import java.net.URI;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.iceberg.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Value;
import org.projectnessie.client.auth.oauth2.AccessToken;
import org.projectnessie.client.auth.oauth2.ImmutableTokenExchangeConfig;
import org.projectnessie.client.auth.oauth2.OAuth2ClientConfig;
import org.projectnessie.client.auth.oauth2.RefreshToken;
import org.projectnessie.client.auth.oauth2.TypedToken;

@Value.Immutable
public interface TokenExchangeConfig {
    public static TokenExchangeConfig fromConfigSupplier(Function<String, String> config) {
        Builder builder = TokenExchangeConfig.builder();
        OAuth2ClientConfig.applyConfigOption(config, "nessie.authentication.oauth2.token-exchange.resource", builder::resource, URI::create);
        OAuth2ClientConfig.applyConfigOption(config, "nessie.authentication.oauth2.token-exchange.audience", builder::audience);
        String subjectToken = config.apply("nessie.authentication.oauth2.token-exchange.subject-token");
        String actorToken = config.apply("nessie.authentication.oauth2.token-exchange.actor-token");
        Optional<URI> subjectTokenType = Optional.ofNullable(config.apply("nessie.authentication.oauth2.token-exchange.subject-token-type")).map(URI::create);
        Optional<URI> actorTokenType = Optional.ofNullable(config.apply("nessie.authentication.oauth2.token-exchange.actor-token-type")).map(URI::create);
        if (subjectToken == null || subjectToken.equalsIgnoreCase("current_access_token")) {
            builder.subjectTokenProvider((accessToken, refreshToken) -> TypedToken.of(accessToken, subjectTokenType.orElse(TypedToken.URN_ACCESS_TOKEN)));
        } else if (subjectToken.equalsIgnoreCase("current_refresh_token")) {
            builder.subjectTokenProvider((accessToken, refreshToken) -> TypedToken.of(refreshToken, subjectTokenType.orElse(TypedToken.URN_REFRESH_TOKEN)));
        } else {
            builder.subjectToken(TypedToken.of(subjectToken, subjectTokenType.orElse(TypedToken.URN_ACCESS_TOKEN)));
        }
        if (actorToken != null && !actorToken.equalsIgnoreCase("no_token")) {
            if (actorToken.equalsIgnoreCase("current_access_token")) {
                builder.actorTokenProvider((accessToken, refreshToken) -> TypedToken.of(accessToken, actorTokenType.orElse(TypedToken.URN_ACCESS_TOKEN)));
            } else if (actorToken.equalsIgnoreCase("current_refresh_token")) {
                builder.actorTokenProvider((accessToken, refreshToken) -> refreshToken == null ? null : TypedToken.of(refreshToken, actorTokenType.orElse(TypedToken.URN_REFRESH_TOKEN)));
            } else {
                builder.actorToken(TypedToken.of(actorToken, actorTokenType.orElse(TypedToken.URN_ACCESS_TOKEN)));
            }
        }
        return builder.build();
    }

    @Value.Default
    default public URI getRequestedTokenType() {
        return TypedToken.URN_ACCESS_TOKEN;
    }

    public Optional<URI> getResource();

    public Optional<String> getAudience();

    @Value.Default
    @Value.Auxiliary
    default public BiFunction<AccessToken, RefreshToken, TypedToken> getSubjectTokenProvider() {
        return (accessToken, refreshToken) -> TypedToken.of(accessToken);
    }

    @Value.Default
    @Value.Auxiliary
    default public BiFunction<AccessToken, RefreshToken, TypedToken> getActorTokenProvider() {
        return (accessToken, refreshToken) -> null;
    }

    public static Builder builder() {
        return ImmutableTokenExchangeConfig.builder();
    }

    public static interface Builder {
        @CanIgnoreReturnValue
        public Builder requestedTokenType(URI var1);

        @CanIgnoreReturnValue
        public Builder resource(URI var1);

        @CanIgnoreReturnValue
        public Builder audience(String var1);

        @CanIgnoreReturnValue
        public Builder subjectTokenProvider(BiFunction<AccessToken, RefreshToken, TypedToken> var1);

        @CanIgnoreReturnValue
        public Builder actorTokenProvider(BiFunction<AccessToken, RefreshToken, TypedToken> var1);

        @CanIgnoreReturnValue
        default public Builder subjectToken(TypedToken token) {
            return this.subjectTokenProvider((accessToken, refreshToken) -> token);
        }

        @CanIgnoreReturnValue
        default public Builder actorToken(TypedToken token) {
            return this.actorTokenProvider((accessToken, refreshToken) -> token);
        }

        public TokenExchangeConfig build();
    }
}

