/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.IOException;
import java.util.List;
import org.apache.iceberg.BaseAllMetadataTableScan;
import org.apache.iceberg.BaseFileScanTask;
import org.apache.iceberg.BaseMetadataTable;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.DataTask;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.GenericManifestFile;
import org.apache.iceberg.GenericPartitionFieldSummary;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestsTable;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.StaticDataTask;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.TableScanContext;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.avro.AvroIterable;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.ResidualEvaluator;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.types.Types;

public class AllManifestsTable
extends BaseMetadataTable {
    private static final Schema MANIFEST_FILE_SCHEMA = new Schema(Types.NestedField.required(1, "path", Types.StringType.get()), Types.NestedField.required(2, "length", Types.LongType.get()), Types.NestedField.optional(3, "partition_spec_id", Types.IntegerType.get()), Types.NestedField.optional(4, "added_snapshot_id", Types.LongType.get()), Types.NestedField.optional(5, "added_data_files_count", Types.IntegerType.get()), Types.NestedField.optional(6, "existing_data_files_count", Types.IntegerType.get()), Types.NestedField.optional(7, "deleted_data_files_count", Types.IntegerType.get()), Types.NestedField.optional(8, "partition_summaries", Types.ListType.ofRequired(9, Types.StructType.of(Types.NestedField.required(10, "contains_null", Types.BooleanType.get()), Types.NestedField.optional(11, "lower_bound", Types.StringType.get()), Types.NestedField.optional(12, "upper_bound", Types.StringType.get())))));
    private final TableOperations ops;
    private final Table table;
    private final String name;

    AllManifestsTable(TableOperations ops, Table table) {
        this(ops, table, table.name() + ".all_manifests");
    }

    AllManifestsTable(TableOperations ops, Table table, String name) {
        this.ops = ops;
        this.table = table;
        this.name = name;
    }

    @Override
    Table table() {
        return this.table;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public TableScan newScan() {
        return new AllManifestsTableScan(this.ops, this.table, MANIFEST_FILE_SCHEMA);
    }

    @Override
    public Schema schema() {
        return MANIFEST_FILE_SCHEMA;
    }

    static class ManifestListReadTask
    implements DataTask {
        private final FileIO io;
        private final PartitionSpec spec;
        private final FileScanTask manifestListTask;

        ManifestListReadTask(FileIO io, PartitionSpec spec, FileScanTask manifestListTask) {
            this.io = io;
            this.spec = spec;
            this.manifestListTask = manifestListTask;
        }

        @Override
        public List<DeleteFile> deletes() {
            return this.manifestListTask.deletes();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public CloseableIterable<StructLike> rows() {
            try (AvroIterable manifests = Avro.read(this.io.newInputFile(this.manifestListTask.file().path().toString())).rename("manifest_file", GenericManifestFile.class.getName()).rename("partitions", GenericPartitionFieldSummary.class.getName()).rename("r508", GenericPartitionFieldSummary.class.getName()).project(ManifestFile.schema()).classLoader(GenericManifestFile.class.getClassLoader()).reuseContainers(false).build();){
                CloseableIterable<StructLike> closeableIterable = CloseableIterable.transform(manifests, manifest -> ManifestsTable.manifestFileToRow(this.spec, manifest));
                return closeableIterable;
            }
            catch (IOException e) {
                throw new RuntimeIOException(e, "Cannot read manifest list file: %s", this.manifestListTask.file().path());
            }
        }

        @Override
        public DataFile file() {
            return this.manifestListTask.file();
        }

        @Override
        public PartitionSpec spec() {
            return this.manifestListTask.spec();
        }

        @Override
        public long start() {
            return 0L;
        }

        @Override
        public long length() {
            return this.manifestListTask.length();
        }

        @Override
        public Expression residual() {
            return this.manifestListTask.residual();
        }

        @Override
        public Iterable<FileScanTask> split(long splitSize) {
            return ImmutableList.of(this);
        }
    }

    public static class AllManifestsTableScan
    extends BaseAllMetadataTableScan {
        AllManifestsTableScan(TableOperations ops, Table table, Schema fileSchema) {
            super(ops, table, fileSchema);
        }

        private AllManifestsTableScan(TableOperations ops, Table table, Schema schema, TableScanContext context) {
            super(ops, table, schema, context);
        }

        @Override
        protected TableScan newRefinedScan(TableOperations ops, Table table, Schema schema, TableScanContext context) {
            return new AllManifestsTableScan(ops, table, schema, context);
        }

        @Override
        public TableScan useSnapshot(long scanSnapshotId) {
            throw new UnsupportedOperationException("Cannot select snapshot: all_manifests is for all snapshots");
        }

        @Override
        public TableScan asOfTime(long timestampMillis) {
            throw new UnsupportedOperationException("Cannot select snapshot: all_manifests is for all snapshots");
        }

        @Override
        protected long targetSplitSize(TableOperations ops) {
            return ops.current().propertyAsLong("read.split.metadata-target-size", 0x2000000L);
        }

        @Override
        protected CloseableIterable<FileScanTask> planFiles(TableOperations ops, Snapshot snapshot, Expression rowFilter, boolean ignoreResiduals, boolean caseSensitive, boolean colStats) {
            String schemaString = SchemaParser.toJson(this.schema());
            String specString = PartitionSpecParser.toJson(PartitionSpec.unpartitioned());
            return CloseableIterable.withNoopClose(Iterables.transform(ops.current().snapshots(), snap -> {
                if (snap.manifestListLocation() != null) {
                    Expression filter = ignoreResiduals ? Expressions.alwaysTrue() : rowFilter;
                    ResidualEvaluator residuals = ResidualEvaluator.unpartitioned(filter);
                    DataFile manifestListAsDataFile = DataFiles.builder(PartitionSpec.unpartitioned()).withInputFile(ops.io().newInputFile(snap.manifestListLocation())).withRecordCount(1L).withFormat(FileFormat.AVRO).build();
                    return new ManifestListReadTask(ops.io(), this.table().spec(), new BaseFileScanTask(manifestListAsDataFile, null, schemaString, specString, residuals));
                }
                return StaticDataTask.of(ops.io().newInputFile(ops.current().metadataFileLocation()), snap.allManifests(), manifest -> ManifestsTable.manifestFileToRow(this.table().spec(), manifest));
            }));
        }
    }
}

