/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.ManifestReader;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.MapMaker;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.util.Tasks;
import org.apache.iceberg.util.ThreadPools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogUtil {
    private static final Logger LOG = LoggerFactory.getLogger(CatalogUtil.class);

    private CatalogUtil() {
    }

    public static void dropTableData(FileIO io, TableMetadata metadata) {
        HashSet<String> manifestListsToDelete = Sets.newHashSet();
        HashSet<ManifestFile> manifestsToDelete = Sets.newHashSet();
        for (Snapshot snapshot : metadata.snapshots()) {
            Iterables.addAll(manifestsToDelete, snapshot.allManifests());
            if (snapshot.manifestListLocation() == null) continue;
            manifestListsToDelete.add(snapshot.manifestListLocation());
        }
        LOG.info("Manifests to delete: {}", (Object)Joiner.on(", ").join(manifestsToDelete));
        CatalogUtil.deleteFiles(io, manifestsToDelete);
        Tasks.foreach(Iterables.transform(manifestsToDelete, ManifestFile::path)).noRetry().suppressFailureWhenFinished().onFailure((manifest, exc) -> LOG.warn("Delete failed for manifest: {}", manifest, (Object)exc)).run(io::deleteFile);
        Tasks.foreach(manifestListsToDelete).noRetry().suppressFailureWhenFinished().onFailure((list, exc) -> LOG.warn("Delete failed for manifest list: {}", list, (Object)exc)).run(io::deleteFile);
        Tasks.foreach(metadata.metadataFileLocation()).noRetry().suppressFailureWhenFinished().onFailure((list, exc) -> LOG.warn("Delete failed for metadata file: {}", list, (Object)exc)).run(io::deleteFile);
    }

    private static void deleteFiles(FileIO io, Set<ManifestFile> allManifests) {
        ConcurrentMap deletedFiles = new MapMaker().concurrencyLevel(ThreadPools.WORKER_THREAD_POOL_SIZE).weakKeys().makeMap();
        Tasks.foreach(allManifests).noRetry().suppressFailureWhenFinished().executeWith(ThreadPools.getWorkerPool()).onFailure((item, exc) -> LOG.warn("Failed to get deleted files: this may cause orphaned data files", (Throwable)exc)).run(manifest -> {
            try (ManifestReader<?> reader = ManifestFiles.open(manifest, io);){
                for (ManifestEntry manifestEntry : reader.entries()) {
                    String path = manifestEntry.file().path().toString().intern();
                    Boolean alreadyDeleted = deletedFiles.putIfAbsent(path, true);
                    if (alreadyDeleted != null && alreadyDeleted.booleanValue()) continue;
                    try {
                        io.deleteFile(path);
                    }
                    catch (RuntimeException e) {
                        LOG.warn("Delete failed for data file: {}", (Object)path, (Object)e);
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeIOException(e, "Failed to read manifest file: %s", manifest.path());
            }
        });
    }
}

