/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.apache.iceberg.HistoryEntry;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SortField;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Objects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableCollection;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.util.PropertyUtil;

public class TableMetadata
implements Serializable {
    static final long INITIAL_SEQUENCE_NUMBER = 0L;
    static final int DEFAULT_TABLE_FORMAT_VERSION = 1;
    static final int SUPPORTED_TABLE_FORMAT_VERSION = 2;
    static final int INITIAL_SPEC_ID = 0;
    static final int INITIAL_SORT_ORDER_ID = 1;
    private static final long ONE_MINUTE = TimeUnit.MINUTES.toMillis(1L);
    private final transient InputFile file;
    private final String metadataFileLocation;
    private final int formatVersion;
    private final String uuid;
    private final String location;
    private final long lastSequenceNumber;
    private final long lastUpdatedMillis;
    private final int lastColumnId;
    private final Schema schema;
    private final int defaultSpecId;
    private final List<PartitionSpec> specs;
    private final int defaultSortOrderId;
    private final List<SortOrder> sortOrders;
    private final Map<String, String> properties;
    private final long currentSnapshotId;
    private final List<Snapshot> snapshots;
    private final Map<Long, Snapshot> snapshotsById;
    private final Map<Integer, PartitionSpec> specsById;
    private final Map<Integer, SortOrder> sortOrdersById;
    private final List<HistoryEntry> snapshotLog;
    private final List<MetadataLogEntry> previousFiles;

    @Deprecated
    public static TableMetadata newTableMetadata(TableOperations ops, Schema schema, PartitionSpec spec, String location, Map<String, String> properties) {
        return TableMetadata.newTableMetadata(schema, spec, SortOrder.unsorted(), location, properties, 1);
    }

    public static TableMetadata newTableMetadata(Schema schema, PartitionSpec spec, SortOrder sortOrder, String location, Map<String, String> properties) {
        return TableMetadata.newTableMetadata(schema, spec, sortOrder, location, properties, 1);
    }

    public static TableMetadata newTableMetadata(Schema schema, PartitionSpec spec, String location, Map<String, String> properties) {
        return TableMetadata.newTableMetadata(schema, spec, SortOrder.unsorted(), location, properties, 1);
    }

    static TableMetadata newTableMetadata(Schema schema, PartitionSpec spec, SortOrder sortOrder, String location, Map<String, String> properties, int formatVersion) {
        AtomicInteger lastColumnId = new AtomicInteger(0);
        Schema freshSchema = TypeUtil.assignFreshIds(schema, lastColumnId::incrementAndGet);
        PartitionSpec.Builder specBuilder = PartitionSpec.builderFor(freshSchema).withSpecId(0);
        for (PartitionField field : spec.fields()) {
            String sourceName = schema.findColumnName(field.sourceId());
            specBuilder.add(freshSchema.findField(sourceName).fieldId(), field.name(), field.transform().toString());
        }
        PartitionSpec freshSpec = specBuilder.build();
        int freshSortOrderId = sortOrder.isUnsorted() ? sortOrder.orderId() : 1;
        SortOrder freshSortOrder = TableMetadata.freshSortOrder(freshSortOrderId, freshSchema, sortOrder);
        return new TableMetadata(null, formatVersion, UUID.randomUUID().toString(), location, 0L, System.currentTimeMillis(), lastColumnId.get(), freshSchema, 0, ImmutableList.of(freshSpec), freshSortOrderId, ImmutableList.of(freshSortOrder), ImmutableMap.copyOf(properties), -1L, ImmutableList.of(), ImmutableList.of(), ImmutableList.of());
    }

    TableMetadata(InputFile file, int formatVersion, String uuid, String location, long lastSequenceNumber, long lastUpdatedMillis, int lastColumnId, Schema schema, int defaultSpecId, List<PartitionSpec> specs, int defaultSortOrderId, List<SortOrder> sortOrders, Map<String, String> properties, long currentSnapshotId, List<Snapshot> snapshots, List<HistoryEntry> snapshotLog, List<MetadataLogEntry> previousFiles) {
        Preconditions.checkArgument(specs != null && !specs.isEmpty(), "Partition specs cannot be null or empty");
        Preconditions.checkArgument(sortOrders != null && !sortOrders.isEmpty(), "Sort orders cannot be null or empty");
        Preconditions.checkArgument(formatVersion <= 2, "Unsupported format version: v%s", formatVersion);
        Preconditions.checkArgument(formatVersion == 1 || uuid != null, "UUID is required in format v%s", formatVersion);
        Preconditions.checkArgument(formatVersion > 1 || lastSequenceNumber == 0L, "Sequence number must be 0 in v1: %s", lastSequenceNumber);
        this.formatVersion = formatVersion;
        this.file = file;
        this.metadataFileLocation = file != null ? file.location() : null;
        this.uuid = uuid;
        this.location = location;
        this.lastSequenceNumber = lastSequenceNumber;
        this.lastUpdatedMillis = lastUpdatedMillis;
        this.lastColumnId = lastColumnId;
        this.schema = schema;
        this.specs = specs;
        this.defaultSpecId = defaultSpecId;
        this.defaultSortOrderId = defaultSortOrderId;
        this.sortOrders = sortOrders;
        this.properties = properties;
        this.currentSnapshotId = currentSnapshotId;
        this.snapshots = snapshots;
        this.snapshotLog = snapshotLog;
        this.previousFiles = previousFiles;
        this.snapshotsById = TableMetadata.indexAndValidateSnapshots(snapshots, lastSequenceNumber);
        this.specsById = TableMetadata.indexSpecs(specs);
        this.sortOrdersById = TableMetadata.indexSortOrders(sortOrders);
        HistoryEntry last = null;
        for (HistoryEntry logEntry : snapshotLog) {
            if (last != null) {
                Preconditions.checkArgument(logEntry.timestampMillis() - last.timestampMillis() >= -ONE_MINUTE, "[BUG] Expected sorted snapshot log entries.");
            }
            last = logEntry;
        }
        if (last != null) {
            Preconditions.checkArgument(lastUpdatedMillis - last.timestampMillis() >= -ONE_MINUTE, "Invalid update timestamp %s: before last snapshot log entry at %s", lastUpdatedMillis, last.timestampMillis());
        }
        MetadataLogEntry previous = null;
        for (MetadataLogEntry metadataEntry : previousFiles) {
            if (previous != null) {
                Preconditions.checkArgument(metadataEntry.timestampMillis() - previous.timestampMillis() >= -ONE_MINUTE, "[BUG] Expected sorted previous metadata log entries.");
            }
            previous = metadataEntry;
        }
        if (previous != null) {
            Preconditions.checkArgument(lastUpdatedMillis - previous.timestampMillis >= -ONE_MINUTE, "Invalid update timestamp %s: before the latest metadata log entry timestamp %s", lastUpdatedMillis, previous.timestampMillis);
        }
        Preconditions.checkArgument(currentSnapshotId < 0L || this.snapshotsById.containsKey(currentSnapshotId), "Invalid table metadata: Cannot find current version");
    }

    public int formatVersion() {
        return this.formatVersion;
    }

    public String metadataFileLocation() {
        return this.metadataFileLocation;
    }

    public String uuid() {
        return this.uuid;
    }

    public long lastSequenceNumber() {
        return this.lastSequenceNumber;
    }

    public long nextSequenceNumber() {
        return this.formatVersion > 1 ? this.lastSequenceNumber + 1L : 0L;
    }

    public long lastUpdatedMillis() {
        return this.lastUpdatedMillis;
    }

    public int lastColumnId() {
        return this.lastColumnId;
    }

    public Schema schema() {
        return this.schema;
    }

    public PartitionSpec spec() {
        return this.specsById.get(this.defaultSpecId);
    }

    public PartitionSpec spec(int id) {
        return this.specsById.get(id);
    }

    public List<PartitionSpec> specs() {
        return this.specs;
    }

    public Map<Integer, PartitionSpec> specsById() {
        return this.specsById;
    }

    public int defaultSpecId() {
        return this.defaultSpecId;
    }

    public int defaultSortOrderId() {
        return this.defaultSortOrderId;
    }

    public SortOrder sortOrder() {
        return this.sortOrdersById.get(this.defaultSortOrderId);
    }

    public List<SortOrder> sortOrders() {
        return this.sortOrders;
    }

    public Map<Integer, SortOrder> sortOrdersById() {
        return this.sortOrdersById;
    }

    public String location() {
        return this.location;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public String property(String property, String defaultValue) {
        return this.properties.getOrDefault(property, defaultValue);
    }

    public boolean propertyAsBoolean(String property, boolean defaultValue) {
        return PropertyUtil.propertyAsBoolean(this.properties, property, defaultValue);
    }

    public int propertyAsInt(String property, int defaultValue) {
        return PropertyUtil.propertyAsInt(this.properties, property, defaultValue);
    }

    public long propertyAsLong(String property, long defaultValue) {
        return PropertyUtil.propertyAsLong(this.properties, property, defaultValue);
    }

    public Snapshot snapshot(long snapshotId) {
        return this.snapshotsById.get(snapshotId);
    }

    public Snapshot currentSnapshot() {
        return this.snapshotsById.get(this.currentSnapshotId);
    }

    public List<Snapshot> snapshots() {
        return this.snapshots;
    }

    public List<HistoryEntry> snapshotLog() {
        return this.snapshotLog;
    }

    public List<MetadataLogEntry> previousFiles() {
        return this.previousFiles;
    }

    public TableMetadata withUUID() {
        if (this.uuid != null) {
            return this;
        }
        return new TableMetadata(null, this.formatVersion, UUID.randomUUID().toString(), this.location, this.lastSequenceNumber, this.lastUpdatedMillis, this.lastColumnId, this.schema, this.defaultSpecId, this.specs, this.defaultSortOrderId, this.sortOrders, this.properties, this.currentSnapshotId, this.snapshots, this.snapshotLog, this.addPreviousFile(this.file, this.lastUpdatedMillis));
    }

    public TableMetadata updateSchema(Schema newSchema, int newLastColumnId) {
        PartitionSpec.checkCompatibility(this.spec(), newSchema);
        SortOrder.checkCompatibility(this.sortOrder(), newSchema);
        List<PartitionSpec> updatedSpecs = Lists.transform(this.specs, spec -> TableMetadata.updateSpecSchema(newSchema, spec));
        List<SortOrder> updatedSortOrders = Lists.transform(this.sortOrders, order -> TableMetadata.updateSortOrderSchema(newSchema, order));
        return new TableMetadata(null, this.formatVersion, this.uuid, this.location, this.lastSequenceNumber, System.currentTimeMillis(), newLastColumnId, newSchema, this.defaultSpecId, updatedSpecs, this.defaultSortOrderId, updatedSortOrders, this.properties, this.currentSnapshotId, this.snapshots, this.snapshotLog, this.addPreviousFile(this.file, this.lastUpdatedMillis));
    }

    public TableMetadata updatePartitionSpec(PartitionSpec newPartitionSpec) {
        PartitionSpec.checkCompatibility(newPartitionSpec, this.schema);
        ValidationException.check(this.formatVersion > 1 || PartitionSpec.hasSequentialIds(newPartitionSpec), "Spec does not use sequential IDs that are required in v1: %s", newPartitionSpec);
        int newDefaultSpecId = 0;
        for (PartitionSpec spec : this.specs) {
            if (newPartitionSpec.compatibleWith(spec)) {
                newDefaultSpecId = spec.specId();
                break;
            }
            if (newDefaultSpecId > spec.specId()) continue;
            newDefaultSpecId = spec.specId() + 1;
        }
        Preconditions.checkArgument(this.defaultSpecId != newDefaultSpecId, "Cannot set default partition spec to the current default");
        ImmutableCollection.Builder builder = ImmutableList.builder().addAll(this.specs);
        if (!this.specsById.containsKey(newDefaultSpecId)) {
            ((ImmutableList.Builder)builder).add(TableMetadata.freshSpec(newDefaultSpecId, this.schema, newPartitionSpec));
        }
        return new TableMetadata(null, this.formatVersion, this.uuid, this.location, this.lastSequenceNumber, System.currentTimeMillis(), this.lastColumnId, this.schema, newDefaultSpecId, (List<PartitionSpec>)((Object)((ImmutableList.Builder)builder).build()), this.defaultSortOrderId, this.sortOrders, this.properties, this.currentSnapshotId, this.snapshots, this.snapshotLog, this.addPreviousFile(this.file, this.lastUpdatedMillis));
    }

    public TableMetadata updateSortOrder(SortOrder newOrder) {
        SortOrder.checkCompatibility(newOrder, this.schema);
        int newOrderId = 1;
        for (SortOrder order : this.sortOrders) {
            if (order.sameOrder(newOrder)) {
                newOrderId = order.orderId();
                break;
            }
            if (newOrderId > order.orderId()) continue;
            newOrderId = order.orderId() + 1;
        }
        if (newOrderId == this.defaultSortOrderId) {
            return this;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(this.sortOrders);
        if (!this.sortOrdersById.containsKey(newOrderId)) {
            if (newOrder.isUnsorted()) {
                newOrderId = SortOrder.unsorted().orderId();
                builder.add(SortOrder.unsorted());
            } else {
                builder.add(TableMetadata.freshSortOrder(newOrderId, this.schema, newOrder));
            }
        }
        return new TableMetadata(null, this.formatVersion, this.uuid, this.location, this.lastSequenceNumber, System.currentTimeMillis(), this.lastColumnId, this.schema, this.defaultSpecId, this.specs, newOrderId, (List<SortOrder>)((Object)builder.build()), this.properties, this.currentSnapshotId, this.snapshots, this.snapshotLog, this.addPreviousFile(this.file, this.lastUpdatedMillis));
    }

    public TableMetadata addStagedSnapshot(Snapshot snapshot) {
        ValidationException.check(this.formatVersion == 1 || snapshot.sequenceNumber() > this.lastSequenceNumber, "Cannot add snapshot with sequence number %s older than last sequence number %s", snapshot.sequenceNumber(), this.lastSequenceNumber);
        ImmutableCollection newSnapshots = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.snapshots)).add(snapshot)).build();
        return new TableMetadata(null, this.formatVersion, this.uuid, this.location, snapshot.sequenceNumber(), snapshot.timestampMillis(), this.lastColumnId, this.schema, this.defaultSpecId, this.specs, this.defaultSortOrderId, this.sortOrders, this.properties, this.currentSnapshotId, (List<Snapshot>)((Object)newSnapshots), this.snapshotLog, this.addPreviousFile(this.file, this.lastUpdatedMillis));
    }

    public TableMetadata replaceCurrentSnapshot(Snapshot snapshot) {
        if (this.snapshotsById.containsKey(snapshot.snapshotId())) {
            return this.setCurrentSnapshotTo(snapshot);
        }
        ValidationException.check(this.formatVersion == 1 || snapshot.sequenceNumber() > this.lastSequenceNumber, "Cannot add snapshot with sequence number %s older than last sequence number %s", snapshot.sequenceNumber(), this.lastSequenceNumber);
        ImmutableCollection newSnapshots = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.snapshots)).add(snapshot)).build();
        ImmutableCollection newSnapshotLog = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.snapshotLog)).add(new SnapshotLogEntry(snapshot.timestampMillis(), snapshot.snapshotId()))).build();
        return new TableMetadata(null, this.formatVersion, this.uuid, this.location, snapshot.sequenceNumber(), snapshot.timestampMillis(), this.lastColumnId, this.schema, this.defaultSpecId, this.specs, this.defaultSortOrderId, this.sortOrders, this.properties, snapshot.snapshotId(), (List<Snapshot>)((Object)newSnapshots), (List<HistoryEntry>)((Object)newSnapshotLog), this.addPreviousFile(this.file, this.lastUpdatedMillis));
    }

    public TableMetadata removeSnapshotsIf(Predicate<Snapshot> removeIf) {
        ArrayList<Snapshot> filtered = Lists.newArrayListWithExpectedSize(this.snapshots.size());
        for (Snapshot snapshot : this.snapshots) {
            if (snapshot.snapshotId() != this.currentSnapshotId && removeIf.test(snapshot)) continue;
            filtered.add(snapshot);
        }
        HashSet validIds = Sets.newHashSet(Iterables.transform(filtered, Snapshot::snapshotId));
        ArrayList<HistoryEntry> newSnapshotLog = Lists.newArrayList();
        for (HistoryEntry logEntry : this.snapshotLog) {
            if (validIds.contains(logEntry.snapshotId())) {
                newSnapshotLog.add(logEntry);
                continue;
            }
            newSnapshotLog.clear();
        }
        return new TableMetadata(null, this.formatVersion, this.uuid, this.location, this.lastSequenceNumber, System.currentTimeMillis(), this.lastColumnId, this.schema, this.defaultSpecId, this.specs, this.defaultSortOrderId, this.sortOrders, this.properties, this.currentSnapshotId, filtered, ImmutableList.copyOf(newSnapshotLog), this.addPreviousFile(this.file, this.lastUpdatedMillis));
    }

    private TableMetadata setCurrentSnapshotTo(Snapshot snapshot) {
        ValidationException.check(this.snapshotsById.containsKey(snapshot.snapshotId()), "Cannot set current snapshot to unknown: %s", snapshot.snapshotId());
        ValidationException.check(this.formatVersion == 1 || snapshot.sequenceNumber() <= this.lastSequenceNumber, "Last sequence number %s is less than existing snapshot sequence number %s", this.lastSequenceNumber, snapshot.sequenceNumber());
        if (this.currentSnapshotId == snapshot.snapshotId()) {
            return this;
        }
        long nowMillis = System.currentTimeMillis();
        ImmutableCollection newSnapshotLog = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.snapshotLog)).add(new SnapshotLogEntry(nowMillis, snapshot.snapshotId()))).build();
        return new TableMetadata(null, this.formatVersion, this.uuid, this.location, this.lastSequenceNumber, nowMillis, this.lastColumnId, this.schema, this.defaultSpecId, this.specs, this.defaultSortOrderId, this.sortOrders, this.properties, snapshot.snapshotId(), this.snapshots, (List<HistoryEntry>)((Object)newSnapshotLog), this.addPreviousFile(this.file, this.lastUpdatedMillis));
    }

    public TableMetadata replaceProperties(Map<String, String> newProperties) {
        ValidationException.check(newProperties != null, "Cannot set properties to null", new Object[0]);
        return new TableMetadata(null, this.formatVersion, this.uuid, this.location, this.lastSequenceNumber, System.currentTimeMillis(), this.lastColumnId, this.schema, this.defaultSpecId, this.specs, this.defaultSortOrderId, this.sortOrders, newProperties, this.currentSnapshotId, this.snapshots, this.snapshotLog, this.addPreviousFile(this.file, this.lastUpdatedMillis, newProperties));
    }

    public TableMetadata removeSnapshotLogEntries(Set<Long> snapshotIds) {
        ArrayList<HistoryEntry> newSnapshotLog = Lists.newArrayList();
        for (HistoryEntry logEntry : this.snapshotLog) {
            if (snapshotIds.contains(logEntry.snapshotId())) continue;
            newSnapshotLog.add(logEntry);
        }
        ValidationException.check(this.currentSnapshotId < 0L || ((HistoryEntry)Iterables.getLast(newSnapshotLog)).snapshotId() == this.currentSnapshotId, "Cannot set invalid snapshot log: latest entry is not the current snapshot", new Object[0]);
        return new TableMetadata(null, this.formatVersion, this.uuid, this.location, this.lastSequenceNumber, System.currentTimeMillis(), this.lastColumnId, this.schema, this.defaultSpecId, this.specs, this.defaultSortOrderId, this.sortOrders, this.properties, this.currentSnapshotId, this.snapshots, newSnapshotLog, this.addPreviousFile(this.file, this.lastUpdatedMillis));
    }

    public TableMetadata buildReplacement(Schema updatedSchema, PartitionSpec updatedPartitionSpec, SortOrder updatedSortOrder, String newLocation, Map<String, String> updatedProperties) {
        OptionalInt maxOrderId;
        ValidationException.check(this.formatVersion > 1 || PartitionSpec.hasSequentialIds(updatedPartitionSpec), "Spec does not use sequential IDs that are required in v1: %s", updatedPartitionSpec);
        AtomicInteger newLastColumnId = new AtomicInteger(this.lastColumnId);
        Schema freshSchema = TypeUtil.assignFreshIds(updatedSchema, this.schema, newLastColumnId::incrementAndGet);
        OptionalInt maxSpecId = this.specs.stream().mapToInt(PartitionSpec::specId).max();
        int nextSpecId = maxSpecId.orElse(0) + 1;
        PartitionSpec freshSpec = TableMetadata.freshSpec(nextSpecId, freshSchema, updatedPartitionSpec);
        int specId = this.specs.stream().filter(freshSpec::compatibleWith).findFirst().map(PartitionSpec::specId).orElse(nextSpecId);
        ImmutableCollection.Builder specListBuilder = ImmutableList.builder().addAll(this.specs);
        if (!this.specsById.containsKey(specId)) {
            ((ImmutableList.Builder)specListBuilder).add(freshSpec);
        }
        int nextOrderId = (maxOrderId = this.sortOrders.stream().mapToInt(SortOrder::orderId).max()).isPresent() ? maxOrderId.getAsInt() + 1 : 1;
        int freshSortOrderId = updatedSortOrder.isUnsorted() ? updatedSortOrder.orderId() : nextOrderId;
        SortOrder freshSortOrder = TableMetadata.freshSortOrder(freshSortOrderId, freshSchema, updatedSortOrder);
        Optional<SortOrder> sameSortOrder = this.sortOrders.stream().filter(sortOrder -> sortOrder.sameOrder(freshSortOrder)).findAny();
        int orderId = sameSortOrder.map(SortOrder::orderId).orElse(freshSortOrderId);
        ImmutableCollection.Builder sortOrdersBuilder = ImmutableList.builder().addAll(this.sortOrders);
        if (!this.sortOrdersById.containsKey(orderId)) {
            ((ImmutableList.Builder)sortOrdersBuilder).add(freshSortOrder);
        }
        HashMap<String, String> newProperties = Maps.newHashMap();
        newProperties.putAll(this.properties);
        newProperties.putAll(updatedProperties);
        return new TableMetadata(null, this.formatVersion, this.uuid, newLocation, this.lastSequenceNumber, System.currentTimeMillis(), newLastColumnId.get(), freshSchema, specId, (List<PartitionSpec>)((Object)((ImmutableList.Builder)specListBuilder).build()), orderId, (List<SortOrder>)((Object)((ImmutableList.Builder)sortOrdersBuilder).build()), ImmutableMap.copyOf(newProperties), -1L, this.snapshots, ImmutableList.of(), this.addPreviousFile(this.file, this.lastUpdatedMillis, newProperties));
    }

    public TableMetadata updateLocation(String newLocation) {
        return new TableMetadata(null, this.formatVersion, this.uuid, newLocation, this.lastSequenceNumber, System.currentTimeMillis(), this.lastColumnId, this.schema, this.defaultSpecId, this.specs, this.defaultSortOrderId, this.sortOrders, this.properties, this.currentSnapshotId, this.snapshots, this.snapshotLog, this.addPreviousFile(this.file, this.lastUpdatedMillis));
    }

    public TableMetadata upgradeToFormatVersion(int newFormatVersion) {
        Preconditions.checkArgument(newFormatVersion <= 2, "Cannot upgrade table to unsupported format version: v%s (supported: v%s)", newFormatVersion, 2);
        Preconditions.checkArgument(newFormatVersion >= this.formatVersion, "Cannot downgrade v%s table to v%s", this.formatVersion, newFormatVersion);
        if (newFormatVersion == this.formatVersion) {
            return this;
        }
        return new TableMetadata(null, newFormatVersion, this.uuid, this.location, this.lastSequenceNumber, System.currentTimeMillis(), this.lastColumnId, this.schema, this.defaultSpecId, this.specs, this.defaultSortOrderId, this.sortOrders, this.properties, this.currentSnapshotId, this.snapshots, this.snapshotLog, this.addPreviousFile(this.file, this.lastUpdatedMillis));
    }

    private List<MetadataLogEntry> addPreviousFile(InputFile previousFile, long timestampMillis) {
        return this.addPreviousFile(previousFile, timestampMillis, this.properties);
    }

    private List<MetadataLogEntry> addPreviousFile(InputFile previousFile, long timestampMillis, Map<String, String> updatedProperties) {
        ArrayList<MetadataLogEntry> newMetadataLog;
        if (previousFile == null) {
            return this.previousFiles;
        }
        int maxSize = Math.max(1, PropertyUtil.propertyAsInt(updatedProperties, "write.metadata.previous-versions-max", 100));
        if (this.previousFiles.size() >= maxSize) {
            int removeIndex = this.previousFiles.size() - maxSize + 1;
            newMetadataLog = Lists.newArrayList(this.previousFiles.subList(removeIndex, this.previousFiles.size()));
        } else {
            newMetadataLog = Lists.newArrayList(this.previousFiles);
        }
        newMetadataLog.add(new MetadataLogEntry(timestampMillis, previousFile.location()));
        return newMetadataLog;
    }

    private static PartitionSpec updateSpecSchema(Schema schema, PartitionSpec partitionSpec) {
        PartitionSpec.Builder specBuilder = PartitionSpec.builderFor(schema).withSpecId(partitionSpec.specId());
        for (PartitionField field : partitionSpec.fields()) {
            specBuilder.add(field.sourceId(), field.fieldId(), field.name(), field.transform().toString());
        }
        return specBuilder.build();
    }

    private static SortOrder updateSortOrderSchema(Schema schema, SortOrder sortOrder) {
        SortOrder.Builder builder = SortOrder.builderFor(schema).withOrderId(sortOrder.orderId());
        for (SortField field : sortOrder.fields()) {
            builder.addSortField(field.transform().toString(), field.sourceId(), field.direction(), field.nullOrder());
        }
        return builder.build();
    }

    private static PartitionSpec freshSpec(int specId, Schema schema, PartitionSpec partitionSpec) {
        PartitionSpec.Builder specBuilder = PartitionSpec.builderFor(schema).withSpecId(specId);
        for (PartitionField field : partitionSpec.fields()) {
            String sourceName = partitionSpec.schema().findColumnName(field.sourceId());
            specBuilder.add(schema.findField(sourceName).fieldId(), field.fieldId(), field.name(), field.transform().toString());
        }
        return specBuilder.build();
    }

    private static SortOrder freshSortOrder(int orderId, Schema schema, SortOrder sortOrder) {
        SortOrder.Builder builder = SortOrder.builderFor(schema).withOrderId(orderId);
        for (SortField field : sortOrder.fields()) {
            String sourceName = sortOrder.schema().findColumnName(field.sourceId());
            int newSourceId = schema.findField(sourceName).fieldId();
            builder.addSortField(field.transform().toString(), newSourceId, field.direction(), field.nullOrder());
        }
        return builder.build();
    }

    private static Map<Long, Snapshot> indexAndValidateSnapshots(List<Snapshot> snapshots, long lastSequenceNumber) {
        ImmutableMap.Builder<Long, Snapshot> builder = ImmutableMap.builder();
        for (Snapshot snap : snapshots) {
            ValidationException.check(snap.sequenceNumber() <= lastSequenceNumber, "Invalid snapshot with sequence number %s greater than last sequence number %s", snap.sequenceNumber(), lastSequenceNumber);
            builder.put(snap.snapshotId(), snap);
        }
        return builder.build();
    }

    private static Map<Integer, PartitionSpec> indexSpecs(List<PartitionSpec> specs) {
        ImmutableMap.Builder<Integer, PartitionSpec> builder = ImmutableMap.builder();
        for (PartitionSpec spec : specs) {
            builder.put(spec.specId(), spec);
        }
        return builder.build();
    }

    private static Map<Integer, SortOrder> indexSortOrders(List<SortOrder> sortOrders) {
        ImmutableMap.Builder<Integer, SortOrder> builder = ImmutableMap.builder();
        for (SortOrder sortOrder : sortOrders) {
            builder.put(sortOrder.orderId(), sortOrder);
        }
        return builder.build();
    }

    public static class MetadataLogEntry {
        private final long timestampMillis;
        private final String file;

        MetadataLogEntry(long timestampMillis, String file) {
            this.timestampMillis = timestampMillis;
            this.file = file;
        }

        public long timestampMillis() {
            return this.timestampMillis;
        }

        public String file() {
            return this.file;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MetadataLogEntry)) {
                return false;
            }
            MetadataLogEntry that = (MetadataLogEntry)other;
            return this.timestampMillis == that.timestampMillis && java.util.Objects.equals(this.file, that.file);
        }

        public int hashCode() {
            return Objects.hashCode(this.timestampMillis, this.file);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("timestampMillis", this.timestampMillis).add("file", this.file).toString();
        }
    }

    public static class SnapshotLogEntry
    implements HistoryEntry {
        private final long timestampMillis;
        private final long snapshotId;

        SnapshotLogEntry(long timestampMillis, long snapshotId) {
            this.timestampMillis = timestampMillis;
            this.snapshotId = snapshotId;
        }

        @Override
        public long timestampMillis() {
            return this.timestampMillis;
        }

        @Override
        public long snapshotId() {
            return this.snapshotId;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SnapshotLogEntry)) {
                return false;
            }
            SnapshotLogEntry that = (SnapshotLogEntry)other;
            return this.timestampMillis == that.timestampMillis && this.snapshotId == that.snapshotId;
        }

        public int hashCode() {
            return Objects.hashCode(this.timestampMillis, this.snapshotId);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("timestampMillis", this.timestampMillis).add("snapshotId", this.snapshotId).toString();
        }
    }
}

