/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.avro.AvroFileAppender;
import org.apache.iceberg.avro.AvroIterable;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.avro.GenericAvroReader;
import org.apache.iceberg.avro.GenericAvroWriter;
import org.apache.iceberg.avro.LogicalMap;
import org.apache.iceberg.avro.ProjectionDatumReader;
import org.apache.iceberg.avro.UUIDConversion;
import org.apache.iceberg.avro.ValueWriter;
import org.apache.iceberg.avro.ValueWriters;
import org.apache.iceberg.deletes.EqualityDeleteWriter;
import org.apache.iceberg.deletes.PositionDelete;
import org.apache.iceberg.deletes.PositionDeleteWriter;
import org.apache.iceberg.encryption.EncryptionKeyMetadata;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.mapping.NameMapping;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.shaded.org.apache.avro.Conversions;
import org.apache.iceberg.shaded.org.apache.avro.LogicalTypes;
import org.apache.iceberg.shaded.org.apache.avro.Schema;
import org.apache.iceberg.shaded.org.apache.avro.file.CodecFactory;
import org.apache.iceberg.shaded.org.apache.avro.generic.GenericData;
import org.apache.iceberg.shaded.org.apache.avro.io.DatumReader;
import org.apache.iceberg.shaded.org.apache.avro.io.DatumWriter;
import org.apache.iceberg.shaded.org.apache.avro.io.Encoder;
import org.apache.iceberg.shaded.org.apache.avro.specific.SpecificData;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.ArrayUtil;

public class Avro {
    private static final GenericData DEFAULT_MODEL = new SpecificData();

    private Avro() {
    }

    public static WriteBuilder write(OutputFile file) {
        return new WriteBuilder(file);
    }

    public static DeleteWriteBuilder writeDeletes(OutputFile file) {
        return new DeleteWriteBuilder(file);
    }

    public static ReadBuilder read(InputFile file) {
        return new ReadBuilder(file);
    }

    static {
        LogicalTypes.register("map", schema -> LogicalMap.get());
        DEFAULT_MODEL.addLogicalTypeConversion(new Conversions.DecimalConversion());
        DEFAULT_MODEL.addLogicalTypeConversion(new UUIDConversion());
    }

    public static class ReadBuilder {
        private final InputFile file;
        private final Map<String, String> renames = Maps.newLinkedHashMap();
        private ClassLoader loader = Thread.currentThread().getContextClassLoader();
        private NameMapping nameMapping;
        private boolean reuseContainers = false;
        private Schema schema = null;
        private Function<org.apache.iceberg.shaded.org.apache.avro.Schema, DatumReader<?>> createReaderFunc = null;
        private BiFunction<Schema, org.apache.iceberg.shaded.org.apache.avro.Schema, DatumReader<?>> createReaderBiFunc = null;
        private final Function<org.apache.iceberg.shaded.org.apache.avro.Schema, DatumReader<?>> defaultCreateReaderFunc = readSchema -> {
            GenericAvroReader reader = new GenericAvroReader((org.apache.iceberg.shaded.org.apache.avro.Schema)readSchema);
            reader.setClassLoader(this.loader);
            return reader;
        };
        private Long start = null;
        private Long length = null;

        private ReadBuilder(InputFile file) {
            Preconditions.checkNotNull(file, "Input file cannot be null");
            this.file = file;
        }

        public ReadBuilder createReaderFunc(Function<org.apache.iceberg.shaded.org.apache.avro.Schema, DatumReader<?>> readerFunction) {
            Preconditions.checkState(this.createReaderBiFunc == null, "Cannot set multiple createReaderFunc");
            this.createReaderFunc = readerFunction;
            return this;
        }

        public ReadBuilder createReaderFunc(BiFunction<Schema, org.apache.iceberg.shaded.org.apache.avro.Schema, DatumReader<?>> readerFunction) {
            Preconditions.checkState(this.createReaderFunc == null, "Cannot set multiple createReaderFunc");
            this.createReaderBiFunc = readerFunction;
            return this;
        }

        public ReadBuilder split(long newStart, long newLength) {
            this.start = newStart;
            this.length = newLength;
            return this;
        }

        public ReadBuilder project(Schema projectedSchema) {
            this.schema = projectedSchema;
            return this;
        }

        public ReadBuilder reuseContainers() {
            this.reuseContainers = true;
            return this;
        }

        public ReadBuilder reuseContainers(boolean shouldReuse) {
            this.reuseContainers = shouldReuse;
            return this;
        }

        public ReadBuilder rename(String fullName, String newName) {
            this.renames.put(fullName, newName);
            return this;
        }

        public ReadBuilder withNameMapping(NameMapping newNameMapping) {
            this.nameMapping = newNameMapping;
            return this;
        }

        public ReadBuilder classLoader(ClassLoader classLoader) {
            this.loader = classLoader;
            return this;
        }

        public <D> AvroIterable<D> build() {
            Preconditions.checkNotNull(this.schema, "Schema is required");
            Function<org.apache.iceberg.shaded.org.apache.avro.Schema, DatumReader<?>> readerFunc = this.createReaderBiFunc != null ? avroSchema -> this.createReaderBiFunc.apply(this.schema, (org.apache.iceberg.shaded.org.apache.avro.Schema)avroSchema) : (this.createReaderFunc != null ? this.createReaderFunc : this.defaultCreateReaderFunc);
            return new AvroIterable(this.file, new ProjectionDatumReader(readerFunc, this.schema, this.renames, this.nameMapping), this.start, this.length, this.reuseContainers);
        }
    }

    private static class PositionAndRowDatumWriter<D>
    implements DatumWriter<PositionDelete<D>> {
        private static final ValueWriter<Object> PATH_WRITER = ValueWriters.strings();
        private static final ValueWriter<Long> POS_WRITER = ValueWriters.longs();
        private final DatumWriter<D> rowWriter;

        private PositionAndRowDatumWriter(DatumWriter<D> rowWriter) {
            this.rowWriter = rowWriter;
        }

        @Override
        public void setSchema(org.apache.iceberg.shaded.org.apache.avro.Schema schema) {
            Schema.Field rowField = schema.getField("row");
            if (rowField != null) {
                this.rowWriter.setSchema(rowField.schema());
            }
        }

        @Override
        public void write(PositionDelete<D> delete, Encoder out) throws IOException {
            PATH_WRITER.write(delete.path(), out);
            POS_WRITER.write(delete.pos(), out);
            this.rowWriter.write(delete.row(), out);
        }
    }

    private static class PositionDatumWriter
    implements DatumWriter<PositionDelete<?>> {
        private static final ValueWriter<Object> PATH_WRITER = ValueWriters.strings();
        private static final ValueWriter<Long> POS_WRITER = ValueWriters.longs();

        private PositionDatumWriter() {
        }

        @Override
        public void setSchema(org.apache.iceberg.shaded.org.apache.avro.Schema schema) {
        }

        @Override
        public void write(PositionDelete<?> delete, Encoder out) throws IOException {
            PATH_WRITER.write(delete.path(), out);
            POS_WRITER.write(delete.pos(), out);
        }
    }

    public static class DeleteWriteBuilder {
        private final WriteBuilder appenderBuilder;
        private final String location;
        private Function<org.apache.iceberg.shaded.org.apache.avro.Schema, DatumWriter<?>> createWriterFunc = null;
        private Schema rowSchema;
        private PartitionSpec spec;
        private StructLike partition;
        private EncryptionKeyMetadata keyMetadata = null;
        private int[] equalityFieldIds = null;

        private DeleteWriteBuilder(OutputFile file) {
            this.appenderBuilder = Avro.write(file);
            this.location = file.location();
        }

        public DeleteWriteBuilder forTable(Table table) {
            this.rowSchema(table.schema());
            this.withSpec(table.spec());
            this.setAll(table.properties());
            return this;
        }

        public DeleteWriteBuilder set(String property, String value) {
            this.appenderBuilder.set(property, value);
            return this;
        }

        public DeleteWriteBuilder setAll(Map<String, String> properties) {
            this.appenderBuilder.setAll(properties);
            return this;
        }

        public DeleteWriteBuilder meta(String property, String value) {
            this.appenderBuilder.meta(property, value);
            return this;
        }

        public DeleteWriteBuilder meta(Map<String, String> properties) {
            this.appenderBuilder.meta(properties);
            return this;
        }

        public DeleteWriteBuilder overwrite() {
            return this.overwrite(true);
        }

        public DeleteWriteBuilder overwrite(boolean enabled) {
            this.appenderBuilder.overwrite(enabled);
            return this;
        }

        public DeleteWriteBuilder createWriterFunc(Function<org.apache.iceberg.shaded.org.apache.avro.Schema, DatumWriter<?>> writerFunction) {
            this.createWriterFunc = writerFunction;
            return this;
        }

        public DeleteWriteBuilder rowSchema(Schema newRowSchema) {
            this.rowSchema = newRowSchema;
            return this;
        }

        public DeleteWriteBuilder withSpec(PartitionSpec newSpec) {
            this.spec = newSpec;
            return this;
        }

        public DeleteWriteBuilder withPartition(StructLike key) {
            this.partition = key;
            return this;
        }

        public DeleteWriteBuilder withKeyMetadata(EncryptionKeyMetadata metadata) {
            this.keyMetadata = metadata;
            return this;
        }

        public DeleteWriteBuilder equalityFieldIds(List<Integer> fieldIds) {
            this.equalityFieldIds = ArrayUtil.toIntArray(fieldIds);
            return this;
        }

        public DeleteWriteBuilder equalityFieldIds(int ... fieldIds) {
            this.equalityFieldIds = fieldIds;
            return this;
        }

        public <T> EqualityDeleteWriter<T> buildEqualityWriter() throws IOException {
            Preconditions.checkState(this.rowSchema != null, "Cannot create equality delete file without a schema`");
            Preconditions.checkState(this.equalityFieldIds != null, "Cannot create equality delete file without delete field ids");
            Preconditions.checkState(this.createWriterFunc != null, "Cannot create equality delete file unless createWriterFunc is set");
            this.meta("delete-type", "equality");
            this.meta("delete-field-ids", IntStream.of(this.equalityFieldIds).mapToObj(Objects::toString).collect(Collectors.joining(", ")));
            this.appenderBuilder.schema(this.rowSchema);
            this.appenderBuilder.createWriterFunc(this.createWriterFunc);
            return new EqualityDeleteWriter(this.appenderBuilder.build(), FileFormat.AVRO, this.location, this.spec, this.partition, this.keyMetadata, this.equalityFieldIds);
        }

        public <T> PositionDeleteWriter<T> buildPositionWriter() throws IOException {
            Preconditions.checkState(this.equalityFieldIds == null, "Cannot create position delete file using delete field ids");
            this.meta("delete-type", "position");
            if (this.rowSchema != null && this.createWriterFunc != null) {
                this.appenderBuilder.schema(new Schema(MetadataColumns.DELETE_FILE_PATH, MetadataColumns.DELETE_FILE_POS, Types.NestedField.optional(2147483544, "row", this.rowSchema.asStruct(), "Deleted row values")));
                this.appenderBuilder.createWriterFunc(avroSchema -> new PositionAndRowDatumWriter(this.createWriterFunc.apply((org.apache.iceberg.shaded.org.apache.avro.Schema)avroSchema)));
            } else {
                this.appenderBuilder.schema(new Schema(MetadataColumns.DELETE_FILE_PATH, MetadataColumns.DELETE_FILE_POS));
                this.appenderBuilder.createWriterFunc(ignored -> new PositionDatumWriter());
            }
            return new PositionDeleteWriter(this.appenderBuilder.build(), FileFormat.AVRO, this.location, this.spec, this.partition, this.keyMetadata);
        }
    }

    public static class WriteBuilder {
        private final OutputFile file;
        private final Map<String, String> config = Maps.newHashMap();
        private final Map<String, String> metadata = Maps.newLinkedHashMap();
        private Schema schema = null;
        private String name = "table";
        private Function<org.apache.iceberg.shaded.org.apache.avro.Schema, DatumWriter<?>> createWriterFunc = null;
        private boolean overwrite;

        private WriteBuilder(OutputFile file) {
            this.file = file;
        }

        public WriteBuilder forTable(Table table) {
            this.schema(table.schema());
            this.setAll(table.properties());
            return this;
        }

        public WriteBuilder schema(Schema newSchema) {
            this.schema = newSchema;
            return this;
        }

        public WriteBuilder named(String newName) {
            this.name = newName;
            return this;
        }

        public WriteBuilder createWriterFunc(Function<org.apache.iceberg.shaded.org.apache.avro.Schema, DatumWriter<?>> writerFunction) {
            this.createWriterFunc = writerFunction;
            return this;
        }

        public WriteBuilder set(String property, String value) {
            this.config.put(property, value);
            return this;
        }

        public WriteBuilder setAll(Map<String, String> properties) {
            this.config.putAll(properties);
            return this;
        }

        public WriteBuilder meta(String property, String value) {
            this.metadata.put(property, value);
            return this;
        }

        public WriteBuilder meta(Map<String, String> properties) {
            this.metadata.putAll(properties);
            return this;
        }

        public WriteBuilder overwrite() {
            return this.overwrite(true);
        }

        public WriteBuilder overwrite(boolean enabled) {
            this.overwrite = enabled;
            return this;
        }

        private CodecFactory codec() {
            String codec = this.config.getOrDefault("write.avro.compression-codec", "gzip");
            try {
                return CodecName.valueOf(codec.toUpperCase(Locale.ENGLISH)).get();
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Unsupported compression codec: " + codec);
            }
        }

        public <D> FileAppender<D> build() throws IOException {
            Preconditions.checkNotNull(this.schema, "Schema is required");
            Preconditions.checkNotNull(this.name, "Table name is required and cannot be null");
            Function<org.apache.iceberg.shaded.org.apache.avro.Schema, DatumWriter<?>> writerFunc = this.createWriterFunc != null ? this.createWriterFunc : GenericAvroWriter::new;
            this.meta("iceberg.schema", SchemaParser.toJson(this.schema));
            return new AvroFileAppender(AvroSchemaUtil.convert(this.schema, this.name), this.file, writerFunc, this.codec(), this.metadata, this.overwrite);
        }
    }

    private static enum CodecName {
        UNCOMPRESSED(CodecFactory.nullCodec()),
        SNAPPY(CodecFactory.snappyCodec()),
        GZIP(CodecFactory.deflateCodec(9)),
        LZ4(null),
        BROTLI(null),
        ZSTD(null);

        private final CodecFactory avroCodec;

        private CodecName(CodecFactory avroCodec) {
            this.avroCodec = avroCodec;
        }

        public CodecFactory get() {
            Preconditions.checkArgument(this.avroCodec != null, "Missing implementation for codec %s", (Object)this);
            return this.avroCodec;
        }
    }
}

