/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import java.io.IOException;
import java.util.Map;
import java.util.function.Function;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.io.PositionOutputStream;
import org.apache.iceberg.shaded.org.apache.avro.Schema;
import org.apache.iceberg.shaded.org.apache.avro.file.CodecFactory;
import org.apache.iceberg.shaded.org.apache.avro.file.DataFileWriter;
import org.apache.iceberg.shaded.org.apache.avro.io.DatumWriter;

class AvroFileAppender<D>
implements FileAppender<D> {
    private PositionOutputStream stream = null;
    private DataFileWriter<D> writer = null;
    private long numRecords = 0L;

    AvroFileAppender(Schema schema, OutputFile file, Function<Schema, DatumWriter<?>> createWriterFunc, CodecFactory codec, Map<String, String> metadata, boolean overwrite) throws IOException {
        this.stream = overwrite ? file.createOrOverwrite() : file.create();
        this.writer = AvroFileAppender.newAvroWriter(schema, this.stream, createWriterFunc, codec, metadata);
    }

    @Override
    public void add(D datum) {
        try {
            ++this.numRecords;
            this.writer.append(datum);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public Metrics metrics() {
        return new Metrics(this.numRecords, null, null, null);
    }

    @Override
    public long length() {
        if (this.stream != null) {
            try {
                return this.stream.getPos();
            }
            catch (IOException e) {
                throw new RuntimeIOException(e, "Failed to get stream length", new Object[0]);
            }
        }
        throw new RuntimeIOException("Failed to get stream length: no open stream", new Object[0]);
    }

    @Override
    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
    }

    private static <D> DataFileWriter<D> newAvroWriter(Schema schema, PositionOutputStream stream, Function<Schema, DatumWriter<?>> createWriterFunc, CodecFactory codec, Map<String, String> metadata) throws IOException {
        DataFileWriter writer = new DataFileWriter(createWriterFunc.apply(schema));
        writer.setCodec(codec);
        for (Map.Entry<String, String> entry : metadata.entrySet()) {
            writer.setMeta(entry.getKey(), entry.getValue());
        }
        return writer.create(schema, stream);
    }
}

