/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.Accessor;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.avro.DataReader;
import org.apache.iceberg.data.parquet.GenericParquetReaders;
import org.apache.iceberg.deletes.Deletes;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Multimap;
import org.apache.iceberg.relocated.com.google.common.collect.Multimaps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.shaded.org.apache.parquet.Preconditions;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructLikeSet;
import org.apache.iceberg.util.StructProjection;

public abstract class DeleteFilter<T> {
    private static final long DEFAULT_SET_FILTER_THRESHOLD = 100000L;
    private static final Schema POS_DELETE_SCHEMA = new Schema(MetadataColumns.DELETE_FILE_PATH, MetadataColumns.DELETE_FILE_POS);
    private final long setFilterThreshold;
    private final DataFile dataFile;
    private final List<DeleteFile> posDeletes;
    private final List<DeleteFile> eqDeletes;
    private final Schema requiredSchema;
    private final Accessor<StructLike> posAccessor;

    protected DeleteFilter(FileScanTask task, Schema tableSchema, Schema requestedSchema) {
        this.setFilterThreshold = 100000L;
        this.dataFile = task.file();
        ImmutableList.Builder posDeleteBuilder = ImmutableList.builder();
        ImmutableList.Builder eqDeleteBuilder = ImmutableList.builder();
        block4: for (DeleteFile delete : task.deletes()) {
            switch (delete.content()) {
                case POSITION_DELETES: {
                    posDeleteBuilder.add(delete);
                    continue block4;
                }
                case EQUALITY_DELETES: {
                    eqDeleteBuilder.add(delete);
                    continue block4;
                }
            }
            throw new UnsupportedOperationException("Unknown delete file content: " + (Object)((Object)delete.content()));
        }
        this.posDeletes = posDeleteBuilder.build();
        this.eqDeletes = eqDeleteBuilder.build();
        this.requiredSchema = DeleteFilter.fileProjection(tableSchema, requestedSchema, this.posDeletes, this.eqDeletes);
        this.posAccessor = this.requiredSchema.accessorForField(MetadataColumns.ROW_POSITION.fieldId());
    }

    public Schema requiredSchema() {
        return this.requiredSchema;
    }

    Accessor<StructLike> posAccessor() {
        return this.posAccessor;
    }

    protected abstract StructLike asStructLike(T var1);

    protected abstract InputFile getInputFile(String var1);

    protected long pos(T record) {
        return (Long)this.posAccessor.get(this.asStructLike(record));
    }

    public CloseableIterable<T> filter(CloseableIterable<T> records) {
        return this.applyEqDeletes(this.applyPosDeletes(records));
    }

    private CloseableIterable<T> applyEqDeletes(CloseableIterable<T> records) {
        if (this.eqDeletes.isEmpty()) {
            return records;
        }
        Multimap<HashSet<Integer>, DeleteFile> filesByDeleteIds = Multimaps.newMultimap(Maps.newHashMap(), Lists::newArrayList);
        for (DeleteFile delete2 : this.eqDeletes) {
            filesByDeleteIds.put(Sets.newHashSet(delete2.equalityFieldIds()), delete2);
        }
        CloseableIterable<Object> filteredRecords = records;
        for (Map.Entry entry : filesByDeleteIds.asMap().entrySet()) {
            Set ids = (Set)entry.getKey();
            Iterable deletes = entry.getValue();
            Schema deleteSchema = TypeUtil.select(this.requiredSchema, (Set<Integer>)ids);
            StructProjection projectRow = StructProjection.create(this.requiredSchema, deleteSchema);
            Iterable deleteRecords = Iterables.transform(deletes, delete -> this.openDeletes((DeleteFile)delete, deleteSchema));
            StructLikeSet deleteSet = Deletes.toEqualitySet(CloseableIterable.transform(CloseableIterable.concat(deleteRecords), Record::copy), deleteSchema.asStruct());
            filteredRecords = Deletes.filter(filteredRecords, record -> projectRow.wrap(this.asStructLike(record)), deleteSet);
        }
        return filteredRecords;
    }

    private CloseableIterable<T> applyPosDeletes(CloseableIterable<T> records) {
        if (this.posDeletes.isEmpty()) {
            return records;
        }
        List deletes = Lists.transform(this.posDeletes, this::openPosDeletes);
        if (this.posDeletes.stream().mapToLong(ContentFile::recordCount).sum() < this.setFilterThreshold) {
            return Deletes.filter(records, this::pos, Deletes.toPositionSet(this.dataFile.path(), CloseableIterable.concat(deletes)));
        }
        return Deletes.streamingFilter(records, this::pos, Deletes.deletePositions(this.dataFile.path(), deletes));
    }

    private CloseableIterable<Record> openPosDeletes(DeleteFile file) {
        return this.openDeletes(file, POS_DELETE_SCHEMA);
    }

    private CloseableIterable<Record> openDeletes(DeleteFile deleteFile, Schema deleteSchema) {
        InputFile input = this.getInputFile(deleteFile.path().toString());
        switch (deleteFile.format()) {
            case AVRO: {
                return Avro.read(input).project(deleteSchema).reuseContainers().createReaderFunc(DataReader::create).build();
            }
            case PARQUET: {
                Parquet.ReadBuilder builder = Parquet.read(input).project(deleteSchema).reuseContainers().createReaderFunc(fileSchema -> GenericParquetReaders.buildReader(deleteSchema, fileSchema));
                if (deleteFile.content() == FileContent.POSITION_DELETES) {
                    builder.filter(Expressions.equal(MetadataColumns.DELETE_FILE_PATH.name(), this.dataFile.path()));
                }
                return builder.build();
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot read deletes, %s is not a supported format: %s", deleteFile.format().name(), deleteFile.path()));
    }

    private static Schema fileProjection(Schema tableSchema, Schema requestedSchema, List<DeleteFile> posDeletes, List<DeleteFile> eqDeletes) {
        if (posDeletes.isEmpty() && eqDeletes.isEmpty()) {
            return requestedSchema;
        }
        LinkedHashSet<Integer> requiredIds = Sets.newLinkedHashSet();
        if (!posDeletes.isEmpty()) {
            requiredIds.add(MetadataColumns.ROW_POSITION.fieldId());
        }
        for (DeleteFile eqDelete : eqDeletes) {
            requiredIds.addAll(eqDelete.equalityFieldIds());
        }
        LinkedHashSet missingIds = Sets.newLinkedHashSet(Sets.difference(requiredIds, TypeUtil.getProjectedIds(requestedSchema)));
        if (missingIds.isEmpty()) {
            return requestedSchema;
        }
        ArrayList<Types.NestedField> columns = Lists.newArrayList(requestedSchema.columns());
        Iterator iterator = missingIds.iterator();
        while (iterator.hasNext()) {
            int fieldId = (Integer)iterator.next();
            if (fieldId == MetadataColumns.ROW_POSITION.fieldId()) continue;
            Types.NestedField field = tableSchema.asStruct().field(fieldId);
            Preconditions.checkArgument(field != null, "Cannot find required field for ID %s", fieldId);
            columns.add(field);
        }
        if (missingIds.contains(MetadataColumns.ROW_POSITION.fieldId())) {
            columns.add(MetadataColumns.ROW_POSITION);
        }
        return new Schema(columns);
    }
}

