/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.Schema;
import org.apache.iceberg.expressions.Binder;
import org.apache.iceberg.expressions.BoundReference;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.ExpressionVisitors;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Types;

public class StrictMetricsEvaluator {
    private final Schema schema;
    private final Types.StructType struct;
    private final Expression expr;
    private static final boolean ROWS_MUST_MATCH = true;
    private static final boolean ROWS_MIGHT_NOT_MATCH = false;

    public StrictMetricsEvaluator(Schema schema, Expression unbound) {
        this.schema = schema;
        this.struct = schema.asStruct();
        this.expr = Binder.bind(this.struct, Expressions.rewriteNot(unbound), true);
    }

    public boolean eval(ContentFile<?> file) {
        return new MetricsEvalVisitor().eval(file);
    }

    private class MetricsEvalVisitor
    extends ExpressionVisitors.BoundExpressionVisitor<Boolean> {
        private Map<Integer, Long> valueCounts = null;
        private Map<Integer, Long> nullCounts = null;
        private Map<Integer, ByteBuffer> lowerBounds = null;
        private Map<Integer, ByteBuffer> upperBounds = null;

        private MetricsEvalVisitor() {
        }

        private boolean eval(ContentFile<?> file) {
            if (file.recordCount() <= 0L) {
                return true;
            }
            this.valueCounts = file.valueCounts();
            this.nullCounts = file.nullValueCounts();
            this.lowerBounds = file.lowerBounds();
            this.upperBounds = file.upperBounds();
            return ExpressionVisitors.visitEvaluator(StrictMetricsEvaluator.this.expr, this);
        }

        @Override
        public Boolean alwaysTrue() {
            return true;
        }

        @Override
        public Boolean alwaysFalse() {
            return false;
        }

        @Override
        public Boolean not(Boolean result) {
            return result == false;
        }

        @Override
        public Boolean and(Boolean leftResult, Boolean rightResult) {
            return leftResult != false && rightResult != false;
        }

        @Override
        public Boolean or(Boolean leftResult, Boolean rightResult) {
            return leftResult != false || rightResult != false;
        }

        @Override
        public <T> Boolean isNull(BoundReference<T> ref) {
            Integer id = ref.fieldId();
            Preconditions.checkNotNull(StrictMetricsEvaluator.this.struct.field(id), "Cannot filter by nested column: %s", (Object)StrictMetricsEvaluator.this.schema.findField(id));
            if (this.containsNullsOnly(id)) {
                return true;
            }
            return false;
        }

        @Override
        public <T> Boolean notNull(BoundReference<T> ref) {
            Integer id = ref.fieldId();
            Preconditions.checkNotNull(StrictMetricsEvaluator.this.struct.field(id), "Cannot filter by nested column: %s", (Object)StrictMetricsEvaluator.this.schema.findField(id));
            if (this.nullCounts != null && this.nullCounts.containsKey(id) && this.nullCounts.get(id) == 0L) {
                return true;
            }
            return false;
        }

        @Override
        public <T> Boolean lt(BoundReference<T> ref, Literal<T> lit) {
            Integer id = ref.fieldId();
            Types.NestedField field = StrictMetricsEvaluator.this.struct.field(id);
            Preconditions.checkNotNull(field, "Cannot filter by nested column: %s", (Object)StrictMetricsEvaluator.this.schema.findField(id));
            if (this.canContainNulls(id)) {
                return false;
            }
            if (this.upperBounds != null && this.upperBounds.containsKey(id)) {
                Object upper = Conversions.fromByteBuffer(field.type(), this.upperBounds.get(id));
                int cmp = lit.comparator().compare(upper, lit.value());
                if (cmp < 0) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public <T> Boolean ltEq(BoundReference<T> ref, Literal<T> lit) {
            Integer id = ref.fieldId();
            Types.NestedField field = StrictMetricsEvaluator.this.struct.field(id);
            Preconditions.checkNotNull(field, "Cannot filter by nested column: %s", (Object)StrictMetricsEvaluator.this.schema.findField(id));
            if (this.canContainNulls(id)) {
                return false;
            }
            if (this.upperBounds != null && this.upperBounds.containsKey(id)) {
                Object upper = Conversions.fromByteBuffer(field.type(), this.upperBounds.get(id));
                int cmp = lit.comparator().compare(upper, lit.value());
                if (cmp <= 0) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public <T> Boolean gt(BoundReference<T> ref, Literal<T> lit) {
            Integer id = ref.fieldId();
            Types.NestedField field = StrictMetricsEvaluator.this.struct.field(id);
            Preconditions.checkNotNull(field, "Cannot filter by nested column: %s", (Object)StrictMetricsEvaluator.this.schema.findField(id));
            if (this.canContainNulls(id)) {
                return false;
            }
            if (this.lowerBounds != null && this.lowerBounds.containsKey(id)) {
                Object lower = Conversions.fromByteBuffer(field.type(), this.lowerBounds.get(id));
                int cmp = lit.comparator().compare(lower, lit.value());
                if (cmp > 0) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public <T> Boolean gtEq(BoundReference<T> ref, Literal<T> lit) {
            Integer id = ref.fieldId();
            Types.NestedField field = StrictMetricsEvaluator.this.struct.field(id);
            Preconditions.checkNotNull(field, "Cannot filter by nested column: %s", (Object)StrictMetricsEvaluator.this.schema.findField(id));
            if (this.canContainNulls(id)) {
                return false;
            }
            if (this.lowerBounds != null && this.lowerBounds.containsKey(id)) {
                Object lower = Conversions.fromByteBuffer(field.type(), this.lowerBounds.get(id));
                int cmp = lit.comparator().compare(lower, lit.value());
                if (cmp >= 0) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public <T> Boolean eq(BoundReference<T> ref, Literal<T> lit) {
            Integer id = ref.fieldId();
            Types.NestedField field = StrictMetricsEvaluator.this.struct.field(id);
            Preconditions.checkNotNull(field, "Cannot filter by nested column: %s", (Object)StrictMetricsEvaluator.this.schema.findField(id));
            if (this.canContainNulls(id)) {
                return false;
            }
            if (this.lowerBounds != null && this.lowerBounds.containsKey(id) && this.upperBounds != null && this.upperBounds.containsKey(id)) {
                Object lower = Conversions.fromByteBuffer(StrictMetricsEvaluator.this.struct.field(id).type(), this.lowerBounds.get(id));
                int cmp = lit.comparator().compare(lower, lit.value());
                if (cmp != 0) {
                    return false;
                }
                Object upper = Conversions.fromByteBuffer(field.type(), this.upperBounds.get(id));
                cmp = lit.comparator().compare(upper, lit.value());
                if (cmp != 0) {
                    return false;
                }
                return true;
            }
            return false;
        }

        @Override
        public <T> Boolean notEq(BoundReference<T> ref, Literal<T> lit) {
            int cmp;
            Integer id = ref.fieldId();
            Types.NestedField field = StrictMetricsEvaluator.this.struct.field(id);
            Preconditions.checkNotNull(field, "Cannot filter by nested column: %s", (Object)StrictMetricsEvaluator.this.schema.findField(id));
            if (this.containsNullsOnly(id)) {
                return true;
            }
            if (this.lowerBounds != null && this.lowerBounds.containsKey(id)) {
                Object lower = Conversions.fromByteBuffer(StrictMetricsEvaluator.this.struct.field(id).type(), this.lowerBounds.get(id));
                cmp = lit.comparator().compare(lower, lit.value());
                if (cmp > 0) {
                    return true;
                }
            }
            if (this.upperBounds != null && this.upperBounds.containsKey(id)) {
                Object upper = Conversions.fromByteBuffer(field.type(), this.upperBounds.get(id));
                cmp = lit.comparator().compare(upper, lit.value());
                if (cmp < 0) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public <T> Boolean in(BoundReference<T> ref, Set<T> literalSet) {
            Integer id = ref.fieldId();
            Types.NestedField field = StrictMetricsEvaluator.this.struct.field(id);
            Preconditions.checkNotNull(field, "Cannot filter by nested column: %s", (Object)StrictMetricsEvaluator.this.schema.findField(id));
            if (this.canContainNulls(id)) {
                return false;
            }
            if (this.lowerBounds != null && this.lowerBounds.containsKey(id) && this.upperBounds != null && this.upperBounds.containsKey(id)) {
                Object lower = Conversions.fromByteBuffer(StrictMetricsEvaluator.this.struct.field(id).type(), this.lowerBounds.get(id));
                if (!literalSet.contains(lower)) {
                    return false;
                }
                Object upper = Conversions.fromByteBuffer(field.type(), this.upperBounds.get(id));
                if (!literalSet.contains(upper)) {
                    return false;
                }
                if (ref.comparator().compare(lower, upper) != 0) {
                    return false;
                }
                return true;
            }
            return false;
        }

        @Override
        public <T> Boolean notIn(BoundReference<T> ref, Set<T> literalSet) {
            Integer id = ref.fieldId();
            Types.NestedField field = StrictMetricsEvaluator.this.struct.field(id);
            Preconditions.checkNotNull(field, "Cannot filter by nested column: %s", (Object)StrictMetricsEvaluator.this.schema.findField(id));
            if (this.containsNullsOnly(id)) {
                return true;
            }
            Collection<Object> literals = literalSet;
            if (this.lowerBounds != null && this.lowerBounds.containsKey(id)) {
                Object lower = Conversions.fromByteBuffer(StrictMetricsEvaluator.this.struct.field(id).type(), this.lowerBounds.get(id));
                if ((literals = (Collection)literals.stream().filter(v -> ref.comparator().compare(lower, v) <= 0).collect(Collectors.toList())).isEmpty()) {
                    return true;
                }
            }
            if (this.upperBounds != null && this.upperBounds.containsKey(id)) {
                Object upper = Conversions.fromByteBuffer(field.type(), this.upperBounds.get(id));
                if ((literals = (Collection)literals.stream().filter(v -> ref.comparator().compare(upper, v) >= 0).collect(Collectors.toList())).isEmpty()) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public <T> Boolean startsWith(BoundReference<T> ref, Literal<T> lit) {
            return false;
        }

        private boolean canContainNulls(Integer id) {
            return this.nullCounts == null || this.nullCounts.containsKey(id) && this.nullCounts.get(id) > 0L;
        }

        private boolean containsNullsOnly(Integer id) {
            return this.valueCounts != null && this.valueCounts.containsKey(id) && this.nullCounts != null && this.nullCounts.containsKey(id) && this.valueCounts.get(id) - this.nullCounts.get(id) == 0L;
        }
    }
}

