/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink;

import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeVisitor;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.iceberg.Schema;
import org.apache.iceberg.flink.FlinkFixupTypes;
import org.apache.iceberg.flink.FlinkTypeToType;
import org.apache.iceberg.flink.TypeToFlinkType;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;

public class FlinkSchemaUtil {
    private FlinkSchemaUtil() {
    }

    public static Schema convert(TableSchema schema) {
        LogicalType schemaType = schema.toRowDataType().getLogicalType();
        Preconditions.checkArgument(schemaType instanceof RowType, "Schema logical type should be RowType.");
        RowType root = (RowType)schemaType;
        Type converted = (Type)root.accept((LogicalTypeVisitor)new FlinkTypeToType(root));
        return new Schema(converted.asStructType().fields());
    }

    public static Schema convert(Schema baseSchema, TableSchema flinkSchema) {
        Types.StructType struct = FlinkSchemaUtil.convert(flinkSchema).asStruct();
        Schema schema = TypeUtil.reassignIds(new Schema(struct.fields()), baseSchema);
        return FlinkFixupTypes.fixup(schema, baseSchema);
    }

    public static RowType convert(Schema schema) {
        return (RowType)TypeUtil.visit(schema, new TypeToFlinkType());
    }

    public static LogicalType convert(Type type) {
        return TypeUtil.visit(type, new TypeToFlinkType());
    }

    public static TableSchema toSchema(RowType rowType) {
        TableSchema.Builder builder = TableSchema.builder();
        for (RowType.RowField field : rowType.getFields()) {
            builder.field(field.getName(), TypeConversions.fromLogicalToDataType((LogicalType)field.getType()));
        }
        return builder.build();
    }
}

