/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink;

import java.util.Map;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.sinks.AppendStreamTableSink;
import org.apache.flink.table.sinks.OverwritableTableSink;
import org.apache.flink.table.sinks.PartitionableTableSink;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.Preconditions;
import org.apache.iceberg.flink.TableLoader;
import org.apache.iceberg.flink.sink.FlinkSink;

public class IcebergTableSink
implements AppendStreamTableSink<RowData>,
OverwritableTableSink,
PartitionableTableSink {
    private final boolean isBounded;
    private final TableLoader tableLoader;
    private final TableSchema tableSchema;
    private boolean overwrite = false;

    public IcebergTableSink(boolean isBounded, TableLoader tableLoader, TableSchema tableSchema) {
        this.isBounded = isBounded;
        this.tableLoader = tableLoader;
        this.tableSchema = tableSchema;
    }

    public DataStreamSink<?> consumeDataStream(DataStream<RowData> dataStream) {
        Preconditions.checkState((!this.overwrite || this.isBounded ? 1 : 0) != 0, (Object)"Unbounded data stream doesn't support overwrite operation.");
        return FlinkSink.forRowData(dataStream).tableLoader(this.tableLoader).tableSchema(this.tableSchema).overwrite(this.overwrite).build();
    }

    public DataType getConsumedDataType() {
        return (DataType)this.tableSchema.toRowDataType().bridgedTo(RowData.class);
    }

    public TableSchema getTableSchema() {
        return this.tableSchema;
    }

    public TableSink<RowData> configure(String[] fieldNames, TypeInformation<?>[] fieldTypes) {
        return this;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void setStaticPartition(Map<String, String> partitions) {
    }
}

